/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.target;

import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.TargetSource;
import org.springframework.aop.target.SingletonTargetSource;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;

public abstract class AbstractBeanFactoryBasedTargetSource
implements TargetSource,
BeanFactoryAware,
Serializable {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String targetBeanName;
    private BeanFactory beanFactory;
    private Class targetClass;

    public void setTargetBeanName(String targetBeanName) {
        this.targetBeanName = targetBeanName;
    }

    public String getTargetBeanName() {
        return this.targetBeanName;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (this.targetBeanName == null) {
            throw new IllegalStateException("targetBeanName is required");
        }
        this.beanFactory = beanFactory;
        this.targetClass = this.beanFactory.getType(this.targetBeanName);
        if (this.targetClass == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Getting bean with name '" + this.targetBeanName + "' to determine type"));
            }
            this.targetClass = this.beanFactory.getBean(this.targetBeanName).getClass();
        }
    }

    public BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public Class getTargetClass() {
        return this.targetClass;
    }

    public boolean isStatic() {
        return false;
    }

    public void releaseTarget(Object target) throws Exception {
    }

    protected Object writeReplace() throws ObjectStreamException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Disconnecting TargetSource [" + this + "]"));
        }
        try {
            SingletonTargetSource disconnectedTargetSource = new SingletonTargetSource(this.getTarget());
            return disconnectedTargetSource;
        }
        catch (Exception ex) {
            this.logger.error((Object)("Cannot get target for disconnecting TargetSource [" + this + "]"), (Throwable)ex);
            throw new NotSerializableException("Cannot get target for disconnecting TargetSource [" + this + "]: " + ex.getMessage());
        }
    }
}

