/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.framework.autoproxy;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.springframework.aop.Advisor;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.autoproxy.AbstractAutoProxyCreator;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.ControlFlow;
import org.springframework.core.ControlFlowFactory;
import org.springframework.core.OrderComparator;

public abstract class AbstractAdvisorAutoProxyCreator
extends AbstractAutoProxyCreator {
    public void setBeanFactory(BeanFactory beanFactory) {
        super.setBeanFactory(beanFactory);
        this.findCandidateAdvisors();
    }

    protected Object[] getAdvicesAndAdvisorsForBean(Class beanClass, String name, TargetSource targetSource) {
        List advisors = this.findEligibleAdvisors(beanClass);
        if (advisors.isEmpty()) {
            return DO_NOT_PROXY;
        }
        advisors = this.sortAdvisors(advisors);
        return advisors.toArray();
    }

    protected List findEligibleAdvisors(Class clazz) {
        List candidateAdvisors = this.findCandidateAdvisors();
        LinkedList<Advisor> eligibleAdvisors = new LinkedList<Advisor>();
        Iterator it = candidateAdvisors.iterator();
        while (it.hasNext()) {
            Advisor candidate = (Advisor)it.next();
            if (AopUtils.canApply(candidate, clazz)) {
                eligibleAdvisors.add(candidate);
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Candidate advisor [" + candidate + "] accepted for class [" + clazz.getName() + "]"));
                continue;
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("Candidate advisor [" + candidate + "] rejected for class [" + clazz.getName() + "]"));
        }
        return eligibleAdvisors;
    }

    protected List sortAdvisors(List advisors) {
        Collections.sort(advisors, new OrderComparator());
        return advisors;
    }

    protected boolean shouldSkip(Class beanClass, String name) {
        ControlFlow cflow = ControlFlowFactory.createControlFlow();
        return cflow.under(this.getClass(), "findCandidateAdvisors");
    }

    protected abstract List findCandidateAdvisors();
}

