/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Registration;
import org.jivesoftware.smack.util.StringUtils;

public class AccountManager {
    private XMPPConnection connection;
    private Registration info = null;
    static /* synthetic */ Class class$org$jivesoftware$smack$packet$IQ;

    public AccountManager(XMPPConnection connection) {
        this.connection = connection;
    }

    public boolean supportsAccountCreation() {
        try {
            if (this.info == null) {
                this.getRegistrationInfo();
            }
            return this.info.getType() != IQ.Type.ERROR;
        }
        catch (XMPPException xe) {
            return false;
        }
    }

    public Iterator getAccountAttributes() {
        try {
            Map attributes;
            if (this.info == null) {
                this.getRegistrationInfo();
            }
            if ((attributes = this.info.getAttributes()) != null) {
                return attributes.keySet().iterator();
            }
        }
        catch (XMPPException xMPPException) {
            // empty catch block
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public String getAccountAttribute(String name) {
        try {
            if (this.info == null) {
                this.getRegistrationInfo();
            }
            return (String)this.info.getAttributes().get(name);
        }
        catch (XMPPException xMPPException) {
            return null;
        }
    }

    public String getAccountInstructions() {
        try {
            if (this.info == null) {
                this.getRegistrationInfo();
            }
            return this.info.getInstructions();
        }
        catch (XMPPException xe) {
            return null;
        }
    }

    public void createAccount(String username, String password) throws XMPPException {
        if (!this.supportsAccountCreation()) {
            throw new XMPPException("Server does not support account creation.");
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        Iterator i = this.getAccountAttributes();
        while (i.hasNext()) {
            String attributeName = (String)i.next();
            attributes.put(attributeName, "");
        }
        this.createAccount(username, password, attributes);
    }

    public void createAccount(String username, String password, Map attributes) throws XMPPException {
        if (!this.supportsAccountCreation()) {
            throw new XMPPException("Server does not support account creation.");
        }
        Registration reg = new Registration();
        reg.setType(IQ.Type.SET);
        reg.setTo(this.connection.getServiceName());
        attributes.put("username", username);
        attributes.put("password", password);
        reg.setAttributes(attributes);
        AndFilter filter = new AndFilter(new PacketIDFilter(reg.getPacketID()), new PacketTypeFilter(class$org$jivesoftware$smack$packet$IQ == null ? (class$org$jivesoftware$smack$packet$IQ = AccountManager.class$("org.jivesoftware.smack.packet.IQ")) : class$org$jivesoftware$smack$packet$IQ));
        PacketCollector collector = this.connection.createPacketCollector(filter);
        this.connection.sendPacket(reg);
        IQ result = (IQ)collector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (result == null) {
            throw new XMPPException("No response from server.");
        }
        if (result.getType() == IQ.Type.ERROR) {
            throw new XMPPException(result.getError());
        }
    }

    public void changePassword(String newPassword) throws XMPPException {
        Registration reg = new Registration();
        reg.setType(IQ.Type.SET);
        reg.setTo(this.connection.getServiceName());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("username", StringUtils.parseName(this.connection.getUser()));
        map.put("password", newPassword);
        reg.setAttributes(map);
        AndFilter filter = new AndFilter(new PacketIDFilter(reg.getPacketID()), new PacketTypeFilter(class$org$jivesoftware$smack$packet$IQ == null ? (class$org$jivesoftware$smack$packet$IQ = AccountManager.class$("org.jivesoftware.smack.packet.IQ")) : class$org$jivesoftware$smack$packet$IQ));
        PacketCollector collector = this.connection.createPacketCollector(filter);
        this.connection.sendPacket(reg);
        IQ result = (IQ)collector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (result == null) {
            throw new XMPPException("No response from server.");
        }
        if (result.getType() == IQ.Type.ERROR) {
            throw new XMPPException(result.getError());
        }
    }

    public void deleteAccount() throws XMPPException {
        if (!this.connection.isAuthenticated()) {
            throw new IllegalStateException("Must be logged in to delete a account.");
        }
        Registration reg = new Registration();
        reg.setType(IQ.Type.SET);
        reg.setTo(this.connection.getServiceName());
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("remove", "");
        reg.setAttributes(attributes);
        AndFilter filter = new AndFilter(new PacketIDFilter(reg.getPacketID()), new PacketTypeFilter(class$org$jivesoftware$smack$packet$IQ == null ? (class$org$jivesoftware$smack$packet$IQ = AccountManager.class$("org.jivesoftware.smack.packet.IQ")) : class$org$jivesoftware$smack$packet$IQ));
        PacketCollector collector = this.connection.createPacketCollector(filter);
        this.connection.sendPacket(reg);
        IQ result = (IQ)collector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (result == null) {
            throw new XMPPException("No response from server.");
        }
        if (result.getType() == IQ.Type.ERROR) {
            throw new XMPPException(result.getError());
        }
    }

    private synchronized void getRegistrationInfo() throws XMPPException {
        Registration reg = new Registration();
        reg.setTo(this.connection.getServiceName());
        AndFilter filter = new AndFilter(new PacketIDFilter(reg.getPacketID()), new PacketTypeFilter(class$org$jivesoftware$smack$packet$IQ == null ? (class$org$jivesoftware$smack$packet$IQ = AccountManager.class$("org.jivesoftware.smack.packet.IQ")) : class$org$jivesoftware$smack$packet$IQ));
        PacketCollector collector = this.connection.createPacketCollector(filter);
        this.connection.sendPacket(reg);
        IQ result = (IQ)collector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (result == null) {
            throw new XMPPException("No response from server.");
        }
        if (result.getType() == IQ.Type.ERROR) {
            throw new XMPPException(result.getError());
        }
        this.info = (Registration)result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

