/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.unix;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.FileUtils;

public class Symlink
extends Task {
    private String resource;
    private String link;
    private String action;
    private Vector fileSets = new Vector();
    private String linkFileName;
    private boolean overwrite;
    private boolean failonerror;

    public void init() throws BuildException {
        super.init();
        this.failonerror = true;
        this.overwrite = false;
        this.action = "single";
        this.fileSets = new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        block24: {
            block23: {
                try {
                    if (this.action.equals("single")) {
                        this.doLink(this.resource, this.link);
                    } else if (this.action.equals("delete")) {
                        try {
                            this.log("Removing symlink: " + this.link);
                            Symlink.deleteSymlink(this.link);
                        }
                        catch (FileNotFoundException fnfe) {
                            this.handleError(fnfe.toString());
                        }
                        catch (IOException ioe) {
                            this.handleError(ioe.toString());
                        }
                    } else if (this.action.equals("recreate")) {
                        if (this.fileSets.size() == 0) {
                            this.handleError("File set identifying link file(s) required for action recreate");
                            Object var13_5 = null;
                            this.resource = null;
                            this.link = null;
                            this.action = "single";
                            this.fileSets = new Vector();
                            this.linkFileName = null;
                            this.overwrite = false;
                            this.failonerror = true;
                            return;
                        }
                        Properties listOfLinks = this.loadLinks(this.fileSets);
                        Enumeration keys = ((Hashtable)listOfLinks).keys();
                        while (keys.hasMoreElements()) {
                            this.link = (String)keys.nextElement();
                            this.resource = listOfLinks.getProperty(this.link);
                            this.doLink(this.resource, this.link);
                        }
                    } else if (this.action.equals("record")) {
                        Hashtable byDir = new Hashtable();
                        if (this.fileSets.size() == 0) {
                            this.handleError("File set identifying links to record required");
                            break block23;
                        }
                        if (this.linkFileName == null) {
                            this.handleError("Name of file to record links in required");
                            break block24;
                        }
                        Vector vectOfLinks = this.findLinks(this.fileSets);
                        Enumeration links = vectOfLinks.elements();
                        while (links.hasMoreElements()) {
                            File thisLink = (File)links.nextElement();
                            String parent = thisLink.getParent();
                            if (byDir.containsKey(parent)) {
                                ((Vector)byDir.get(parent)).addElement(thisLink);
                                continue;
                            }
                            byDir.put(parent, new Vector());
                            ((Vector)byDir.get(parent)).addElement(thisLink);
                        }
                        Enumeration dirs = byDir.keys();
                        while (dirs.hasMoreElements()) {
                            String dir = (String)dirs.nextElement();
                            Vector linksInDir = (Vector)byDir.get(dir);
                            Properties linksToStore = new Properties();
                            Enumeration eachlink = linksInDir.elements();
                            while (eachlink.hasMoreElements()) {
                                File alink = (File)eachlink.nextElement();
                                try {
                                    ((Hashtable)linksToStore).put(alink.getName(), alink.getCanonicalPath());
                                }
                                catch (IOException ioe) {
                                    this.handleError("Couldn't get canonical name of a parent link");
                                }
                            }
                            File writeTo = new File(dir + File.separator + this.linkFileName);
                            this.writePropertyFile(linksToStore, writeTo, "Symlinks from " + writeTo.getParent());
                        }
                    } else {
                        this.handleError("Invalid action specified in symlink");
                    }
                    Object var13_8 = null;
                    this.resource = null;
                    this.link = null;
                    this.action = "single";
                    this.fileSets = new Vector();
                    this.linkFileName = null;
                    this.overwrite = false;
                    this.failonerror = true;
                    return;
                }
                catch (Throwable throwable) {
                    Object var13_9 = null;
                    this.resource = null;
                    this.link = null;
                    this.action = "single";
                    this.fileSets = new Vector();
                    this.linkFileName = null;
                    this.overwrite = false;
                    this.failonerror = true;
                    throw throwable;
                }
            }
            Object var13_6 = null;
            this.resource = null;
            this.link = null;
            this.action = "single";
            this.fileSets = new Vector();
            this.linkFileName = null;
            this.overwrite = false;
            this.failonerror = true;
            return;
        }
        Object var13_7 = null;
        this.resource = null;
        this.link = null;
        this.action = "single";
        this.fileSets = new Vector();
        this.linkFileName = null;
        this.overwrite = false;
        this.failonerror = true;
    }

    public void setOverwrite(boolean owrite) {
        this.overwrite = owrite;
    }

    public void setFailOnError(boolean foe) {
        this.failonerror = foe;
    }

    public void setAction(String typ) {
        this.action = typ;
    }

    public void setLink(String lnk) {
        this.link = lnk;
    }

    public void setResource(String src) {
        this.resource = src;
    }

    public void setLinkfilename(String lf) {
        this.linkFileName = lf;
    }

    public void addFileset(FileSet set) {
        this.fileSets.addElement(set);
    }

    public static void deleteSymlink(String path) throws IOException, FileNotFoundException {
        File linkfil = new File(path);
        Symlink.deleteSymlink(linkfil);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteSymlink(File linkfil) throws IOException, FileNotFoundException {
        if (!linkfil.exists()) {
            throw new FileNotFoundException("No such symlink: " + linkfil);
        }
        String canstr = linkfil.getCanonicalPath();
        File canfil = new File(canstr);
        String parentStr = canfil.getParent();
        File parentDir = new File(parentStr);
        FileUtils fu = FileUtils.newFileUtils();
        File temp = fu.createTempFile("symlink", ".tmp", parentDir);
        temp.deleteOnExit();
        try {
            try {
                fu.rename(canfil, temp);
            }
            catch (IOException e) {
                throw new IOException("Couldn't rename resource when attempting to delete " + linkfil);
            }
            if (!linkfil.delete()) {
                throw new IOException("Couldn't delete symlink: " + linkfil + " (was it a real file? is this not a " + "UNIX system?)");
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            try {
                fu.rename(temp, canfil);
            }
            catch (IOException e) {
                throw new IOException("Couldn't return resource " + temp + " to its original name: " + canstr + "\n THE RESOURCE'S NAME ON DISK HAS " + "BEEN CHANGED BY THIS ERROR!\n");
            }
            throw throwable;
        }
        try {
            fu.rename(temp, canfil);
        }
        catch (IOException e) {
            throw new IOException("Couldn't return resource " + temp + " to its original name: " + canstr + "\n THE RESOURCE'S NAME ON DISK HAS " + "BEEN CHANGED BY THIS ERROR!\n");
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writePropertyFile(Properties properties, File propertyfile, String comment) throws BuildException {
        FileOutputStream fos = null;
        fos = new FileOutputStream(propertyfile);
        properties.store(fos, comment);
        Object var7_5 = null;
        if (fos == null) return;
        try {
            fos.close();
            return;
        }
        catch (IOException ioex) {
            this.log("Failed to close output stream");
        }
        return;
        {
            catch (IOException ioe) {
                throw new BuildException((Throwable)ioe, this.getLocation());
            }
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (fos == null) throw throwable;
            try {
                fos.close();
                throw throwable;
            }
            catch (IOException ioex) {
                this.log("Failed to close output stream");
            }
            throw throwable;
        }
    }

    private void handleError(String msg) {
        if (this.failonerror) {
            throw new BuildException(msg);
        }
        this.log(msg);
    }

    private void doLink(String resource, String link) throws BuildException {
        if (resource == null) {
            this.handleError("Must define the resource to symlink to!");
            return;
        }
        if (link == null) {
            this.handleError("Must define the link name for symlink!");
            return;
        }
        File linkfil = new File(link);
        String[] cmd = new String[]{"ln", "-s", resource, link};
        try {
            if (this.overwrite && linkfil.exists()) {
                Symlink.deleteSymlink(linkfil);
            }
        }
        catch (FileNotFoundException fnfe) {
            this.handleError("Symlink dissapeared before it was deleted:" + link);
        }
        catch (IOException ioe) {
            this.handleError("Unable to overwrite preexisting link " + link);
        }
        this.log(cmd[0] + " " + cmd[1] + " " + cmd[2] + " " + cmd[3]);
        Execute.runCommand((Task)this, (String[])cmd);
    }

    private Vector scanDirsAndFiles(DirectoryScanner ds) {
        int i;
        Vector<String> list = new Vector<String>();
        ds.scan();
        String[] files = ds.getIncludedFiles();
        String[] dirs = ds.getIncludedDirectories();
        for (i = 0; i < files.length; ++i) {
            list.addElement(files[i]);
        }
        for (i = 0; i < dirs.length; ++i) {
            list.addElement(dirs[i]);
        }
        return list;
    }

    private Vector findLinks(Vector fileSets) {
        Vector<File> result = new Vector<File>();
        block6: for (int i = 0; i < fileSets.size(); ++i) {
            File next;
            FileSet fsTemp = (FileSet)fileSets.elementAt(i);
            String workingDir = null;
            Vector links = new Vector();
            Vector<File> linksFiles = new Vector<File>();
            File tmpfil = null;
            try {
                tmpfil = fsTemp.getDir(this.getProject());
                workingDir = tmpfil.getCanonicalPath();
            }
            catch (IOException ioe) {
                this.handleError("Exception caught getting canonical path of working dir " + tmpfil + " in a FileSet passed to the symlink " + "task. Further processing of this " + "fileset skipped");
                continue;
            }
            DirectoryScanner ds = fsTemp.getDirectoryScanner(this.getProject());
            links = this.scanDirsAndFiles(ds);
            Enumeration enumLinks = links.elements();
            while (enumLinks.hasMoreElements()) {
                linksFiles.addElement(new File(workingDir + File.separator + (String)enumLinks.nextElement()));
            }
            enumLinks = linksFiles.elements();
            FileUtils fu = FileUtils.newFileUtils();
            Vector<File> removals = new Vector<File>();
            while (enumLinks.hasMoreElements()) {
                next = (File)enumLinks.nextElement();
                String nameParentNext = next.getParent();
                File parentNext = new File(nameParentNext);
                try {
                    if (fu.isSymbolicLink(parentNext, next.getName())) continue;
                    removals.addElement(next);
                }
                catch (IOException ioe) {
                    this.handleError("Failed checking " + next + " for symbolic link. FileSet skipped.");
                    continue block6;
                }
            }
            enumLinks = removals.elements();
            while (enumLinks.hasMoreElements()) {
                linksFiles.removeElement(enumLinks.nextElement());
            }
            enumLinks = linksFiles.elements();
            while (enumLinks.hasMoreElements()) {
                next = (File)enumLinks.nextElement();
                try {
                    File parent = new File(next.getParent());
                    File temp = new File(parent = new File(parent.getCanonicalPath()), next.getName());
                    if (result.contains(temp)) continue;
                    result.addElement(temp);
                }
                catch (IOException ioe) {
                    this.handleError("IOException: " + next + " omitted");
                }
            }
        }
        return result;
    }

    private Properties loadLinks(Vector fileSets) {
        Properties finalList = new Properties();
        block5: for (int i = 0; i < fileSets.size(); ++i) {
            String workingDir;
            FileSet fsTemp = (FileSet)fileSets.elementAt(i);
            try {
                File linelength = fsTemp.getDir(this.getProject());
                workingDir = linelength.getCanonicalPath();
            }
            catch (IOException ioe) {
                this.handleError("Exception caught getting canonical path of working dir of a FileSet passed to symlink task. FileSet skipped.");
                continue;
            }
            DirectoryScanner ds = fsTemp.getDirectoryScanner(this.getProject());
            ds.setFollowSymlinks(false);
            ds.scan();
            String[] includedFiles = ds.getIncludedFiles();
            for (int j = 0; j < includedFiles.length; ++j) {
                String inDir;
                File inc = new File(workingDir + File.separator + includedFiles[j]);
                Properties propTemp = new Properties();
                try {
                    propTemp.load(new FileInputStream(inc));
                    inDir = inc.getParent();
                    inDir = new File(inDir).getCanonicalPath();
                }
                catch (FileNotFoundException fnfe) {
                    this.handleError("Unable to find " + includedFiles[j] + "FileSet skipped.");
                    continue block5;
                }
                catch (IOException ioe) {
                    this.handleError("Unable to open " + includedFiles[j] + " or it's parent dir" + "FileSet skipped.");
                    continue block5;
                }
                Enumeration keys = ((Hashtable)propTemp).keys();
                propTemp.list(System.out);
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    String value = propTemp.getProperty(key);
                    ((Hashtable)finalList).put(inDir + File.separator + key, value);
                }
            }
        }
        return finalList;
    }
}

