/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.dotnet;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.util.FileUtils;

public class NetCommand {
    protected Task owner;
    protected Execute executable;
    protected Commandline commandLine;
    protected String title;
    protected String program;
    protected boolean traceCommandLine = false;
    protected boolean failOnError;
    private File directory;
    private boolean useResponseFile = false;
    private File temporaryCommandFile;
    private int automaticResponseFileThreshold = 64;

    public NetCommand(Task owner, String title, String program) {
        this.owner = owner;
        this.title = title;
        this.program = program;
        this.commandLine = new Commandline();
        this.commandLine.setExecutable(program);
        this.prepareExecutor();
    }

    public void setTraceCommandLine(boolean b) {
        this.traceCommandLine = b;
    }

    public void setFailOnError(boolean b) {
        this.failOnError = b;
    }

    public boolean getFailFailOnError() {
        return this.failOnError;
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    protected void logVerbose(String msg) {
        this.owner.getProject().log(msg, 3);
    }

    protected void logError(String msg) {
        this.owner.getProject().log(msg, 0);
    }

    public void addArgument(String argument) {
        if (argument != null && argument.length() != 0) {
            this.commandLine.createArgument().setValue(argument);
        }
    }

    public void addArgument(String argument1, String argument2) {
        if (argument2 != null && argument2.length() != 0) {
            this.commandLine.createArgument().setValue(argument1 + argument2);
        }
    }

    public boolean isUseResponseFile() {
        return this.useResponseFile;
    }

    public void setUseResponseFile(boolean useResponseFile) {
        this.useResponseFile = useResponseFile;
    }

    public int getAutomaticResponseFileThreshold() {
        return this.automaticResponseFileThreshold;
    }

    public void setAutomaticResponseFileThreshold(int automaticResponseFileThreshold) {
        this.automaticResponseFileThreshold = automaticResponseFileThreshold;
    }

    protected void prepareExecutor() {
        if (this.owner == null) {
            throw new RuntimeException("no owner");
        }
        if (this.owner.getProject() == null) {
            throw new RuntimeException("Owner has no project");
        }
        File dir = this.owner.getProject().getBaseDir();
        if (this.directory != null) {
            dir = this.directory;
        }
        LogStreamHandler handler = new LogStreamHandler(this.owner, 2, 1);
        this.executable = new Execute((ExecuteStreamHandler)handler, null);
        this.executable.setAntRun(this.owner.getProject());
        this.executable.setWorkingDirectory(dir);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void runCommand() throws BuildException {
        int err = -1;
        try {
            try {
                if (this.traceCommandLine) {
                    this.owner.log(this.commandLine.describeCommand());
                } else {
                    this.logVerbose(this.commandLine.describeCommand());
                }
                this.setExecutableCommandLine();
                err = this.executable.execute();
                if (Execute.isFailure((int)err)) {
                    if (this.failOnError) {
                        throw new BuildException(this.title + " returned: " + err, this.owner.getLocation());
                    }
                    this.owner.log(this.title + "  Result: " + err, 0);
                }
            }
            catch (IOException e) {
                throw new BuildException(this.title + " failed: " + e, (Throwable)e, this.owner.getLocation());
            }
            Object var4_2 = null;
            if (this.temporaryCommandFile == null) return;
            this.temporaryCommandFile.delete();
            return;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (this.temporaryCommandFile == null) throw throwable;
            this.temporaryCommandFile.delete();
            throw throwable;
        }
    }

    private void setExecutableCommandLine() {
        String[] commands = this.commandLine.getCommandline();
        if (this.automaticResponseFileThreshold > 0 && commands.length > this.automaticResponseFileThreshold) {
            this.useResponseFile = true;
        }
        if (!this.useResponseFile || commands.length <= 1) {
            this.executable.setCommandline(commands);
        } else {
            FileOutputStream fos = null;
            FileUtils fileUtils = FileUtils.newFileUtils();
            this.temporaryCommandFile = fileUtils.createTempFile("cmd", ".txt", null);
            this.owner.log("Using response file" + this.temporaryCommandFile, 3);
            try {
                fos = new FileOutputStream(this.temporaryCommandFile);
                PrintWriter out = new PrintWriter(new BufferedOutputStream(fos));
                for (int i = 1; i < commands.length; ++i) {
                    out.println(commands[i]);
                }
                out.flush();
                out.close();
            }
            catch (IOException ex) {
                throw new BuildException("saving command stream to " + this.temporaryCommandFile, (Throwable)ex);
            }
            String[] newCommandLine = new String[]{commands[0], "@" + this.temporaryCommandFile.getAbsolutePath()};
            this.executable.setCommandline(newCommandLine);
        }
    }

    public int scanOneFileset(DirectoryScanner scanner, Hashtable filesToBuild, long outputTimestamp) {
        int filesOutOfDate = 0;
        String[] dependencies = scanner.getIncludedFiles();
        File base = scanner.getBasedir();
        for (int i = 0; i < dependencies.length; ++i) {
            File targetFile = new File(base, dependencies[i]);
            if (filesToBuild.get(targetFile) != null) continue;
            filesToBuild.put(targetFile, targetFile);
            if (targetFile.lastModified() > outputTimestamp) {
                ++filesOutOfDate;
                this.owner.log(targetFile.toString() + " is out of date", 3);
                continue;
            }
            this.owner.log(targetFile.toString(), 3);
        }
        return filesOutOfDate;
    }
}

