/*
 * Decompiled with CFR 0.152.
 */
package rath.msnm.ftp;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import rath.msnm.MSNMessenger;
import rath.msnm.ftp.StreamingFile;
import rath.msnm.ftp.ToSendFile;
import rath.msnm.ftp.VolatileTransfer;
import rath.msnm.msg.FileTransferMessage;

public class VolatileTransferServer
extends Thread
implements VolatileTransfer {
    String cookie;
    private final MSNMessenger msn;
    private boolean isLive = true;
    private int port;
    private String authCookie = null;
    private String peerLoginName = null;
    private File file = null;
    private int filesize = 0;
    private volatile int offset = 0;
    private ServerSocket serverSocket = null;
    private OutputStream out = null;
    private Socket socket = null;
    private BufferedReader in = null;
    private Thread binaryThread = null;

    private VolatileTransferServer(MSNMessenger msn) {
        this.msn = msn;
    }

    public static VolatileTransferServer getInstance(MSNMessenger msn, ToSendFile tosend, FileTransferMessage msg) throws FileNotFoundException {
        int port = Integer.parseInt(msg.getProperty("Port"));
        String authCookie = msg.getProperty("AuthCookie");
        String loginName = tosend.getReceiverName();
        File file = tosend.getFile();
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        VolatileTransferServer vts = new VolatileTransferServer(msn);
        vts.port = port;
        vts.authCookie = authCookie;
        vts.peerLoginName = loginName;
        vts.file = file;
        vts.filesize = (int)file.length();
        return vts;
    }

    public int getPort() {
        return this.port;
    }

    public String getReceiverName() {
        return this.peerLoginName;
    }

    public String getAuthCookie() {
        return this.authCookie;
    }

    public String getCookie() {
        return this.cookie;
    }

    public File getFile() {
        return this.file;
    }

    public String getFilename() {
        return this.file.getName();
    }

    public int getPostedLength() {
        return this.offset;
    }

    public int getCommitPercent() {
        return (int)((double)this.offset / (double)this.filesize * 100.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        try {
            try {
                String line;
                this.fireStart();
                this.makeConnection();
                while (this.isLive && (line = this.in.readLine()) != null) {
                    String header = line.substring(0, 3);
                    String body = "";
                    if (line.length() > 4) {
                        body = line.substring(4);
                    }
                    this.processMessage(header, body);
                }
                Object var5_5 = null;
                if (this.binaryThread != null) {
                    this.binaryThread.interrupt();
                }
                this.close();
                this.fireEnd();
            }
            catch (Throwable e) {
                this.fireError(e);
                Object var5_6 = null;
                if (this.binaryThread != null) {
                    this.binaryThread.interrupt();
                }
                this.close();
                this.fireEnd();
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (this.binaryThread != null) {
                this.binaryThread.interrupt();
            }
            this.close();
            this.fireEnd();
            throw throwable;
        }
    }

    public void processMessage(String header, String body) throws Throwable {
        if (header.equals("VER")) {
            this.sendMessage(header, body);
        } else if (header.equals("USR")) {
            int i0 = body.indexOf(32);
            if (i0 == -1) {
                this.close();
                return;
            }
            String loginName = body.substring(0, i0);
            String authCookie = body.substring(i0 + 1);
            if (!loginName.equals(this.peerLoginName) || !authCookie.equals(this.authCookie)) {
                this.close();
                return;
            }
            this.sendMessage("FIL", String.valueOf(this.file.length()));
        } else if (header.equals("TFR")) {
            this.binaryThread = new Thread(new Runnable(){

                public void run() {
                    try {
                        VolatileTransferServer.this.sendFileContent();
                    }
                    catch (Throwable e) {
                        VolatileTransferServer.this.fireError(e);
                    }
                }
            });
            this.binaryThread.start();
        } else if (header.equals("CCL")) {
            if (this.binaryThread != null) {
                this.binaryThread.interrupt();
                this.binaryThread = null;
                this.isLive = false;
            }
        } else if (header.equals("BYE")) {
            this.isLive = false;
        }
    }

    public void sendMessage(String header, String body) throws IOException {
        StringBuffer sb = new StringBuffer(40);
        sb.append(header);
        sb.append(' ');
        sb.append(body);
        sb.append("\r\n");
        this.out.write(sb.toString().getBytes());
        this.out.flush();
    }

    public void sendFileContent() throws IOException, InterruptedException {
        int readlen;
        int filesize = (int)this.file.length();
        byte[] buf = new byte[2048];
        InputStream in = null;
        in = this.file instanceof StreamingFile ? ((StreamingFile)this.file).getInputStream() : new FileInputStream(this.file);
        Thread currentThread = Thread.currentThread();
        while ((readlen = in.read(buf, 3, 2045)) > 0) {
            buf[0] = 0;
            buf[1] = (byte)(readlen >> 0 & 0xFF);
            buf[2] = (byte)(readlen >> 8 & 0xFF);
            this.out.write(buf, 0, readlen + 3);
            this.offset += readlen;
            this.out.flush();
            if (!currentThread.isInterrupted()) continue;
            in.close();
            throw new InterruptedException("thread interrupted");
        }
        in.close();
        this.out.write(0);
        this.out.write(0);
        this.out.write(0);
    }

    public void close() {
        this.isLive = false;
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void fireStart() {
        this.msn.fireFileSendStartedEvent(this);
    }

    protected void fireError(Throwable e) {
        this.msn.fireFileSendErrorEvent(this, e);
    }

    protected void fireEnd() {
        this.msn.fireFileSendEndedEvent(this);
    }

    protected void makeConnection() throws IOException {
        this.serverSocket = new ServerSocket(this.port, 1);
        this.serverSocket.setSoTimeout(30000);
        this.socket = this.serverSocket.accept();
        this.out = this.socket.getOutputStream();
        this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
    }
}

