/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.contrib.table.components;

import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.contrib.table.components.TablePages;
import org.apache.tapestry.contrib.table.model.ITableModelSource;
import org.apache.tapestry.event.PageDetachListener;
import org.apache.tapestry.event.PageEvent;
import org.apache.tapestry.event.PageRenderListener;

public abstract class TableFormPages
extends TablePages
implements PageDetachListener,
PageRenderListener {
    private int m_nCurrentPage;
    private int m_nPageCount;
    private int m_nStartPage;
    private int m_nStopPage;

    public TableFormPages() {
        this.initialize();
    }

    public void pageDetached(PageEvent event) {
        this.initialize();
    }

    public void pageBeginRender(PageEvent event) {
        this.initialize();
    }

    private void initialize() {
        this.m_nCurrentPage = -1;
        this.m_nPageCount = -1;
        this.m_nStartPage = -1;
        this.m_nStopPage = -1;
    }

    public void changePage(IRequestCycle objCycle) {
        ITableModelSource objSource = this.getTableModelSource();
        this.setCurrentPage(objSource, this.getSelectedPage());
        objSource.fireObservedStateChange();
    }

    public abstract int getSelectedPage();

    public int getCurrentPage() {
        if (this.m_nCurrentPage < 0) {
            this.m_nCurrentPage = super.getCurrentPage();
        }
        return this.m_nCurrentPage;
    }

    public int getPageCount() {
        if (this.m_nPageCount < 0) {
            this.m_nPageCount = super.getPageCount();
        }
        return this.m_nPageCount;
    }

    public int getStartPage() {
        if (this.m_nStartPage < 0) {
            this.m_nStartPage = super.getStartPage();
        }
        return this.m_nStartPage;
    }

    public int getStopPage() {
        if (this.m_nStopPage < 0) {
            this.m_nStopPage = super.getStopPage();
        }
        return this.m_nStopPage;
    }

    public void setCurrentPage(int i) {
        this.m_nCurrentPage = i;
    }

    public void setPageCount(int i) {
        this.m_nPageCount = i;
    }

    public void setStartPage(int i) {
        this.m_nStartPage = i;
    }

    public void setStopPage(int i) {
        this.m_nStopPage = i;
    }
}

