/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.contrib.inspector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IEngine;
import org.apache.tapestry.IPage;
import org.apache.tapestry.contrib.inspector.Inspector;
import org.apache.tapestry.engine.IPageRecorder;
import org.apache.tapestry.event.PageEvent;
import org.apache.tapestry.event.PageRenderListener;
import org.apache.tapestry.record.IPageChange;

public class ShowProperties
extends BaseComponent
implements PageRenderListener {
    private List _properties;
    private IPageChange _change;
    private IPage _inspectedPage;

    public void pageBeginRender(PageEvent event) {
    }

    public void pageEndRender(PageEvent event) {
        this._properties = null;
        this._change = null;
        this._inspectedPage = null;
    }

    private void buildProperties() {
        Inspector inspector = (Inspector)this.getPage();
        this._inspectedPage = inspector.getInspectedPage();
        IEngine engine = this.getPage().getEngine();
        IPageRecorder recorder = engine.getPageRecorder(this._inspectedPage.getPageName(), inspector.getRequestCycle());
        if (recorder == null) {
            this._properties = Collections.EMPTY_LIST;
            return;
        }
        if (recorder.getHasChanges()) {
            this._properties = new ArrayList(recorder.getChanges());
        }
    }

    public List getProperties() {
        if (this._properties == null) {
            this.buildProperties();
        }
        return this._properties;
    }

    public void setChange(IPageChange value) {
        this._change = value;
    }

    public IPageChange getChange() {
        return this._change;
    }

    public String getValueClassName() {
        Object value = this._change.getNewValue();
        if (value == null) {
            return "<null>";
        }
        return this.convertClassToName(value.getClass());
    }

    private String convertClassToName(Class cl) {
        if (cl.isArray()) {
            return "array of " + cl.getComponentType().getName();
        }
        return cl.getName();
    }
}

