/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.FileScanner;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceFactory;
import org.apache.tools.ant.types.selectors.FileSelector;
import org.apache.tools.ant.types.selectors.SelectorScanner;
import org.apache.tools.ant.types.selectors.SelectorUtils;
import org.apache.tools.ant.util.FileUtils;

public class DirectoryScanner
implements FileScanner,
SelectorScanner,
ResourceFactory {
    private static final boolean ON_VMS = Os.isFamily("openvms");
    protected static final String[] DEFAULTEXCLUDES = new String[]{"**/*~", "**/#*#", "**/.#*", "**/%*%", "**/._*", "**/CVS", "**/CVS/**", "**/.cvsignore", "**/SCCS", "**/SCCS/**", "**/vssver.scc", "**/.svn", "**/.svn/**", "**/.DS_Store"};
    private static Vector defaultExcludes = new Vector();
    protected File basedir;
    protected String[] includes;
    protected String[] excludes;
    protected FileSelector[] selectors = null;
    protected Vector filesIncluded;
    protected Vector filesNotIncluded;
    protected Vector filesExcluded;
    protected Vector dirsIncluded;
    protected Vector dirsNotIncluded;
    protected Vector dirsExcluded;
    protected Vector filesDeselected;
    protected Vector dirsDeselected;
    protected boolean haveSlowResults = false;
    protected boolean isCaseSensitive = true;
    private boolean followSymlinks = true;
    private static final FileUtils fileUtils;
    protected boolean everythingIncluded = true;
    private Map fileListMap = new HashMap();
    private Set scannedDirs = new HashSet();

    protected static boolean matchPatternStart(String pattern, String str) {
        return SelectorUtils.matchPatternStart(pattern, str);
    }

    protected static boolean matchPatternStart(String pattern, String str, boolean isCaseSensitive) {
        return SelectorUtils.matchPatternStart(pattern, str, isCaseSensitive);
    }

    protected static boolean matchPath(String pattern, String str) {
        return SelectorUtils.matchPath(pattern, str);
    }

    protected static boolean matchPath(String pattern, String str, boolean isCaseSensitive) {
        return SelectorUtils.matchPath(pattern, str, isCaseSensitive);
    }

    public static boolean match(String pattern, String str) {
        return SelectorUtils.match(pattern, str);
    }

    protected static boolean match(String pattern, String str, boolean isCaseSensitive) {
        return SelectorUtils.match(pattern, str, isCaseSensitive);
    }

    public static String[] getDefaultExcludes() {
        return defaultExcludes.toArray(new String[defaultExcludes.size()]);
    }

    public static boolean addDefaultExclude(String s) {
        if (defaultExcludes.indexOf(s) == -1) {
            defaultExcludes.add(s);
            return true;
        }
        return false;
    }

    public static boolean removeDefaultExclude(String s) {
        return defaultExcludes.remove(s);
    }

    public static void resetDefaultExcludes() {
        defaultExcludes = new Vector();
        for (int i = 0; i < DEFAULTEXCLUDES.length; ++i) {
            defaultExcludes.add(DEFAULTEXCLUDES[i]);
        }
    }

    public void setBasedir(String basedir) {
        this.setBasedir(new File(basedir.replace('/', File.separatorChar).replace('\\', File.separatorChar)));
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public void setCaseSensitive(boolean isCaseSensitive) {
        this.isCaseSensitive = isCaseSensitive;
    }

    public boolean isFollowSymlinks() {
        return this.followSymlinks;
    }

    public void setFollowSymlinks(boolean followSymlinks) {
        this.followSymlinks = followSymlinks;
    }

    public void setIncludes(String[] includes) {
        if (includes == null) {
            this.includes = null;
        } else {
            this.includes = new String[includes.length];
            for (int i = 0; i < includes.length; ++i) {
                String pattern = includes[i].replace('/', File.separatorChar).replace('\\', File.separatorChar);
                if (pattern.endsWith(File.separator)) {
                    pattern = pattern + "**";
                }
                this.includes[i] = pattern;
            }
        }
    }

    public void setExcludes(String[] excludes) {
        if (excludes == null) {
            this.excludes = null;
        } else {
            this.excludes = new String[excludes.length];
            for (int i = 0; i < excludes.length; ++i) {
                String pattern = excludes[i].replace('/', File.separatorChar).replace('\\', File.separatorChar);
                if (pattern.endsWith(File.separator)) {
                    pattern = pattern + "**";
                }
                this.excludes[i] = pattern;
            }
        }
    }

    public void setSelectors(FileSelector[] selectors) {
        this.selectors = selectors;
    }

    public boolean isEverythingIncluded() {
        return this.everythingIncluded;
    }

    public void scan() throws IllegalStateException {
        if (this.basedir == null) {
            throw new IllegalStateException("No basedir set");
        }
        if (!this.basedir.exists()) {
            throw new IllegalStateException("basedir " + this.basedir + " does not exist");
        }
        if (!this.basedir.isDirectory()) {
            throw new IllegalStateException("basedir " + this.basedir + " is not a directory");
        }
        if (this.includes == null) {
            this.includes = new String[1];
            this.includes[0] = "**";
        }
        if (this.excludes == null) {
            this.excludes = new String[0];
        }
        this.filesIncluded = new Vector();
        this.filesNotIncluded = new Vector();
        this.filesExcluded = new Vector();
        this.filesDeselected = new Vector();
        this.dirsIncluded = new Vector();
        this.dirsNotIncluded = new Vector();
        this.dirsExcluded = new Vector();
        this.dirsDeselected = new Vector();
        if (this.isIncluded("")) {
            if (!this.isExcluded("")) {
                if (this.isSelected("", this.basedir)) {
                    this.dirsIncluded.addElement("");
                } else {
                    this.dirsDeselected.addElement("");
                }
            } else {
                this.dirsExcluded.addElement("");
            }
        } else {
            this.dirsNotIncluded.addElement("");
        }
        this.checkIncludePatterns();
        this.clearCaches();
    }

    private void checkIncludePatterns() {
        Hashtable<String, String> newroots = new Hashtable<String, String>();
        for (int icounter = 0; icounter < this.includes.length; ++icounter) {
            String newpattern = SelectorUtils.rtrimWildcardTokens(this.includes[icounter]);
            newroots.put(newpattern, this.includes[icounter]);
        }
        if (newroots.containsKey("")) {
            this.scandir(this.basedir, "", true);
        } else {
            Enumeration enum2 = newroots.keys();
            File canonBase = null;
            try {
                canonBase = this.basedir.getCanonicalFile();
            }
            catch (IOException ex) {
                throw new BuildException(ex);
            }
            while (enum2.hasMoreElements()) {
                File f;
                String currentelement = (String)enum2.nextElement();
                String originalpattern = (String)newroots.get(currentelement);
                File myfile = new File(this.basedir, currentelement);
                if (myfile.exists()) {
                    try {
                        File canonFile = myfile.getCanonicalFile();
                        String path = fileUtils.removeLeadingPath(canonBase, canonFile);
                        if ((!path.equals(currentelement) || ON_VMS) && (myfile = this.findFile(this.basedir, currentelement)) != null) {
                            currentelement = fileUtils.removeLeadingPath(this.basedir, myfile);
                        }
                    }
                    catch (IOException ex) {
                        throw new BuildException(ex);
                    }
                }
                if (!(myfile != null && myfile.exists() || this.isCaseSensitive || !(f = this.findFileCaseInsensitive(this.basedir, currentelement)).exists())) {
                    currentelement = fileUtils.removeLeadingPath(this.basedir, f);
                    myfile = f;
                }
                if (myfile == null || !myfile.exists() || !this.followSymlinks && this.isSymlink(this.basedir, currentelement)) continue;
                if (myfile.isDirectory()) {
                    if (this.isIncluded(currentelement) && currentelement.length() > 0) {
                        this.accountForIncludedDir(currentelement, myfile, true);
                        continue;
                    }
                    if (currentelement.length() > 0 && currentelement.charAt(currentelement.length() - 1) != File.separatorChar) {
                        currentelement = currentelement + File.separatorChar;
                    }
                    this.scandir(myfile, currentelement, true);
                    continue;
                }
                if (this.isCaseSensitive && originalpattern.equals(currentelement)) {
                    this.accountForIncludedFile(currentelement, myfile);
                    continue;
                }
                if (this.isCaseSensitive || !originalpattern.equalsIgnoreCase(currentelement)) continue;
                this.accountForIncludedFile(currentelement, myfile);
            }
        }
    }

    protected void slowScan() {
        int i;
        if (this.haveSlowResults) {
            return;
        }
        Object[] excl = new String[this.dirsExcluded.size()];
        this.dirsExcluded.copyInto(excl);
        Object[] notIncl = new String[this.dirsNotIncluded.size()];
        this.dirsNotIncluded.copyInto(notIncl);
        for (i = 0; i < excl.length; ++i) {
            if (this.couldHoldIncluded((String)excl[i])) continue;
            this.scandir(new File(this.basedir, (String)excl[i]), (String)excl[i] + File.separator, false);
        }
        for (i = 0; i < notIncl.length; ++i) {
            if (this.couldHoldIncluded((String)notIncl[i])) continue;
            this.scandir(new File(this.basedir, (String)notIncl[i]), (String)notIncl[i] + File.separator, false);
        }
        this.haveSlowResults = true;
    }

    protected void scandir(File dir, String vpath, boolean fast) {
        if (dir == null) {
            throw new BuildException("dir must not be null.");
        }
        if (!dir.exists()) {
            throw new BuildException(dir + " doesn't exists.");
        }
        if (!dir.isDirectory()) {
            throw new BuildException(dir + " is not a directory.");
        }
        if (fast && this.hasBeenScanned(vpath)) {
            return;
        }
        Object[] newfiles = dir.list();
        if (newfiles == null) {
            throw new BuildException("IO error scanning directory " + dir.getAbsolutePath());
        }
        if (!this.followSymlinks) {
            Vector<Object> noLinks = new Vector<Object>();
            for (int i = 0; i < newfiles.length; ++i) {
                try {
                    if (fileUtils.isSymbolicLink(dir, newfiles[i])) {
                        String name = vpath + (String)newfiles[i];
                        File file = new File(dir, (String)newfiles[i]);
                        if (file.isDirectory()) {
                            this.dirsExcluded.addElement(name);
                            continue;
                        }
                        this.filesExcluded.addElement(name);
                        continue;
                    }
                    noLinks.addElement(newfiles[i]);
                    continue;
                }
                catch (IOException ioe) {
                    String msg = "IOException caught while checking for links, couldn't get canonical path!";
                    System.err.println(msg);
                    noLinks.addElement(newfiles[i]);
                }
            }
            newfiles = new String[noLinks.size()];
            noLinks.copyInto(newfiles);
        }
        for (int i = 0; i < newfiles.length; ++i) {
            String name = vpath + newfiles[i];
            File file = new File(dir, (String)newfiles[i]);
            if (file.isDirectory()) {
                if (this.isIncluded(name)) {
                    this.accountForIncludedDir(name, file, fast);
                } else {
                    this.everythingIncluded = false;
                    this.dirsNotIncluded.addElement(name);
                    if (fast && this.couldHoldIncluded(name)) {
                        this.scandir(file, name + File.separator, fast);
                    }
                }
                if (fast) continue;
                this.scandir(file, name + File.separator, fast);
                continue;
            }
            if (!file.isFile()) continue;
            if (this.isIncluded(name)) {
                this.accountForIncludedFile(name, file);
                continue;
            }
            this.everythingIncluded = false;
            this.filesNotIncluded.addElement(name);
        }
    }

    private void accountForIncludedFile(String name, File file) {
        if (!(this.filesIncluded.contains(name) || this.filesExcluded.contains(name) || this.filesDeselected.contains(name))) {
            if (!this.isExcluded(name)) {
                if (this.isSelected(name, file)) {
                    this.filesIncluded.addElement(name);
                } else {
                    this.everythingIncluded = false;
                    this.filesDeselected.addElement(name);
                }
            } else {
                this.everythingIncluded = false;
                this.filesExcluded.addElement(name);
            }
        }
    }

    private void accountForIncludedDir(String name, File file, boolean fast) {
        if (!(this.dirsIncluded.contains(name) || this.dirsExcluded.contains(name) || this.dirsDeselected.contains(name))) {
            if (!this.isExcluded(name)) {
                if (this.isSelected(name, file)) {
                    this.dirsIncluded.addElement(name);
                    if (fast) {
                        this.scandir(file, name + File.separator, fast);
                    }
                } else {
                    this.everythingIncluded = false;
                    this.dirsDeselected.addElement(name);
                    if (fast && this.couldHoldIncluded(name)) {
                        this.scandir(file, name + File.separator, fast);
                    }
                }
            } else {
                this.everythingIncluded = false;
                this.dirsExcluded.addElement(name);
                if (fast && this.couldHoldIncluded(name)) {
                    this.scandir(file, name + File.separator, fast);
                }
            }
        }
    }

    protected boolean isIncluded(String name) {
        for (int i = 0; i < this.includes.length; ++i) {
            if (!DirectoryScanner.matchPath(this.includes[i], name, this.isCaseSensitive)) continue;
            return true;
        }
        return false;
    }

    protected boolean couldHoldIncluded(String name) {
        for (int i = 0; i < this.includes.length; ++i) {
            if (!DirectoryScanner.matchPatternStart(this.includes[i], name, this.isCaseSensitive) || !this.isMorePowerfulThanExcludes(name, this.includes[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isMorePowerfulThanExcludes(String name, String includepattern) {
        String soughtexclude = name + File.separator + "**";
        for (int counter = 0; counter < this.excludes.length; ++counter) {
            if (!this.excludes[counter].equals(soughtexclude)) continue;
            return false;
        }
        return true;
    }

    protected boolean isExcluded(String name) {
        for (int i = 0; i < this.excludes.length; ++i) {
            if (!DirectoryScanner.matchPath(this.excludes[i], name, this.isCaseSensitive)) continue;
            return true;
        }
        return false;
    }

    protected boolean isSelected(String name, File file) {
        if (this.selectors != null) {
            for (int i = 0; i < this.selectors.length; ++i) {
                if (this.selectors[i].isSelected(this.basedir, name, file)) continue;
                return false;
            }
        }
        return true;
    }

    public String[] getIncludedFiles() {
        Object[] files = new String[this.filesIncluded.size()];
        this.filesIncluded.copyInto(files);
        Arrays.sort(files);
        return files;
    }

    public String[] getNotIncludedFiles() {
        this.slowScan();
        Object[] files = new String[this.filesNotIncluded.size()];
        this.filesNotIncluded.copyInto(files);
        return files;
    }

    public String[] getExcludedFiles() {
        this.slowScan();
        Object[] files = new String[this.filesExcluded.size()];
        this.filesExcluded.copyInto(files);
        return files;
    }

    public String[] getDeselectedFiles() {
        this.slowScan();
        Object[] files = new String[this.filesDeselected.size()];
        this.filesDeselected.copyInto(files);
        return files;
    }

    public String[] getIncludedDirectories() {
        Object[] directories = new String[this.dirsIncluded.size()];
        this.dirsIncluded.copyInto(directories);
        Arrays.sort(directories);
        return directories;
    }

    public String[] getNotIncludedDirectories() {
        this.slowScan();
        Object[] directories = new String[this.dirsNotIncluded.size()];
        this.dirsNotIncluded.copyInto(directories);
        return directories;
    }

    public String[] getExcludedDirectories() {
        this.slowScan();
        Object[] directories = new String[this.dirsExcluded.size()];
        this.dirsExcluded.copyInto(directories);
        return directories;
    }

    public String[] getDeselectedDirectories() {
        this.slowScan();
        Object[] directories = new String[this.dirsDeselected.size()];
        this.dirsDeselected.copyInto(directories);
        return directories;
    }

    public void addDefaultExcludes() {
        int excludesLength = this.excludes == null ? 0 : this.excludes.length;
        String[] newExcludes = new String[excludesLength + defaultExcludes.size()];
        if (excludesLength > 0) {
            System.arraycopy(this.excludes, 0, newExcludes, 0, excludesLength);
        }
        String[] defaultExcludesTemp = DirectoryScanner.getDefaultExcludes();
        for (int i = 0; i < defaultExcludesTemp.length; ++i) {
            newExcludes[i + excludesLength] = defaultExcludesTemp[i].replace('/', File.separatorChar).replace('\\', File.separatorChar);
        }
        this.excludes = newExcludes;
    }

    public Resource getResource(String name) {
        File f = fileUtils.resolveFile(this.basedir, name);
        return new Resource(name, f.exists(), f.lastModified(), f.isDirectory());
    }

    private String[] list(File file) {
        String[] files = (String[])this.fileListMap.get(file);
        if (files == null && (files = file.list()) != null) {
            this.fileListMap.put(file, files);
        }
        return files;
    }

    private File findFileCaseInsensitive(File base, String path) {
        File f = this.findFileCaseInsensitive(base, SelectorUtils.tokenizePath(path));
        return f == null ? new File(base, path) : f;
    }

    private File findFileCaseInsensitive(File base, Vector pathElements) {
        int i;
        if (pathElements.size() == 0) {
            return base;
        }
        if (!base.isDirectory()) {
            return null;
        }
        String[] files = this.list(base);
        if (files == null) {
            throw new BuildException("IO error scanning directory " + base.getAbsolutePath());
        }
        String current = (String)pathElements.remove(0);
        for (i = 0; i < files.length; ++i) {
            if (!files[i].equals(current)) continue;
            base = new File(base, files[i]);
            return this.findFileCaseInsensitive(base, pathElements);
        }
        for (i = 0; i < files.length; ++i) {
            if (!files[i].equalsIgnoreCase(current)) continue;
            base = new File(base, files[i]);
            return this.findFileCaseInsensitive(base, pathElements);
        }
        return null;
    }

    private File findFile(File base, String path) {
        return this.findFile(base, SelectorUtils.tokenizePath(path));
    }

    private File findFile(File base, Vector pathElements) {
        if (pathElements.size() == 0) {
            return base;
        }
        if (!base.isDirectory()) {
            return null;
        }
        String[] files = this.list(base);
        if (files == null) {
            throw new BuildException("IO error scanning directory " + base.getAbsolutePath());
        }
        String current = (String)pathElements.remove(0);
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].equals(current)) continue;
            base = new File(base, files[i]);
            return this.findFile(base, pathElements);
        }
        return null;
    }

    private boolean isSymlink(File base, String path) {
        return this.isSymlink(base, SelectorUtils.tokenizePath(path));
    }

    private boolean isSymlink(File base, Vector pathElements) {
        if (pathElements.size() > 0) {
            String current = (String)pathElements.remove(0);
            try {
                if (fileUtils.isSymbolicLink(base, current)) {
                    return true;
                }
                base = new File(base, current);
                return this.isSymlink(base, pathElements);
            }
            catch (IOException ioe) {
                String msg = "IOException caught while checking for links, couldn't get canonical path!";
                System.err.println(msg);
                return false;
            }
        }
        return false;
    }

    private boolean hasBeenScanned(String vpath) {
        return !this.scannedDirs.add(vpath);
    }

    private void clearCaches() {
        this.fileListMap.clear();
        this.scannedDirs.clear();
    }

    static {
        DirectoryScanner.resetDefaultExcludes();
        fileUtils = FileUtils.newFileUtils();
    }
}

