/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.email;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.security.Provider;
import java.security.Security;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.email.EmailAddress;
import org.apache.tools.ant.taskdefs.email.Mailer;

public class MimeMailer
extends Mailer {
    private static final String DEFAULT_CHARSET = System.getProperty("file.encoding");

    public void send() {
        try {
            Session sesh;
            Properties props = new Properties();
            ((Hashtable)props).put("mail.smtp.host", this.host);
            ((Hashtable)props).put("mail.smtp.port", String.valueOf(this.port));
            if (this.SSL) {
                try {
                    Provider p = (Provider)Class.forName("com.sun.net.ssl.internal.ssl.Provider").newInstance();
                    Security.addProvider(p);
                }
                catch (Exception e) {
                    throw new BuildException("could not instantiate ssl security provider, check that you have JSSE in your classpath");
                }
                String SSL_FACTORY = "javax.net.ssl.SSLSocketFactory";
                ((Hashtable)props).put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
                ((Hashtable)props).put("mail.smtp.socketFactory.fallback", "false");
            }
            if (this.user == null && this.password == null) {
                sesh = Session.getInstance((Properties)props, null);
            } else {
                ((Hashtable)props).put("mail.smtp.auth", "true");
                SimpleAuthenticator auth = new SimpleAuthenticator(this.user, this.password);
                sesh = Session.getInstance((Properties)props, (Authenticator)auth);
            }
            MimeMessage msg = new MimeMessage(sesh);
            MimeMultipart attachments = new MimeMultipart();
            if (this.from.getName() == null) {
                msg.setFrom((Address)new InternetAddress(this.from.getAddress()));
            } else {
                msg.setFrom((Address)new InternetAddress(this.from.getAddress(), this.from.getName()));
            }
            msg.setReplyTo((Address[])MimeMailer.internetAddresses(this.replyToList));
            msg.setRecipients(Message.RecipientType.TO, (Address[])MimeMailer.internetAddresses(this.toList));
            msg.setRecipients(Message.RecipientType.CC, (Address[])MimeMailer.internetAddresses(this.ccList));
            msg.setRecipients(Message.RecipientType.BCC, (Address[])MimeMailer.internetAddresses(this.bccList));
            String charset = this.parseCharSetFromMimeType(this.message.getMimeType());
            if (charset != null) {
                this.message.setCharset(charset);
            } else {
                charset = this.message.getCharset();
                if (charset == null) {
                    charset = DEFAULT_CHARSET;
                    this.message.setCharset(charset);
                }
            }
            StringDataSource sds = new StringDataSource();
            sds.setContentType(this.message.getMimeType());
            sds.setCharset(charset);
            if (this.subject != null) {
                msg.setSubject(this.subject, charset);
            }
            msg.addHeader("Date", this.getDate());
            PrintStream out = new PrintStream(sds.getOutputStream());
            this.message.print(out);
            out.close();
            MimeBodyPart textbody = new MimeBodyPart();
            textbody.setDataHandler(new DataHandler((DataSource)sds));
            attachments.addBodyPart((BodyPart)textbody);
            Enumeration e = this.files.elements();
            while (e.hasMoreElements()) {
                File file = (File)e.nextElement();
                MimeBodyPart body = new MimeBodyPart();
                if (!file.exists() || !file.canRead()) {
                    throw new BuildException("File \"" + file.getAbsolutePath() + "\" does not exist or is not " + "readable.");
                }
                FileDataSource fileData = new FileDataSource(file);
                DataHandler fileDataHandler = new DataHandler((DataSource)fileData);
                body.setDataHandler(fileDataHandler);
                body.setFileName(file.getName());
                attachments.addBodyPart((BodyPart)body);
            }
            msg.setContent((Multipart)attachments);
            Transport.send((Message)msg);
        }
        catch (MessagingException e) {
            throw new BuildException("Problem while sending mime mail:", (Throwable)e);
        }
        catch (IOException e) {
            throw new BuildException("Problem while sending mime mail:", (Throwable)e);
        }
    }

    private static InternetAddress[] internetAddresses(Vector list) throws AddressException, UnsupportedEncodingException {
        InternetAddress[] addrs = new InternetAddress[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            EmailAddress addr = (EmailAddress)list.elementAt(i);
            addrs[i] = addr.getName() == null ? new InternetAddress(addr.getAddress()) : new InternetAddress(addr.getAddress(), addr.getName());
        }
        return addrs;
    }

    private String parseCharSetFromMimeType(String type) {
        int pos;
        if (type == null || (pos = type.indexOf("charset")) < 0) {
            return null;
        }
        StringTokenizer token = new StringTokenizer(type.substring(pos), "=; ");
        token.nextToken();
        return token.nextToken();
    }

    static class SimpleAuthenticator
    extends Authenticator {
        private String user = null;
        private String password = null;

        public SimpleAuthenticator(String user, String password) {
            this.user = user;
            this.password = password;
        }

        public PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.user, this.password);
        }
    }

    class StringDataSource
    implements DataSource {
        private String data = null;
        private String type = null;
        private String charset = null;
        private ByteArrayOutputStream out;

        StringDataSource() {
        }

        public InputStream getInputStream() throws IOException {
            if (this.data == null && this.out == null) {
                throw new IOException("No data");
            }
            if (this.out != null) {
                this.data = this.data != null ? this.data.concat(this.out.toString(this.charset)) : this.out.toString(this.charset);
                this.out = null;
            }
            return new ByteArrayInputStream(this.data.getBytes(this.charset));
        }

        public OutputStream getOutputStream() throws IOException {
            if (this.out == null) {
                this.out = new ByteArrayOutputStream();
            }
            return this.out;
        }

        public void setContentType(String type) {
            this.type = type.toLowerCase();
        }

        public String getContentType() {
            if (this.type != null && this.type.indexOf("charset") > 0 && this.type.startsWith("text/")) {
                return this.type;
            }
            return this.type != null ? this.type.concat("; charset=".concat(this.charset)) : "text/plain".concat("; charset=".concat(this.charset));
        }

        public String getName() {
            return "StringDataSource";
        }

        public void setCharset(String charset) {
            this.charset = charset;
        }

        public String getCharset() {
            return this.charset;
        }
    }
}

