/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.ConstPool;
import javassist.bytecode.ConstantAttribute;
import javassist.bytecode.ExceptionsAttribute;
import javassist.bytecode.InnerClassesAttribute;
import javassist.bytecode.LineNumberAttribute;
import javassist.bytecode.SourceFileAttribute;
import javassist.bytecode.SyntheticAttribute;

public class AttributeInfo {
    protected ConstPool constPool;
    int name;
    byte[] info;

    protected AttributeInfo(ConstPool cp, int attrname, byte[] attrinfo) {
        this.constPool = cp;
        this.name = attrname;
        this.info = attrinfo;
    }

    protected AttributeInfo(ConstPool cp, String attrname) {
        this(cp, attrname, (byte[])null);
    }

    public AttributeInfo(ConstPool cp, String attrname, byte[] attrinfo) {
        this(cp, cp.addUtf8Info(attrname), attrinfo);
    }

    protected AttributeInfo(ConstPool cp, int n, DataInputStream in) throws IOException {
        this.constPool = cp;
        this.name = n;
        int len = in.readInt();
        this.info = new byte[len];
        if (len > 0) {
            in.readFully(this.info);
        }
    }

    static AttributeInfo read(ConstPool cp, DataInputStream in) throws IOException {
        int name = in.readUnsignedShort();
        String nameStr = cp.getUtf8Info(name);
        if (nameStr.equals("Code")) {
            return new CodeAttribute(cp, name, in);
        }
        if (nameStr.equals("Exceptions")) {
            return new ExceptionsAttribute(cp, name, in);
        }
        if (nameStr.equals("ConstantValue")) {
            return new ConstantAttribute(cp, name, in);
        }
        if (nameStr.equals("SourceFile")) {
            return new SourceFileAttribute(cp, name, in);
        }
        if (nameStr.equals("LineNumberTable")) {
            return new LineNumberAttribute(cp, name, in);
        }
        if (nameStr.equals("Synthetic")) {
            return new SyntheticAttribute(cp, name, in);
        }
        if (nameStr.equals("InnerClasses")) {
            return new InnerClassesAttribute(cp, name, in);
        }
        return new AttributeInfo(cp, name, in);
    }

    public String getName() {
        return this.constPool.getUtf8Info(this.name);
    }

    public ConstPool getConstPool() {
        return this.constPool;
    }

    public int length() {
        return this.info.length + 6;
    }

    public byte[] get() {
        return this.info;
    }

    public void set(byte[] newinfo) {
        this.info = newinfo;
    }

    public AttributeInfo copy(ConstPool newCp, Map classnames) {
        int s = this.info.length;
        byte[] newInfo = new byte[s];
        int i = 0;
        while (i < s) {
            newInfo[i] = this.info[i];
            ++i;
        }
        return new AttributeInfo(newCp, this.getName(), newInfo);
    }

    void write(DataOutputStream out) throws IOException {
        out.writeShort(this.name);
        out.writeInt(this.info.length);
        if (this.info.length > 0) {
            out.write(this.info);
        }
    }

    static int getLength(LinkedList list) {
        int size = 0;
        int n = list.size();
        int i = 0;
        while (i < n) {
            AttributeInfo attr = (AttributeInfo)list.get(i);
            size += attr.length();
            ++i;
        }
        return size;
    }

    static AttributeInfo lookup(LinkedList list, String name) {
        if (list == null) {
            return null;
        }
        ListIterator iterator = list.listIterator();
        while (iterator.hasNext()) {
            AttributeInfo ai = (AttributeInfo)iterator.next();
            if (!ai.getName().equals(name)) continue;
            return ai;
        }
        return null;
    }

    static AttributeInfo lookup(LinkedList list, Class type) {
        if (list == null) {
            return null;
        }
        ListIterator iterator = list.listIterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (!type.isInstance(obj)) continue;
            return (AttributeInfo)obj;
        }
        return null;
    }

    static synchronized void remove(LinkedList list, String name) {
        if (list == null) {
            return;
        }
        ListIterator iterator = list.listIterator();
        while (iterator.hasNext()) {
            AttributeInfo ai = (AttributeInfo)iterator.next();
            if (!ai.getName().equals(name)) continue;
            iterator.remove();
        }
    }

    static synchronized void remove(LinkedList list, Class type) {
        if (list == null) {
            return;
        }
        ListIterator iterator = list.listIterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (!type.isInstance(obj)) continue;
            iterator.remove();
        }
    }

    static void writeAll(LinkedList list, DataOutputStream out) throws IOException {
        if (list == null) {
            return;
        }
        int n = list.size();
        int i = 0;
        while (i < n) {
            AttributeInfo attr = (AttributeInfo)list.get(i);
            attr.write(out);
            ++i;
        }
    }
}

