/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.visdiff;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Hashtable;
import java.util.ResourceBundle;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

class OptionsSetter
extends JDialog {
    public static final int IDCANCEL = 0;
    public static final int IDOK = 1;
    public static final String TAB_SIZE = "TabSize";
    public static final String SHOW_LINE_NUMS = "ShowLinesNums";
    public static final String DIFFS_ONLY = "ShowDiffs";
    public static final String SHOW_TOOLBAR = "ShowToolbar";
    public static final String SHOW_STATUSBAR = "ShowStatusbar";
    public static final String IGNORE_CASE = "IgnoreCase";
    public static final String IGNORE_EOL = "IgnoreEOL";
    public static final String FONT = "Font";
    public static final String WHITESPACE_TYPE = "WhitespaceType";
    public static final String TEXT_COLORS = "TextColors";
    private static final int DEFAULT_TAB_SIZE = 8;
    private ResourceBundle m_resources = null;
    private JTabbedPane m_tabbedPane = null;
    private int m_status = 0;
    private Hashtable m_dataValues;
    private ButtonModel m_showLinesModel = null;
    private ButtonModel m_showDiffOnlyModel = null;
    private ButtonModel m_showToolbarModel = null;
    private ButtonModel m_showStatusbarModel = null;
    private ButtonModel m_showIgnoreCaseModel = null;
    private ButtonModel m_showIgnoreEOLModel = null;
    private int m_whitespaceValue = 0;
    private ButtonModel[] m_whitespaceModels = null;
    private int m_tabSize = 8;
    private JTextField m_tabEntry = null;
    PlainDocument m_tabDocument;
    private int m_hotColor = 0;
    private Color[][] m_colorVals = new Color[][]{{new Color(0, 0, 0), new Color(255, 255, 255)}, {new Color(0, 0, 255), new Color(255, 255, 255)}, {new Color(0, 128, 0), new Color(255, 255, 255)}, {new Color(255, 0, 0), new Color(255, 255, 255)}};
    private Color[][] m_defaultColorVals = new Color[][]{{new Color(0, 0, 0), new Color(255, 255, 255)}, {new Color(0, 0, 255), new Color(255, 255, 255)}, {new Color(0, 128, 0), new Color(255, 255, 255)}, {new Color(255, 0, 0), new Color(255, 255, 255)}};
    private JTextField m_sampleArea = null;
    private ListSelectionModel m_listSelModel = null;

    public Object getValue(String string) {
        Object var2_2 = null;
        if (this.m_dataValues != null) {
            var2_2 = this.m_dataValues.get(string);
        }
        return var2_2;
    }

    public void putValue(String string, Object object) {
        if (string.equals(SHOW_LINE_NUMS)) {
            this.putBooleanValue(string, this.m_showLinesModel, object);
        } else if (string.equals(DIFFS_ONLY)) {
            this.putBooleanValue(string, this.m_showDiffOnlyModel, object);
        } else if (string.equals(SHOW_TOOLBAR)) {
            this.putBooleanValue(string, this.m_showToolbarModel, object);
        } else if (string.equals(SHOW_STATUSBAR)) {
            this.putBooleanValue(string, this.m_showStatusbarModel, object);
        } else if (string.equals(IGNORE_CASE)) {
            this.putBooleanValue(string, this.m_showIgnoreCaseModel, object);
        } else if (string.equals(IGNORE_EOL)) {
            this.putBooleanValue(string, this.m_showIgnoreEOLModel, object);
        } else if (string.equals(WHITESPACE_TYPE)) {
            int n;
            if (object instanceof Integer && (n = ((Integer)object).intValue()) < this.m_whitespaceModels.length) {
                this.putPrivateValue(string, object);
                this.m_whitespaceModels[n].setSelected(true);
            }
        } else if (string.equals(TAB_SIZE)) {
            int n;
            if (object instanceof Integer && (n = ((Integer)object).intValue()) > 0) {
                this.putPrivateValue(string, object);
                this.setTabSizeOption(n);
            }
        } else if (string.equals(TEXT_COLORS) && object instanceof Color[][]) {
            this.m_colorVals = (Color[][])object;
            this.putPrivateValue(string, object);
        }
    }

    private void putBooleanValue(String string, ButtonModel buttonModel, Object object) {
        boolean bl = false;
        if (object instanceof Boolean) {
            bl = (Boolean)object;
            this.putPrivateValue(string, object);
            if (buttonModel.isSelected() != bl) {
                buttonModel.setSelected(bl);
            }
        }
    }

    private void putPrivateValue(String string, Object object) {
        this.m_dataValues.put(string, object);
    }

    private void setTabSizeOption(int n) {
        this.m_tabSize = n;
        if (this.m_tabEntry != null) {
            this.m_tabEntry.setText(Integer.toString(n));
        }
    }

    public int getStatus() {
        return this.m_status;
    }

    private JComponent makeComparePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setAlignmentX(0.5f);
        OptionsSetter optionsSetter = this;
        if (optionsSetter == null) {
            throw null;
        }
        CheckAdapter checkAdapter = optionsSetter.new CheckAdapter();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setAlignmentY(0.5f);
        JCheckBox jCheckBox = new JCheckBox(this.getCommonResources().getString("OPT_COMP_CASE"), false);
        jCheckBox.setActionCommand(IGNORE_CASE);
        this.m_showIgnoreCaseModel = jCheckBox.getModel();
        jCheckBox.getModel().addItemListener(checkAdapter);
        jPanel2.add(jCheckBox);
        jCheckBox = new JCheckBox(this.getCommonResources().getString("OPT_COMP_EOL"), false);
        jCheckBox.setActionCommand(IGNORE_EOL);
        this.m_showIgnoreEOLModel = jCheckBox.getModel();
        jCheckBox.getModel().addItemListener(checkAdapter);
        jPanel2.add(jCheckBox);
        ButtonGroup buttonGroup = new ButtonGroup();
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.setBorder(new TitledBorder(this.getCommonResources().getString("OPT_COMP_WHITESPACE")));
        String[] stringArray = new String[]{this.getCommonResources().getString("OPT_COMP_WS_NONE"), this.getCommonResources().getString("OPT_COMP_WS_PVCS"), this.getCommonResources().getString("OPT_COMP_WS_VSS"), this.getCommonResources().getString("OPT_COMP_WS_DIFF_B")};
        this.m_whitespaceModels = new ButtonModel[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            JRadioButton jRadioButton = new JRadioButton(stringArray[n], false);
            this.m_whitespaceModels[n] = jRadioButton.getModel();
            if (n == this.m_whitespaceValue) {
                jRadioButton.setSelected(true);
            }
            OptionsSetter optionsSetter2 = this;
            if (optionsSetter2 == null) {
                throw null;
            }
            jRadioButton.addActionListener(optionsSetter2.new WhiteAdapter(this, WHITESPACE_TYPE, n));
            buttonGroup.add(jRadioButton);
            jPanel3.add(jRadioButton);
            ++n;
        }
        jPanel3.setAlignmentY(0.5f);
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        return jPanel;
    }

    private JComponent makeColorsPanel() {
        JPanel jPanel = new JPanel(false);
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setAlignmentY(0.5f);
        jPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        JPanel jPanel2 = new JPanel(false);
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setAlignmentY(0.0f);
        jPanel2.setAlignmentX(0.0f);
        jPanel2.setBorder(new EmptyBorder(5, 5, 5, 5));
        JLabel jLabel = new JLabel(this.getCommonResources().getString("OPT_COLOR_LABEL"));
        jLabel.setAlignmentX(1.0f);
        jPanel2.add(jLabel);
        String string = this.getCommonResources().getString("OPT_COLOR_SAMPLE");
        String[] stringArray = new String[]{this.getCommonResources().getString("OPT_COLOR_TYPE_MATCH"), this.getCommonResources().getString("OPT_COLOR_TYPE_REPLACE"), this.getCommonResources().getString("OPT_COLOR_TYPE_INSERT"), this.getCommonResources().getString("OPT_COLOR_TYPE_DELETE")};
        JList<String> jList = new JList<String>(stringArray);
        this.m_listSelModel = jList.getSelectionModel();
        this.m_listSelModel.setSelectionMode(0);
        OptionsSetter optionsSetter = this;
        if (optionsSetter == null) {
            throw null;
        }
        this.m_listSelModel.addListSelectionListener(new ListSelectionListener(optionsSetter){
            private final /* synthetic */ OptionsSetter this$0;

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (!listSelectionModel.isSelectionEmpty()) {
                    OptionsSetter.access$1(this.this$0, listSelectionModel.getMinSelectionIndex());
                    OptionsSetter.access$3(this.this$0).setForeground(OptionsSetter.access$2(this.this$0)[OptionsSetter.access$0(this.this$0)][0]);
                    OptionsSetter.access$3(this.this$0).setBackground(OptionsSetter.access$2(this.this$0)[OptionsSetter.access$0(this.this$0)][1]);
                    OptionsSetter.access$3(this.this$0).setVisible(false);
                    OptionsSetter.access$3(this.this$0).invalidate();
                    OptionsSetter.access$3(this.this$0).setVisible(true);
                }
            }
            {
                this.this$0 = optionsSetter;
                this.constructor$0(optionsSetter);
            }

            private final void constructor$0(OptionsSetter optionsSetter) {
            }
        });
        jList.setAlignmentX(0.5f);
        jPanel2.add(jList);
        this.m_sampleArea = new JTextField(string);
        this.m_sampleArea.setHorizontalAlignment(0);
        this.m_sampleArea.setAlignmentX(0.5f);
        this.m_sampleArea.setEditable(false);
        this.m_sampleArea.setForeground(this.m_colorVals[this.m_hotColor][0]);
        this.m_sampleArea.setBackground(this.m_colorVals[this.m_hotColor][1]);
        jPanel2.add(this.m_sampleArea);
        JPanel jPanel3 = new JPanel(false);
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.setAlignmentY(0.0f);
        jPanel3.setBorder(new EmptyBorder(5, 5, 5, 5));
        JButton jButton = new JButton(this.getCommonResources().getString("OPT_COLOR_SELECT"));
        OptionsSetter optionsSetter2 = this;
        if (optionsSetter2 == null) {
            throw null;
        }
        jButton.addActionListener(new ActionListener(optionsSetter2){
            private final /* synthetic */ OptionsSetter this$0;

            public void actionPerformed(ActionEvent actionEvent) {
                Color color = OptionsSetter.access$2(this.this$0)[OptionsSetter.access$0(this.this$0)][0];
                color = JColorChooser.showDialog(null, OptionsSetter.access$4(this.this$0).getString("OPT_COLOR_PICKER_TITLE"), color);
                if (color != null) {
                    OptionsSetter.access$2((OptionsSetter)this.this$0)[OptionsSetter.access$0((OptionsSetter)this.this$0)][0] = color;
                    OptionsSetter.access$3(this.this$0).setForeground(OptionsSetter.access$2(this.this$0)[OptionsSetter.access$0(this.this$0)][0]);
                    OptionsSetter.access$3(this.this$0).setBackground(OptionsSetter.access$2(this.this$0)[OptionsSetter.access$0(this.this$0)][1]);
                    OptionsSetter.access$3(this.this$0).setVisible(false);
                    OptionsSetter.access$3(this.this$0).invalidate();
                    OptionsSetter.access$3(this.this$0).setVisible(true);
                }
            }
            {
                this.this$0 = optionsSetter;
                this.constructor$0(optionsSetter);
            }

            private final void constructor$0(OptionsSetter optionsSetter) {
            }
        });
        jPanel3.add(jButton);
        jButton = new JButton(this.getCommonResources().getString("OPT_COLOR_DEFAULTS"));
        OptionsSetter optionsSetter3 = this;
        if (optionsSetter3 == null) {
            throw null;
        }
        jButton.addActionListener(new ActionListener(optionsSetter3){
            private final /* synthetic */ OptionsSetter this$0;

            public void actionPerformed(ActionEvent actionEvent) {
                int n = 0;
                while (n < OptionsSetter.access$5(this.this$0).length) {
                    int n2 = 0;
                    while (n2 < OptionsSetter.access$5(this.this$0)[n].length) {
                        OptionsSetter.access$2((OptionsSetter)this.this$0)[n][n2] = OptionsSetter.access$5(this.this$0)[n][n2];
                        OptionsSetter.access$3(this.this$0).setForeground(OptionsSetter.access$2(this.this$0)[OptionsSetter.access$0(this.this$0)][0]);
                        OptionsSetter.access$3(this.this$0).setBackground(OptionsSetter.access$2(this.this$0)[OptionsSetter.access$0(this.this$0)][1]);
                        OptionsSetter.access$3(this.this$0).setVisible(false);
                        OptionsSetter.access$3(this.this$0).invalidate();
                        OptionsSetter.access$3(this.this$0).setVisible(true);
                        ++n2;
                    }
                    ++n;
                }
            }
            {
                this.this$0 = optionsSetter;
                this.constructor$0(optionsSetter);
            }

            private final void constructor$0(OptionsSetter optionsSetter) {
            }
        });
        jPanel3.add(jButton);
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        return jPanel;
    }

    private JComponent makeDisplayPanel() {
        JPanel jPanel = new JPanel(false);
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setAlignmentY(0.5f);
        jPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        OptionsSetter optionsSetter = this;
        if (optionsSetter == null) {
            throw null;
        }
        CheckAdapter checkAdapter = optionsSetter.new CheckAdapter();
        JPanel jPanel2 = new JPanel(false);
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setAlignmentY(0.0f);
        jPanel2.setBorder(new EmptyBorder(5, 5, 5, 5));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.setAlignmentX(0.0f);
        JLabel jLabel = new JLabel(this.getCommonResources().getString("OPT_DISP_TAB_LABEL"));
        jPanel3.add(jLabel);
        OptionsSetter optionsSetter2 = this;
        if (optionsSetter2 == null) {
            throw null;
        }
        this.m_tabDocument = new PlainDocument(optionsSetter2){
            private final /* synthetic */ OptionsSetter this$0;

            public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
                if (string == null) {
                    return;
                }
                StringBuffer stringBuffer = new StringBuffer(string.length());
                int n2 = string.length();
                int n3 = 0;
                while (n3 < n2) {
                    char c = string.charAt(n3);
                    if ('0' <= c && c <= '9') {
                        stringBuffer.append(c);
                    }
                    ++n3;
                }
                super.insertString(n, stringBuffer.toString(), attributeSet);
            }
            {
                this.this$0 = optionsSetter;
                this.constructor$0(optionsSetter);
            }

            private final void constructor$0(OptionsSetter optionsSetter) {
            }
        };
        OptionsSetter optionsSetter3 = this;
        if (optionsSetter3 == null) {
            throw null;
        }
        this.m_tabDocument.addDocumentListener(new DocumentListener(optionsSetter3){
            private final /* synthetic */ OptionsSetter this$0;

            public void insertUpdate(DocumentEvent documentEvent) {
                Document document = documentEvent.getDocument();
                try {
                    OptionsSetter.access$8(this.this$0, Integer.decode(document.getText(0, document.getLength())));
                }
                catch (BadLocationException badLocationException) {
                    OptionsSetter.access$8(this.this$0, 8);
                }
                catch (NumberFormatException numberFormatException) {
                    OptionsSetter.access$8(this.this$0, 8);
                }
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                Document document = documentEvent.getDocument();
                try {
                    OptionsSetter.access$8(this.this$0, Integer.decode(document.getText(0, document.getLength())));
                }
                catch (BadLocationException badLocationException) {
                    OptionsSetter.access$8(this.this$0, 8);
                }
                catch (NumberFormatException numberFormatException) {
                    OptionsSetter.access$8(this.this$0, 8);
                }
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }
            {
                this.this$0 = optionsSetter;
                this.constructor$0(optionsSetter);
            }

            private final void constructor$0(OptionsSetter optionsSetter) {
            }
        });
        this.m_tabEntry = new JTextField(this.m_tabDocument, "8", 2);
        jPanel3.add(this.m_tabEntry);
        jPanel2.add(jPanel3);
        JCheckBox jCheckBox = new JCheckBox(this.getCommonResources().getString("OPT_DISP_LINE_NUMBERS"), true);
        jCheckBox.setActionCommand(SHOW_LINE_NUMS);
        this.m_showLinesModel = jCheckBox.getModel();
        jCheckBox.getModel().addItemListener(checkAdapter);
        jCheckBox.setAlignmentX(0.0f);
        jPanel2.add(jCheckBox);
        jCheckBox = new JCheckBox(this.getCommonResources().getString("OPT_DISP_DIFFS_ONLY"), true);
        jCheckBox.setActionCommand(DIFFS_ONLY);
        this.m_showDiffOnlyModel = jCheckBox.getModel();
        jCheckBox.getModel().addItemListener(checkAdapter);
        jCheckBox.setAlignmentX(0.0f);
        jPanel2.add(jCheckBox);
        JPanel jPanel4 = new JPanel(false);
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        jPanel4.setAlignmentY(0.0f);
        jPanel4.setBorder(new EmptyBorder(5, 5, 5, 5));
        jCheckBox = new JCheckBox(this.getCommonResources().getString("OPT_DISP_SHOW_TOOLBAR"), true);
        jCheckBox.setActionCommand(SHOW_TOOLBAR);
        this.m_showToolbarModel = jCheckBox.getModel();
        jCheckBox.getModel().addItemListener(checkAdapter);
        jPanel4.add(jCheckBox);
        jCheckBox = new JCheckBox(this.getCommonResources().getString("OPT_DISP_SHOW_STATUSBAR"), true);
        jCheckBox.setActionCommand(SHOW_STATUSBAR);
        this.m_showStatusbarModel = jCheckBox.getModel();
        jCheckBox.getModel().addItemListener(checkAdapter);
        jPanel4.add(jCheckBox);
        jPanel.add(jPanel2);
        jPanel.add(jPanel4);
        return jPanel;
    }

    private ResourceBundle getCommonResources() {
        if (this.m_resources == null) {
            System.out.println("*********************** no resources ********");
        }
        return this.m_resources;
    }

    private void setCommonResources(ResourceBundle resourceBundle) {
        this.m_resources = resourceBundle;
    }

    static /* synthetic */ int access$0(OptionsSetter optionsSetter) {
        return optionsSetter.m_hotColor;
    }

    static /* synthetic */ void access$1(OptionsSetter optionsSetter, int n) {
        optionsSetter.m_hotColor = n;
    }

    static /* synthetic */ Color[][] access$2(OptionsSetter optionsSetter) {
        return optionsSetter.m_colorVals;
    }

    static /* synthetic */ JTextField access$3(OptionsSetter optionsSetter) {
        return optionsSetter.m_sampleArea;
    }

    static /* synthetic */ ResourceBundle access$4(OptionsSetter optionsSetter) {
        return optionsSetter.getCommonResources();
    }

    static /* synthetic */ Color[][] access$5(OptionsSetter optionsSetter) {
        return optionsSetter.m_defaultColorVals;
    }

    static /* synthetic */ int access$7() {
        return DEFAULT_TAB_SIZE;
    }

    static /* synthetic */ void access$8(OptionsSetter optionsSetter, int n) {
        optionsSetter.m_tabSize = n;
    }

    static /* synthetic */ int access$9(OptionsSetter optionsSetter) {
        return optionsSetter.m_status;
    }

    OptionsSetter(Frame frame, boolean bl, ResourceBundle resourceBundle) {
        super(frame, bl);
        this.setCommonResources(resourceBundle);
        this.setTitle(resourceBundle.getString("OPT_Title"));
        this.m_dataValues = new Hashtable();
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.m_tabbedPane = new JTabbedPane();
        Icon icon = null;
        OptionsSetter optionsSetter = this;
        if (optionsSetter == null) {
            throw null;
        }
        ButtonListener buttonListener = optionsSetter.new ButtonListener(this);
        String string = resourceBundle.getString("OPT_TAB_DISPLAY");
        String string2 = resourceBundle.getString("OPT_TAB_DISPLAY_DES");
        JComponent jComponent = this.makeDisplayPanel();
        this.m_tabbedPane.addTab(string, icon, jComponent, string2);
        this.m_tabbedPane.setSelectedIndex(0);
        string = resourceBundle.getString("OPT_TAB_COLOR");
        string2 = resourceBundle.getString("OPT_TAB_COLOR_DES");
        jComponent = this.makeColorsPanel();
        this.m_tabbedPane.addTab(string, icon, jComponent, string2);
        string = resourceBundle.getString("OPT_TAB_COMPARE");
        string2 = resourceBundle.getString("OPT_TAB_COMPARE_DES");
        jComponent = this.makeComparePanel();
        this.m_tabbedPane.addTab(string, icon, jComponent, string2);
        container.add((Component)this.m_tabbedPane, "Center");
        JPanel jPanel = new JPanel(new FlowLayout(2));
        JButton jButton = new JButton(resourceBundle.getString("BTN_IDOK"));
        jButton.setActionCommand("OK");
        jButton.addActionListener(buttonListener);
        jPanel.add(jButton);
        this.getRootPane().setDefaultButton(jButton);
        jButton = new JButton(resourceBundle.getString("BTN_IDCANCEL"));
        jButton.setActionCommand("CANCEL");
        jButton.addActionListener(buttonListener);
        jPanel.add(jButton);
        container.add((Component)jPanel, "South");
    }

    private class ButtonListener
    implements ActionListener {
        private Component m_parent;

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("OK")) {
                OptionsSetter.this.putValue(OptionsSetter.TAB_SIZE, new Integer(OptionsSetter.this.m_tabSize));
                OptionsSetter.this.m_status = 1;
                this.m_parent.setVisible(false);
            } else if (string.equals("CANCEL")) {
                OptionsSetter.this.m_status = 0;
                this.m_parent.setVisible(false);
            }
        }

        ButtonListener() {
        }

        ButtonListener(Component component) {
            this();
            this.m_parent = component;
        }
    }

    private class CheckAdapter
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            ButtonModel buttonModel = (ButtonModel)itemEvent.getSource();
            int n = itemEvent.getStateChange();
            if (n == 1) {
                OptionsSetter.this.putValue(buttonModel.getActionCommand(), new Boolean(true));
            } else if (n == 2) {
                OptionsSetter.this.putValue(buttonModel.getActionCommand(), new Boolean(false));
            }
        }

        CheckAdapter() {
        }
    }

    private class WhiteAdapter
    implements ActionListener {
        private OptionsSetter m_parent;
        private String m_key;
        private int m_value;

        public void actionPerformed(ActionEvent actionEvent) {
            this.m_parent.putValue(this.m_key, new Integer(this.m_value));
        }

        WhiteAdapter() {
        }

        WhiteAdapter(OptionsSetter optionsSetter2, String string, int n) {
            this();
            this.m_parent = optionsSetter2;
            this.m_key = string;
            this.m_value = n;
        }
    }
}

