/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.visdiff;

import com.starbase.diff.ParsedCharSequence;
import com.starbase.visdiff.DefaultDiffedDocument;
import com.starbase.visdiff.DiffContext;
import com.starbase.visdiff.DiffEditorKit;
import com.starbase.visdiff.DiffViewer;
import com.starbase.visdiff.DiffedDocument;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Hashtable;
import javax.swing.Action;
import javax.swing.BoundedRangeModel;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;

class DefaultDiffViewer
extends JPanel
implements DiffViewer {
    private ParsedCharSequence m_charSequence = null;
    protected DiffedDocument m_doc = null;
    protected JEditorPane m_pane = null;
    private JScrollPane m_scrollPane = null;
    private String m_title = "...";
    private JLabel m_titleLabel = null;
    private JEditorPane m_lineNumbers = null;
    private boolean m_showLineNumbers = false;
    private Hashtable m_editorCommands;
    private boolean m_selectionPresent = false;
    PropertyChangeSupport m_propSupport = new PropertyChangeSupport(this);

    private boolean isSupportedFont(String string) {
        String[] stringArray = new Frame().getToolkit().getFontList();
        int n = 0;
        while (n < stringArray.length) {
            if (string.equals(stringArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private JEditorPane makeLineNumbers() {
        JEditorPane jEditorPane = new JEditorPane();
        DiffEditorKit diffEditorKit = new DiffEditorKit();
        jEditorPane.setEditorKitForContentType("text/x-diff", diffEditorKit);
        jEditorPane.setContentType("text/x-diff");
        jEditorPane.setBackground(Color.white);
        jEditorPane.setEditable(false);
        DiffContext diffContext = diffEditorKit.getStylePreferences();
        diffContext.setNumberOnly(true);
        return jEditorPane;
    }

    public void setSequence(ParsedCharSequence parsedCharSequence) {
        this.m_charSequence = parsedCharSequence;
    }

    public ParsedCharSequence getSequence() {
        return this.m_charSequence;
    }

    public void setDocument(DiffedDocument diffedDocument) {
        this.m_doc = diffedDocument;
        this.m_pane.setDocument(this.m_doc);
        this.m_lineNumbers.setDocument(this.m_doc);
    }

    public DiffedDocument getDocument() {
        return this.m_doc;
    }

    public String getTitle() {
        return this.m_title;
    }

    public void setTitle(String string) {
        this.m_title = string;
        if (this.m_titleLabel == null) {
            this.m_titleLabel = new JLabel();
            this.add((Component)this.m_titleLabel, "North");
        }
        this.m_titleLabel.setText(this.m_title);
        this.revalidate();
    }

    public boolean isNumberingVisible() {
        return this.m_showLineNumbers;
    }

    public void setNumberingVisible(boolean bl) {
        this.m_showLineNumbers = bl;
        if (this.m_showLineNumbers) {
            this.m_scrollPane.setRowHeaderView(this.m_lineNumbers);
        } else {
            this.m_scrollPane.setRowHeaderView(null);
        }
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return this.m_pane.getScrollableUnitIncrement(rectangle, n, n2);
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return this.m_pane.getScrollableBlockIncrement(rectangle, n, n2);
    }

    public BoundedRangeModel getVerticalScrollModel() {
        return this.m_scrollPane.getVerticalScrollBar().getModel();
    }

    public BoundedRangeModel getHorizontalScrollModel() {
        return this.m_scrollPane.getHorizontalScrollBar().getModel();
    }

    public int getCurrentLine() {
        Point point = this.m_scrollPane.getViewport().getViewPosition();
        int n = this.m_pane.viewToModel(point);
        return this.m_doc.getDefaultRootElement().getElementIndex(n);
    }

    public void setCurrentLine(int n) throws BadLocationException {
        Element element = this.m_doc.getDefaultRootElement().getElement(n);
        Rectangle rectangle = this.m_pane.modelToView(element.getStartOffset());
        Point point = rectangle.getLocation();
        this.m_scrollPane.getViewport().setViewPosition(point);
    }

    public int getDiffAfter(int n) {
        Element element = this.m_doc.getDefaultRootElement();
        Element element2 = element.getElement(n);
        int n2 = element2.getStartOffset();
        int n3 = this.m_doc.getDiffAfter(n2);
        return element.getElementIndex(n3);
    }

    public int getDiffBefore(int n) {
        Element element = this.m_doc.getDefaultRootElement();
        Element element2 = element.getElement(n);
        int n2 = element2.getStartOffset();
        int n3 = this.m_doc.getDiffBefore(n2);
        return element.getElementIndex(n3);
    }

    public int getMatchAfter(int n) {
        Element element = this.m_doc.getDefaultRootElement();
        Element element2 = element.getElement(n);
        int n2 = element2.getStartOffset();
        int n3 = this.m_doc.getMatchAfter(n2);
        return element.getElementIndex(n3);
    }

    public int getMatchBefore(int n) {
        Element element = this.m_doc.getDefaultRootElement();
        Element element2 = element.getElement(n);
        int n2 = element2.getStartOffset();
        int n3 = this.m_doc.getMatchBefore(n2);
        return element.getElementIndex(n3);
    }

    public void setTabSize(int n) {
        DiffEditorKit diffEditorKit = this.getEditorKit();
        DiffContext diffContext = diffEditorKit.getStylePreferences();
        diffContext.setTabSize(n);
    }

    public void setDiffColor(int n, Color color) {
        switch (n) {
            case 0: {
                this.setPaneColors("same", color);
                break;
            }
            case 1: {
                this.setPaneColors("add", color);
                break;
            }
            case 2: {
                this.setPaneColors("del", color);
                break;
            }
            case 3: {
                this.setPaneColors("repl", color);
                break;
            }
            case 4: {
                this.setPaneColors("move", color);
                break;
            }
        }
    }

    private void setPaneColors(String string, Color color) {
        DiffEditorKit diffEditorKit = this.getEditorKit();
        DiffContext diffContext = diffEditorKit.getStylePreferences();
        Style style = diffContext.getStyle(string);
        if (style != null) {
            StyleConstants.setForeground(style, color);
            diffContext.hackPurge();
        }
        if ((style = (diffContext = (diffEditorKit = (DiffEditorKit)this.m_lineNumbers.getEditorKit()).getStylePreferences()).getStyle(string)) != null) {
            StyleConstants.setForeground(style, color);
            diffContext.hackPurge();
        }
    }

    public boolean find(String string, boolean bl, boolean bl2) {
        boolean bl3 = false;
        String string2 = bl ? string : string.toLowerCase();
        DiffedDocument diffedDocument = this.getDocument();
        if (diffedDocument != null) {
            Element element = diffedDocument.getDefaultRootElement();
            int n = element.getElementCount();
            int n2 = -1;
            int n3 = this.m_pane.getCaretPosition();
            n3 = n3 < 0 ? 0 : ++n3;
            int n4 = element.getElementIndex(n3);
            int n5 = n3 - element.getElement(n4).getStartOffset();
            int n6 = n4;
            while (n6 < n) {
                Element element2 = element.getElement(n6);
                int n7 = element2.getStartOffset();
                int n8 = element2.getEndOffset();
                Segment segment = new Segment();
                try {
                    diffedDocument.getText(n7, n8 - n7, segment);
                }
                catch (BadLocationException badLocationException) {
                    break;
                }
                String string3 = segment.toString();
                if (!bl) {
                    string3 = string3.toLowerCase();
                }
                if ((n2 = string3.indexOf(string2, n5)) >= 0) {
                    bl3 = true;
                    n2 += n7;
                    break;
                }
                n5 = 0;
                ++n6;
            }
            if (bl3) {
                this.m_pane.setCaretPosition(n2);
                this.m_pane.moveCaretPosition(n2 + string.length());
            }
        }
        return bl3;
    }

    public void fireEditorAction(String string) {
        Hashtable hashtable = this.getCommandList();
        Action action = (Action)hashtable.get(string);
        if (action == null) {
            throw new IllegalArgumentException();
        }
        action.actionPerformed(new ActionEvent(this.m_pane, 1001, (String)action.getValue("Name")));
    }

    private DiffEditorKit getEditorKit() {
        return (DiffEditorKit)this.m_pane.getEditorKit();
    }

    private Hashtable buildCommandList(DiffEditorKit diffEditorKit) {
        Hashtable<Object, Action> hashtable = new Hashtable<Object, Action>();
        Action[] actionArray = diffEditorKit.getActions();
        int n = 0;
        while (n < actionArray.length) {
            hashtable.put(actionArray[n].getValue("Name"), actionArray[n]);
            ++n;
        }
        return hashtable;
    }

    private Hashtable getCommandList() {
        return this.m_editorCommands;
    }

    private void setCommandList(Hashtable hashtable) {
        this.m_editorCommands = hashtable;
    }

    public void setCaretPosition(int n) {
        this.m_pane.setCaretPosition(n);
    }

    public boolean isSelectionPresent() {
        return this.m_selectionPresent;
    }

    public void setSelectionPresent(boolean bl) {
        this.m_selectionPresent = bl;
        this.m_propSupport.firePropertyChange("selectionPresent", new Boolean(!bl), new Boolean(bl));
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.m_propSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.m_propSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public DefaultDiffViewer() {
        this.setLayout(new BorderLayout());
        DefaultDiffViewer defaultDiffViewer = this;
        if (defaultDiffViewer == null) {
            throw null;
        }
        this.m_pane = defaultDiffViewer.new HscrollEditorPane();
        DiffEditorKit diffEditorKit = new DiffEditorKit();
        this.m_pane.setEditorKitForContentType("text/x-diff", diffEditorKit);
        this.m_pane.setContentType("text/x-diff");
        this.m_pane.setBackground(Color.white);
        this.m_pane.setEditable(false);
        this.setCommandList(this.buildCommandList(diffEditorKit));
        this.m_doc = new DefaultDiffedDocument();
        this.m_pane.setDocument(this.m_doc);
        String string = "Monospaced";
        if (!this.isSupportedFont("Monospaced")) {
            string = "Courier";
        }
        Font font = new Font(string, 0, 12);
        this.m_pane.setFont(font);
        this.m_scrollPane = new JScrollPane();
        this.m_scrollPane.setVerticalScrollBarPolicy(21);
        this.m_scrollPane.setHorizontalScrollBarPolicy(30);
        this.m_scrollPane.setViewportView(this.m_pane);
        this.m_lineNumbers = this.makeLineNumbers();
        this.m_lineNumbers.setFont(font);
        this.m_scrollPane.setRowHeaderView(this.m_lineNumbers);
        this.m_scrollPane.setMinimumSize(new Dimension(10, 10));
        this.add((Component)new JLabel(this.m_title), "North");
        this.add((Component)this.m_scrollPane, "Center");
    }

    private class HscrollEditorPane
    extends JEditorPane {
        public boolean getScrollableTracksViewportWidth() {
            return false;
        }

        HscrollEditorPane() {
        }
    }
}

