/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.util.swing;

import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class ButtonLook {
    private String m_displayName;
    private String m_toolTipText;
    private char m_mnemonic;
    private KeyStroke m_accelerator;
    private Icon m_icon;
    private Icon m_selectedIcon;

    public void configure(AbstractButton abstractButton) {
        Icon icon;
        abstractButton.setText(this.getDisplayName());
        if (this.getToolTipText() != null) {
            abstractButton.setToolTipText(this.getToolTipText());
        }
        if (this.getMnemonic() != '\u0000') {
            abstractButton.setMnemonic(this.getMnemonic());
        }
        if (abstractButton instanceof JMenuItem && !(abstractButton instanceof JMenu) && this.getAccelerator() != null) {
            ((JMenuItem)abstractButton).setAccelerator(this.getAccelerator());
        }
        if ((icon = this.getIcon()) != null) {
            abstractButton.setIcon(icon);
        }
        if ((icon = this.getSelectedIcon()) != null) {
            abstractButton.setSelectedIcon(icon);
        }
    }

    public static ButtonLook createMenuLook(String string, char c) {
        return new ButtonLook(string, null, c, null, null, null);
    }

    public static ButtonLook createMenuItemLook(String string, char c, KeyStroke keyStroke) {
        return new ButtonLook(string, null, c, keyStroke, null, null);
    }

    public static ButtonLook createToolbarItemLook(String string, String string2, Icon icon, Icon icon2) {
        return new ButtonLook(string, string2, '\u0000', null, icon, icon2);
    }

    public String getDisplayName() {
        return this.m_displayName;
    }

    public void setDisplayName(String string) {
        this.m_displayName = string;
    }

    public String getToolTipText() {
        return this.m_toolTipText;
    }

    public void setToolTipText(String string) {
        this.m_toolTipText = string;
    }

    public char getMnemonic() {
        return this.m_mnemonic;
    }

    public void setMnemonic(char c) {
        this.m_mnemonic = c;
    }

    public KeyStroke getAccelerator() {
        return this.m_accelerator;
    }

    public void setAccelerator(KeyStroke keyStroke) {
        this.m_accelerator = keyStroke;
    }

    public Icon getIcon() {
        return this.m_icon;
    }

    public void setIcon(Icon icon) {
        this.m_icon = icon;
    }

    public Icon getSelectedIcon() {
        return this.m_selectedIcon;
    }

    public void setSelectedIcon(Icon icon) {
        this.m_selectedIcon = icon;
    }

    public ButtonLook(String string, String string2, char c, KeyStroke keyStroke, Icon icon, Icon icon2) {
        this.m_displayName = string;
        this.m_toolTipText = string2;
        this.m_mnemonic = c;
        this.m_accelerator = keyStroke;
        this.m_icon = icon;
        this.m_selectedIcon = icon2;
    }
}

