/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.util;

import com.starbase.util.MD5;
import com.starbase.util.MD5Impl;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class StreamUtils {
    public static int bufferedTransfer(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        return StreamUtils.bufferedTransfer(inputStream, outputStream, n, null);
    }

    public static int eatStream(InputStream inputStream, int n) throws IOException {
        return StreamUtils.bufferedTransfer(inputStream, null, n, null);
    }

    public static int eatStream(InputStream inputStream, int n, MD5 mD5) throws IOException {
        return StreamUtils.bufferedTransfer(inputStream, null, n, mD5);
    }

    public static int bufferedTransfer(InputStream inputStream, OutputStream outputStream, int n, MD5 mD5) throws IOException {
        MD5Impl mD5Impl = null;
        if (mD5 != null) {
            mD5Impl = new MD5Impl();
        }
        int n2 = 0;
        int n3 = n <= 0 ? 2048 : n;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, n3);
        BufferedOutputStream bufferedOutputStream = null;
        if (outputStream != null) {
            bufferedOutputStream = new BufferedOutputStream(outputStream, n3);
        }
        byte[] byArray = new byte[n3];
        int n4 = 0;
        if (mD5Impl != null) {
            mD5Impl.reset();
        }
        while (n4 != -1) {
            n4 = bufferedInputStream.read(byArray, 0, n3);
            if (n4 == -1) continue;
            n2 += n4;
            if (bufferedOutputStream != null) {
                bufferedOutputStream.write(byArray, 0, n4);
            }
            if (mD5Impl == null) continue;
            mD5Impl.update(byArray, 0, n4);
        }
        if (bufferedOutputStream != null) {
            bufferedOutputStream.flush();
        }
        if (mD5 != null) {
            mD5.setData(mD5Impl.digest());
        }
        return n2;
    }
}

