/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.util;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class OSEnvironment {
    private static boolean m_isComMsGood = false;
    private static boolean m_isNativeGood = false;
    private static final String MS_CLASS = "com.ms.win32.Kernel32";
    private static final String MS_METHOD_NAME = "GetEnvironmentVariable";
    private static Class m_kernelClass = null;
    private static Method m_GetEnvironmentVariable = null;
    private static final String NATIVE_LIB_NAME = "StSDKOSEnvironment";
    private static /* synthetic */ Class class$Ljava$lang$String;
    private static /* synthetic */ Class class$Ljava$lang$StringBuffer;

    public static boolean isAvailable() {
        return m_isComMsGood | m_isNativeGood;
    }

    public static String getEnvironmentVariable(String string) throws IOException {
        String string2 = m_isComMsGood ? OSEnvironment.getEnvViaComMs(string) : (m_isNativeGood ? OSEnvironment.getEnvViaNative(string) : null);
        return string2;
    }

    private static String getEnvViaComMs(String string) {
        if (!m_isComMsGood) {
            return null;
        }
        StringBuffer stringBuffer = null;
        int n = 2;
        int n2 = 0;
        String string2 = null;
        int n3 = 0;
        while (n3 < n && string2 == null) {
            Integer n4;
            stringBuffer = new StringBuffer(n2);
            Object[] objectArray = new Object[]{string, stringBuffer, new Integer(n2)};
            try {
                n4 = (Integer)m_GetEnvironmentVariable.invoke(null, objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                string2 = null;
                break;
            }
            catch (InvocationTargetException invocationTargetException) {
                string2 = null;
                break;
            }
            int n5 = n4;
            if (n5 > n2) {
                n2 = n5;
            } else {
                if (n5 < 1) break;
                string2 = stringBuffer.toString();
            }
            ++n3;
        }
        return string2;
    }

    private static String getEnvViaNative(String string) throws IOException {
        if (!m_isNativeGood) {
            return null;
        }
        return OSEnvironment.getWin32Env(string);
    }

    private static native String getWin32Env(String var0) throws IOException;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            m_kernelClass = Class.forName(MS_CLASS);
            Class[] classArray = new Class[]{class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = OSEnvironment.class$("java.lang.String")), class$Ljava$lang$StringBuffer != null ? class$Ljava$lang$StringBuffer : (class$Ljava$lang$StringBuffer = OSEnvironment.class$("java.lang.StringBuffer")), Integer.TYPE};
            m_GetEnvironmentVariable = m_kernelClass.getMethod(MS_METHOD_NAME, classArray);
            m_isComMsGood = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            m_kernelClass = null;
            m_isComMsGood = false;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            m_kernelClass = null;
            m_GetEnvironmentVariable = null;
            m_isComMsGood = false;
        }
        try {
            System.loadLibrary(NATIVE_LIB_NAME);
            m_isNativeGood = true;
        }
        catch (LinkageError linkageError) {
            m_isNativeGood = false;
        }
    }
}

