/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.util;

import com.starbase.util.OLEDate;
import com.starbase.util.OLEDateFormatJava;
import com.starbase.util.OLEDateFormatNative;
import com.starbase.util.Platform;
import com.starbase.util.Res;
import com.starbase.util.ResIDs;

public abstract class OLEDateFormat {
    public static final int SHORT = 3;
    public static final int LONG = 1;

    public static OLEDateFormat getLocalDateTimeInstance() {
        if (Platform.isWin32()) {
            return OLEDateFormatNative.getLocalDateTimeInstanceNative();
        }
        return OLEDateFormat.getDateTimeInstance(3, 1);
    }

    public static OLEDateFormat getLocalDateInstance() {
        if (Platform.isWin32()) {
            return OLEDateFormatNative.getLocalDateInstanceNative();
        }
        return OLEDateFormat.getDateInstance(3);
    }

    public static OLEDateFormat getTimeInstance(int n) {
        if (n != 3 && n != 1) {
            throw new IllegalArgumentException(Res.formatKey(ResIDs.INVALID_TIME_STYLE_FMT, new Object[]{new Integer(n)}));
        }
        if (Platform.isWin32()) {
            return OLEDateFormatNative.getTimeInstanceNative(n);
        }
        return OLEDateFormatJava.getTimeInstanceJava(n);
    }

    public static OLEDateFormat getDateInstance(int n) {
        if (n != 3 && n != 1) {
            throw new IllegalArgumentException(Res.formatKey(ResIDs.INVALID_DATE_STYLE_FMT, new Object[]{new Integer(n)}));
        }
        if (Platform.isWin32()) {
            return OLEDateFormatNative.getDateInstanceNative(n);
        }
        return OLEDateFormatJava.getDateInstanceJava(n);
    }

    public static OLEDateFormat getDateTimeInstance(int n, int n2) {
        if (n != 3 && n != 1) {
            throw new IllegalArgumentException(Res.formatKey(ResIDs.INVALID_DATE_STYLE_FMT, new Object[]{new Integer(n)}));
        }
        if (n2 != 3 && n2 != 1) {
            throw new IllegalArgumentException(Res.formatKey(ResIDs.INVALID_TIME_STYLE_FMT, new Object[]{new Integer(n2)}));
        }
        if (Platform.isWin32()) {
            return OLEDateFormatNative.getDateTimeInstanceNative(n, n2);
        }
        return OLEDateFormatJava.getDateTimeInstanceJava(n, n2);
    }

    public abstract String format(OLEDate var1);

    protected OLEDateFormat() {
    }
}

