/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.util;

import com.starbase.util.MD5Impl;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class MD5 {
    private byte[] m_MD5Data = new byte[16];

    public int hashCode() {
        int n = 0;
        int n2 = 0;
        while (n2 < 16) {
            n = n * 37 + this.m_MD5Data[n2];
            ++n2;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object instanceof MD5) {
            MD5 mD5 = (MD5)object;
            boolean bl = true;
            byte[] byArray = mD5.getData();
            int n = 0;
            while (n < 16) {
                if (byArray[n] != this.m_MD5Data[n]) {
                    bl = false;
                    break;
                }
                ++n;
            }
            return bl;
        }
        return false;
    }

    public void computeBufferMD5(byte[] byArray) {
        MD5Impl mD5Impl = this.getDigestInstance();
        this.setData(mD5Impl.digest(byArray));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n = 0;
        while (n < 16) {
            stringBuffer.append("0x" + Integer.toHexString(this.m_MD5Data[n] & 0xFF));
            if (n != 16) {
                stringBuffer.append(" ");
            }
            ++n;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public int computeStreamMD5(InputStream inputStream) throws IOException {
        int n = 0;
        int n2 = 0;
        int n3 = 2048;
        byte[] byArray = new byte[n3];
        MD5Impl mD5Impl = this.getDigestInstance();
        do {
            if ((n2 = inputStream.read(byArray, 0, n3)) == -1) continue;
            n += n2;
            mD5Impl.update(byArray, 0, n2);
        } while (n2 != -1);
        this.setData(mD5Impl.digest());
        return n;
    }

    public int computeFileMD5(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        int n = 0;
        try {
            n = this.computeStreamMD5(bufferedInputStream);
        }
        finally {
            Object var6_5 = null;
            ((InputStream)bufferedInputStream).close();
            fileInputStream.close();
        }
        return n;
    }

    public byte[] getData() {
        return this.m_MD5Data;
    }

    public void setData(byte[] byArray) {
        System.arraycopy(byArray, 0, this.m_MD5Data, 0, 16);
    }

    private MD5Impl getDigestInstance() {
        return new MD5Impl();
    }

    public MD5() {
    }

    public MD5(byte[] byArray) {
        this.setData(byArray);
    }

    public MD5(MD5 mD5) {
        this.setData(mD5.getData());
    }
}

