/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.util;

import com.starbase.util.Res;
import com.starbase.util.ResIDs;
import java.io.IOException;
import java.io.Reader;

public class LineReader
extends Reader {
    public static final int EOL_UNKNOWN = -1;
    public static final int EOL_CR = 0;
    public static final int EOL_LF = 1;
    public static final int EOL_CRLF = 2;
    public static final int EOL_EOF = 3;
    private static final int INVALIDATED = -2;
    private static final int UNMARKED = -1;
    private static int m_defaultCharBufferSize = 8192;
    private static int m_defaultExpectedLineLength = 80;
    private int m_lastEOL = -1;
    private Reader m_in;
    private char[] m_cb;
    private int m_nChars;
    private int m_nextChar;
    private int m_markedChar = -1;
    private int m_readAheadLimit = 0;

    private void ensureOpen() throws IOException {
        if (this.m_in == null) {
            throw new IOException(Res.getString(ResIDs.STREAM_CLOSED));
        }
    }

    private void fill() throws IOException {
        int n;
        int n2;
        if (this.m_markedChar <= -1) {
            n2 = 0;
        } else {
            n = this.m_nextChar - this.m_markedChar;
            if (n >= this.m_readAheadLimit) {
                this.m_markedChar = -2;
                this.m_readAheadLimit = 0;
                n2 = 0;
            } else if (this.m_readAheadLimit <= this.m_cb.length) {
                System.arraycopy(this.m_cb, this.m_markedChar, this.m_cb, 0, n);
                this.m_markedChar = 0;
                n2 = n;
            } else {
                char[] cArray = new char[this.m_readAheadLimit];
                System.arraycopy(this.m_cb, this.m_markedChar, cArray, 0, n);
                this.m_cb = cArray;
                this.m_markedChar = 0;
                n2 = n;
            }
        }
        while ((n = this.m_in.read(this.m_cb, n2, this.m_cb.length - n2)) == 0) {
        }
        if (n > 0) {
            this.m_nChars = n2 + n;
            this.m_nextChar = n2;
        }
    }

    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.m_nextChar >= this.m_nChars) {
                this.fill();
                if (this.m_nextChar >= this.m_nChars) {
                    int n = -1;
                    Object var2_4 = null;
                    return n;
                }
            }
            char c = this.m_cb[this.m_nextChar++];
            Object var2_5 = null;
            return c;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.m_nextChar >= this.m_nChars) {
                if (n2 >= this.m_cb.length && this.m_markedChar <= -1) {
                    return this.m_in.read(cArray, n, n2);
                }
                this.fill();
            }
            if (this.m_nextChar >= this.m_nChars) {
                return -1;
            }
            int n3 = Math.min(n2, this.m_nChars - this.m_nextChar);
            System.arraycopy(this.m_cb, this.m_nextChar, cArray, n, n3);
            this.m_nextChar += n3;
            return n3;
        }
    }

    public int getLastEOL() {
        return this.m_lastEOL;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String readLine() throws IOException {
        this.m_lastEOL = 3;
        StringBuffer stringBuffer = new StringBuffer(m_defaultExpectedLineLength);
        Object object = this.lock;
        synchronized (object) {
            char c;
            boolean bl;
            this.ensureOpen();
            do {
                if (this.m_nextChar >= this.m_nChars) {
                    this.fill();
                }
                if (this.m_nextChar >= this.m_nChars) {
                    if (stringBuffer.length() <= 0) return null;
                    return stringBuffer.toString();
                }
                bl = false;
                c = '\u0000';
                int n = this.m_nextChar;
                while (n < this.m_nChars) {
                    c = this.m_cb[n];
                    if (c == '\n' || c == '\r') {
                        bl = true;
                        this.m_lastEOL = c == '\n' ? 1 : 0;
                        break;
                    }
                    ++n;
                }
                stringBuffer.append(this.m_cb, this.m_nextChar, n - this.m_nextChar);
                this.m_nextChar = n;
            } while (!bl);
            ++this.m_nextChar;
            if (c != '\r') return stringBuffer.toString();
            if (this.m_nextChar >= this.m_nChars) {
                this.fill();
            }
            if (this.m_nextChar >= this.m_nChars) return stringBuffer.toString();
            if (this.m_cb[this.m_nextChar] != '\n') return stringBuffer.toString();
            ++this.m_nextChar;
            this.m_lastEOL = 2;
            return stringBuffer.toString();
        }
    }

    public long skip(long l) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            long l2 = l;
            while (l2 > 0L) {
                if (this.m_nextChar >= this.m_nChars) {
                    this.fill();
                }
                if (this.m_nextChar >= this.m_nChars) break;
                long l3 = this.m_nChars - this.m_nextChar;
                if (l2 <= l3) {
                    this.m_nextChar = (int)((long)this.m_nextChar + l2);
                    l2 = 0L;
                    break;
                }
                l2 -= l3;
                this.m_nextChar = this.m_nChars;
            }
            long l4 = l - l2;
            Object var4_6 = null;
            return l4;
        }
    }

    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            boolean bl = this.m_nextChar < this.m_nChars || this.m_in.ready();
            Object var2_3 = null;
            return bl;
        }
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int n) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException(Res.getString(ResIDs.READ_AHEAD_LIMIT_LT_0));
        }
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            this.m_readAheadLimit = n;
            this.m_markedChar = this.m_nextChar;
        }
    }

    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.m_markedChar < 0) {
                throw new IOException(this.m_markedChar == -2 ? Res.getString(ResIDs.STREAM_MARK_IS_INVALID) : Res.getString(ResIDs.STREAM_IS_NOT_MARKED));
            }
            this.m_nextChar = this.m_markedChar;
        }
    }

    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.m_in == null) {
                Object var2_2 = null;
                return;
            }
            this.m_in.close();
            this.m_in = null;
            this.m_cb = null;
        }
    }

    public LineReader(Reader reader, int n) {
        super((Object)reader);
        if (n <= 0) {
            throw new IllegalArgumentException(Res.getString(ResIDs.BUFFER_SIZE_LE_0));
        }
        this.m_in = reader;
        this.m_cb = new char[n];
        this.m_nChars = 0;
        this.m_nextChar = 0;
    }

    public LineReader(Reader reader) {
        this(reader, m_defaultCharBufferSize);
    }
}

