/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.util;

import com.starbase.util.Assert;
import com.starbase.util.LineReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Vector;

public abstract class LineProcessor
extends Reader {
    private static final int INIT = 0;
    private static final int LINE = 1;
    private static final int DONE = 2;
    private LineReader m_source;
    private Reader m_nextLine = null;
    private int m_state = 0;
    private Vector m_pushBack = null;
    private int m_lastEOL = 0;

    public abstract Reader processLine(String var1, int var2) throws IOException;

    public abstract Reader endofInput() throws IOException;

    private void gotoState(int n) {
        this.m_state = n;
    }

    private String getNextLine() throws IOException {
        String string;
        if (this.m_pushBack == null) {
            string = this.m_source.readLine();
            this.m_lastEOL = this.m_source.getLastEOL();
        } else {
            string = (String)this.m_pushBack.firstElement();
            this.m_pushBack.removeElementAt(0);
            Integer n = (Integer)this.m_pushBack.firstElement();
            this.m_pushBack.removeElementAt(0);
            if (this.m_pushBack.size() == 0) {
                this.m_pushBack = null;
            }
            this.m_lastEOL = n;
        }
        return string;
    }

    protected void pushBack(String string, int n) {
        if (this.m_pushBack == null) {
            this.m_pushBack = new Vector();
        }
        this.m_pushBack.addElement(string);
        this.m_pushBack.addElement(new Integer(n));
    }

    private int getLastEOL() {
        return this.m_lastEOL;
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        if (this.m_state == 2) {
            return -1;
        }
        if (this.m_state == 0) {
            String string = this.getNextLine();
            if (string == null) {
                this.m_nextLine = this.endofInput();
                if (this.m_nextLine == null) {
                    this.gotoState(2);
                    return -1;
                }
                this.gotoState(1);
            } else {
                this.m_nextLine = this.processLine(string, this.getLastEOL());
                this.gotoState(1);
            }
        }
        if (this.m_state == 1) {
            int n3 = -1;
            while (n3 == -1 && this.m_state != 2) {
                n3 = this.nextRead(cArray, n, n2);
            }
            return n3;
        }
        Assert.internalError("LineProcessor.read()");
        return 0;
    }

    private int nextRead(char[] cArray, int n, int n2) throws IOException {
        int n3 = this.m_nextLine.read(cArray, n, n2);
        if (n3 == -1) {
            String string = this.getNextLine();
            if (string == null) {
                this.m_nextLine = this.endofInput();
                if (this.m_nextLine == null) {
                    this.gotoState(2);
                }
            } else {
                this.m_nextLine = this.processLine(string, this.getLastEOL());
            }
        }
        return n3;
    }

    public void close() throws IOException {
        this.m_source.close();
    }

    public LineProcessor(LineReader lineReader) throws IOException {
        this.m_source = lineReader;
        this.m_state = 0;
        this.m_pushBack = null;
    }
}

