/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.util;

import com.starbase.starteam.ConfigFiles;
import com.starbase.starteam.SDKRuntimeException;
import com.starbase.util.GUID;
import com.starbase.util.Res;
import com.starbase.util.ResIDs;
import com.starbase.util.WorkStationException;
import com.starbase.util.WorkStationOptions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;

public class FileBasedOptions
implements WorkStationOptions {
    private Properties m_props = null;
    private boolean m_firstTime = true;

    private File getFile() throws WorkStationException {
        try {
            return ConfigFiles.getNonWindowsConfig();
        }
        catch (IOException iOException) {
            throw new WorkStationException(iOException.getMessage());
        }
    }

    private void createFile() {
        Properties properties = new Properties();
        GUID gUID = new GUID();
        gUID.create();
        ((Hashtable)properties).put("workstationid", gUID.byteString());
        ((Hashtable)properties).put("touch", "touch -t $time $file");
        ((Hashtable)properties).put("readonly", "chmod -w $file");
        ((Hashtable)properties).put("writable", "chmod +w $file");
        ((Hashtable)properties).put("executable", "chmod +x $file");
        ((Hashtable)properties).put("casesensitive", "true");
        this.saveProps(properties);
    }

    private void load() throws WorkStationException {
        FileBasedOptions fileBasedOptions = this;
        synchronized (fileBasedOptions) {
            if (this.m_props == null) {
                File file = this.getFile();
                if (!file.exists() && this.m_firstTime) {
                    this.m_firstTime = false;
                    this.createFile();
                }
                this.readFrom();
            }
        }
    }

    public String locationMsg() {
        File file = this.getFile();
        return Res.formatKey(ResIDs.USING_OPTION_FILE_FMT, new Object[]{file.getPath()});
    }

    private void saveProps(Properties properties) {
        File file = this.getFile();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            properties.save(fileOutputStream, "StarTeam SDK Options");
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            throw new SDKRuntimeException(Res.formatKey(ResIDs.CANNOT_WRITE_TO_OPTIONS_FILE_FMT, new Object[]{file.getPath()}), iOException);
        }
    }

    private void readFrom() throws WorkStationException {
        this.m_props = null;
        File file = this.getFile();
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            Properties properties = new Properties();
            properties.load(fileInputStream);
            fileInputStream.close();
            this.m_props = properties;
        }
        catch (IOException iOException) {
            throw new WorkStationException(Res.formatKey(ResIDs.CANNOT_READ_OPTIONS_FILE_FMT, new Object[]{file}));
        }
    }

    public String getOption(String string) throws WorkStationException {
        this.load();
        String string2 = this.m_props.getProperty(string);
        if (string2 == null) {
            throw new WorkStationException(Res.formatKey(ResIDs.OPTION_NOT_DEFINED_IN_FILE_FMT, new Object[]{string, this.getFile().getAbsolutePath()}));
        }
        return string2;
    }

    public void setOption(String string, String string2) throws WorkStationException {
        ((Hashtable)this.m_props).put(string, string2);
        this.saveProps(this.m_props);
    }
}

