/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.util;

import com.starbase.util.Res;
import com.starbase.util.ResIDs;
import java.util.Hashtable;

class ComUtils {
    private static Hashtable m_classToFp;
    private static Hashtable m_classNameToFp;
    private static boolean m_bFpTablesInitialized;
    private static final Object NOT_MAPPED;

    public static void initFp(int n) {
        if (!m_bFpTablesInitialized) {
            int n2 = n < 10 ? 20 : n * 2;
            m_classNameToFp = new Hashtable(n2, 0.75f);
            m_classToFp = new Hashtable(n2, 0.75f);
            m_bFpTablesInitialized = true;
        }
    }

    public static void declareFp(String string, int n) {
        m_classNameToFp.put(string, new Integer(n));
    }

    public static int getFp(Object object) {
        if (object == null) {
            return 0;
        }
        Class<?> clazz = object.getClass();
        return ComUtils.getFpFromClass(clazz, object);
    }

    private static int getFpFromClass(Class clazz, Object object) {
        if (clazz == null) {
            throw new RuntimeException(Res.formatKey(ResIDs.UNABLE_TO_FIND_WRAP_FMT, new Object[]{object.getClass().getName()}));
        }
        Object v = m_classToFp.get(clazz);
        if (v == null) {
            ComUtils.cache(clazz);
            return ComUtils.getFpFromClass(clazz, object);
        }
        if (v == NOT_MAPPED) {
            return ComUtils.getFpFromClass(clazz.getSuperclass(), object);
        }
        return (Integer)v;
    }

    private static void cache(Class clazz) {
        String string = clazz.getName();
        Object v = m_classNameToFp.get(string);
        if (v == null) {
            m_classToFp.put(clazz, NOT_MAPPED);
        } else {
            m_classToFp.put(clazz, v);
        }
    }

    public static Object newLocalRef(Object object) {
        return object;
    }

    ComUtils() {
    }

    static {
        m_bFpTablesInitialized = false;
        NOT_MAPPED = new Object();
    }
}

