/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.vts.pickle;

import com.starbase.starteam.vts.comm.Command;
import com.starbase.starteam.vts.pickle.EnumList;
import com.starbase.starteam.vts.pickle.ObjectInfoList;
import com.starbase.util.Assert;
import java.io.IOException;
import java.util.Hashtable;

public class PropertyInfo {
    private int m_ID = 0;
    private int m_eType = 0;
    private String m_displayName = null;
    private String m_internalName = null;
    private int m_nSize = 0;
    private EnumList m_pEnumList = null;
    private ObjectInfoList m_pObjInfoList = null;
    private int m_objectTableID;
    private Hashtable m_enumMap;
    private Hashtable m_userMap;

    public String getName() {
        return this.m_displayName;
    }

    public int getType() {
        return this.m_eType;
    }

    public int getID() {
        return this.m_ID;
    }

    public void setID(int n) {
        this.m_ID = n;
    }

    public void setType(int n) {
        this.m_eType = n;
    }

    public String getInternalName() {
        return this.m_internalName;
    }

    public void setInternalName(String string) {
        this.m_internalName = string;
    }

    public void setName(String string) {
        this.m_displayName = string;
    }

    public int getSize() {
        return this.m_nSize;
    }

    public void setSize(int n) {
        this.m_nSize = n;
    }

    public EnumList getEnumList() {
        return this.m_pEnumList;
    }

    public ObjectInfoList getObjectInfoList() {
        return this.m_pObjInfoList;
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString() + string);
        stringBuffer.append(" ID: " + this.m_ID + string);
        stringBuffer.append(" Name: " + this.m_displayName + string);
        stringBuffer.append(" InternalName: " + this.m_internalName + string);
        stringBuffer.append(" Type: " + this.m_eType + string);
        stringBuffer.append(" Size: " + this.m_nSize + string);
        if (this.m_pEnumList != null) {
            stringBuffer.append(" EnumList: " + this.m_pEnumList.toString() + string);
        }
        if (this.m_pObjInfoList != null) {
            stringBuffer.append(" ObjectInfoList: " + this.m_pObjInfoList.toString() + string);
        }
        return stringBuffer.toString();
    }

    public static PropertyInfo read(Command command) throws IOException {
        PropertyInfo propertyInfo = new PropertyInfo();
        propertyInfo.readGuts(command);
        return propertyInfo;
    }

    public static PropertyInfo[] readPropertyList(Command command) throws IOException {
        int n = command.readInt();
        PropertyInfo[] propertyInfoArray = new PropertyInfo[n];
        int n2 = 0;
        while (n2 < n) {
            PropertyInfo propertyInfo;
            propertyInfoArray[n2] = propertyInfo = PropertyInfo.read(command);
            ++n2;
        }
        return propertyInfoArray;
    }

    public void readGuts(Command command) throws IOException {
        this.m_ID = command.readInt();
        this.m_displayName = command.readString();
        this.m_internalName = command.readString();
        this.m_objectTableID = command.readInt();
        this.m_eType = command.readInt();
        this.m_nSize = command.readInt();
        this.m_pEnumList = null;
        this.m_pObjInfoList = null;
        boolean bl = command.readBoolean();
        if (bl) {
            switch (this.m_eType) {
                case 2: {
                    this.m_pEnumList = EnumList.read(command);
                    break;
                }
                case 3: {
                    if (!command.readBoolean()) break;
                }
                case 4: 
                case 10: {
                    this.m_pObjInfoList = ObjectInfoList.read(command);
                    break;
                }
                default: {
                    Assert.internalError("PropertyInfo.readGuts(), m_eType=" + this.m_eType);
                }
            }
        }
    }

    public void writeGuts(Command command) throws IOException {
        command.writeInt(this.m_ID);
        command.writeString(this.m_displayName);
        command.writeString(this.m_internalName);
        command.writeInt(this.m_eType);
        switch (this.m_eType) {
            case 2: {
                this.m_pEnumList.writeGuts(command);
                break;
            }
            case 3: 
            case 4: 
            case 10: {
                int n = this.m_pObjInfoList == null ? 0 : 1;
                command.writeInt(n);
                if (this.m_pObjInfoList == null) break;
                this.m_pObjInfoList.writeGuts(command);
                break;
            }
            default: {
                command.writeInt(this.m_nSize);
                break;
            }
        }
    }
}

