/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.vts.pickle;

import com.starbase.starteam.vts.comm.Command;
import com.starbase.starteam.vts.comm.SystemRevisionNumbers;
import java.io.IOException;

public class FileRevisionID {
    private static final String EMPTY = "";
    private int m_nRootID = -1;
    private int m_nObjectID = -1;
    private int m_nObjectVersion = -1;
    private int m_nContentVersion = -1;
    private String m_dotNotation = "";

    public int getRootObjectID() {
        return this.m_nRootID;
    }

    public int getObjectID() {
        return this.m_nObjectID;
    }

    public int getObjectVersion() {
        return this.m_nObjectVersion;
    }

    public int getContentVersion() {
        return this.m_nContentVersion;
    }

    public String getDotNotation() {
        return this.m_dotNotation;
    }

    public void setRevisionInfo(int n, int n2, int n3, int n4, String string) {
        this.m_nRootID = n;
        this.m_nObjectID = n2;
        this.m_nObjectVersion = n3;
        this.m_nContentVersion = n4;
        this.m_dotNotation = string;
    }

    public boolean isValid() {
        return this.m_nRootID != -1 && this.m_nObjectID != -1 && this.m_nObjectVersion != -1 && this.m_dotNotation != null && this.m_dotNotation.length() > 0 && this.m_nContentVersion != -1;
    }

    public static FileRevisionID read(Command command) throws IOException {
        FileRevisionID fileRevisionID = new FileRevisionID();
        fileRevisionID.readGuts(command);
        return fileRevisionID;
    }

    private void readGuts(Command command) throws IOException {
        boolean bl = SystemRevisionNumbers.isClientManagedStatus(command.getRevisionLevel());
        this.m_nRootID = command.readInt();
        this.m_nObjectID = command.readInt();
        this.m_nObjectVersion = command.readInt();
        if (bl) {
            this.m_dotNotation = command.readString();
        } else {
            command.readInt();
            this.m_dotNotation = null;
        }
        this.m_nContentVersion = command.readInt();
    }

    public void writeGuts(Command command) throws IOException {
        boolean bl = SystemRevisionNumbers.isClientManagedStatus(command.getRevisionLevel());
        command.writeInt(this.m_nRootID);
        command.writeInt(this.m_nObjectID);
        command.writeInt(this.m_nObjectVersion);
        if (bl) {
            command.writeString(this.m_dotNotation);
        } else {
            command.writeInt(0);
        }
        command.writeInt(this.m_nContentVersion);
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString() + string);
        stringBuffer.append(" RootID: " + this.m_nRootID + string);
        stringBuffer.append(" ObjectID: " + this.m_nObjectID + string);
        stringBuffer.append(" ObjectVersion: " + this.m_nObjectVersion + string);
        stringBuffer.append(" ContentVersion: " + this.m_nContentVersion + string);
        stringBuffer.append(" DotNotation: " + this.m_dotNotation + string);
        return stringBuffer.toString();
    }

    public FileRevisionID() {
    }

    public FileRevisionID(FileRevisionID fileRevisionID) {
        this.m_nRootID = fileRevisionID.getRootObjectID();
        this.m_nObjectID = fileRevisionID.getObjectID();
        this.m_nObjectVersion = fileRevisionID.getObjectVersion();
        this.m_nContentVersion = fileRevisionID.getContentVersion();
        this.m_dotNotation = fileRevisionID.m_dotNotation;
    }
}

