/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.vts.pickle;

import com.starbase.starteam.vts.comm.Command;
import com.starbase.util.Assert;
import java.io.IOException;

public class EnumList {
    private int[] m_IDs;
    private int[] m_flags;
    private int[] m_codes;
    private int[] m_textIDs;
    private String[] m_texts;
    private int m_languageCode;
    private int m_defaultIndex;

    public boolean equals(Object object) {
        if (object != null && object instanceof EnumList) {
            int n = this.m_codes.length;
            EnumList enumList = (EnumList)object;
            int n2 = enumList.getCodes().length;
            if (n != n2) {
                return false;
            }
            int n3 = 0;
            while (n3 < n) {
                if (this.m_codes[n3] != enumList.getCodes()[n3] || this.m_textIDs[n3] != enumList.getTextIDs()[n3]) {
                    return false;
                }
                ++n3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int n;
        int n2 = n = this.m_codes.length;
        int n3 = 0;
        while (n3 < n) {
            n2 = n2 * 37 + this.m_codes[n3];
            n2 = n2 * 37 + this.m_textIDs[n3];
            ++n3;
        }
        return n2;
    }

    public int getSize() {
        if (this.m_codes.length != this.m_textIDs.length) {
            Assert.internalError("EnumList.getSize()");
        }
        return this.m_codes.length;
    }

    public int getCodeAt(int n) {
        return this.m_codes[n];
    }

    public String getTextAt(int n) {
        return this.m_texts[n];
    }

    public int getTextIDAt(int n) {
        return this.m_textIDs[n];
    }

    public void setAt(int n, String string) {
        this.m_texts[n] = string;
    }

    public void setAt(int n, int n2) {
        this.m_textIDs[n] = n2;
    }

    public void setLangauge(int n) {
        this.m_languageCode = n;
    }

    public int getDefault() {
        return this.m_defaultIndex;
    }

    public int[] getCodes() {
        return this.m_codes;
    }

    public int[] getTextIDs() {
        return this.m_textIDs;
    }

    public String[] getTexts() {
        return this.m_texts;
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString() + string);
        int n = 0;
        while (n < this.m_codes.length) {
            stringBuffer.append("  " + this.m_codes[n] + ": " + this.m_texts[n] + string);
            ++n;
        }
        return stringBuffer.toString();
    }

    public static EnumList read(Command command) throws IOException {
        EnumList enumList = new EnumList();
        enumList.readGuts(command);
        return enumList;
    }

    public void readGuts(Command command) throws IOException {
        this.m_IDs = command.readIntArray();
        this.m_codes = command.readIntArray();
        this.m_textIDs = command.readIntArray();
        this.m_texts = command.readStringArray();
        this.m_flags = command.readIntArray();
        this.m_defaultIndex = command.readInt();
    }

    public void writeGuts(Command command) throws IOException {
        command.writeIntArray(this.m_codes);
        command.writeIntArray(this.m_textIDs);
        command.writeStringArray(this.m_texts);
        command.writeInt(0);
    }

    EnumList(int n, int[] nArray, int[] nArray2, String[] stringArray) {
        this.m_textIDs = nArray2;
        this.m_texts = stringArray;
        if (nArray != null) {
            this.m_codes = nArray;
        } else {
            int n2 = 0;
            while (n2 < n) {
                this.m_codes[n2] = n2;
                ++n2;
            }
        }
    }

    EnumList(EnumList enumList) {
        this.m_codes = enumList.getCodes();
        this.m_texts = enumList.getTexts();
        this.m_textIDs = enumList.getTextIDs();
    }

    EnumList() {
    }
}

