/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.vts.pickle;

import com.starbase.starteam.vts.comm.Command;
import com.starbase.starteam.vts.comm.SystemRevisionNumbers;
import com.starbase.starteam.vts.pickle.ItemConfig;
import com.starbase.util.Assert;
import com.starbase.util.MD5;
import java.io.IOException;

public class CheckoutRequest {
    public static final int NOCHECKOUT = 0;
    public static final int CONTENTS = 1;
    public static final int DELTAS = 2;
    public static final int GZIPCOMPRESSEDCONTENTS = 3;
    private int m_aItemID = -1;
    private ItemConfig m_aConfig = new ItemConfig();
    private int m_lockStatus = 3;
    private boolean m_bClientCaseSensitive = false;
    private String m_aClientFileName = null;
    private int m_dwClientDestID = -1;
    private boolean m_bVerifyStatus = false;
    private int m_nClientFileSize = 0;
    private boolean m_bVerifyWithMD5 = false;
    private MD5 m_aVerifyMD5 = new MD5();
    private double m_fVerifyDate = 0.0;
    private boolean m_bUpdateStatus = false;
    private double m_fUpdateFileDate = 0.0;
    private boolean m_bDeltasOk = false;
    private boolean m_bGetKeywords = false;

    public void checkoutByVersion(int n, int n2) {
        this.m_aConfig.setRevision(n, n2);
    }

    public void setFileInfo(String string, int n, boolean bl) {
        this.m_bClientCaseSensitive = bl;
        this.m_aClientFileName = string;
        this.m_dwClientDestID = n;
    }

    public void setGetKeywords(boolean bl) {
        this.m_bGetKeywords = bl;
    }

    public boolean getGetKeywords() {
        return this.m_bGetKeywords;
    }

    public boolean isUpdateStatus() {
        return this.m_bUpdateStatus;
    }

    public static CheckoutRequest read(Command command) throws IOException {
        CheckoutRequest checkoutRequest = new CheckoutRequest();
        checkoutRequest.readGuts(command);
        return checkoutRequest;
    }

    public void readGuts(Command command) throws IOException {
        Assert.internalError("CheckoutRequest.readGuts()");
    }

    public void writeGuts(Command command) throws IOException {
        boolean bl = SystemRevisionNumbers.isClientManagedStatus(command.getRevisionLevel());
        command.writeInt(this.m_aItemID);
        this.m_aConfig.writeGuts(command);
        command.writeInt(this.m_lockStatus);
        if (!bl) {
            command.writeBoolean(this.m_bClientCaseSensitive);
        }
        command.writeBoolean(this.m_bVerifyStatus);
        command.writeBoolean(this.m_bDeltasOk);
        if (!bl) {
            command.writeInt(this.m_dwClientDestID);
        }
        if (this.m_bVerifyStatus || this.m_bDeltasOk) {
            if (bl) {
                Assert.internalError("CheckoutRequest.writeGuts(), isClientStatus=true");
            } else {
                command.writeString(this.m_aClientFileName);
                command.writeInt(this.m_nClientFileSize);
                command.writeBoolean(this.m_bVerifyWithMD5);
                command.writeMD5(this.m_aVerifyMD5);
                command.writeTime(this.m_fVerifyDate);
            }
        }
        if (!bl) {
            command.writeBoolean(this.m_bUpdateStatus);
            if (this.m_bUpdateStatus) {
                command.writeTime(this.m_fUpdateFileDate);
            }
        }
        command.writeBoolean(this.m_bGetKeywords);
        if (command.getRevisionLevel() >= 51) {
            command.writeBoolean(true);
        }
        if (!bl) {
            command.writeBoolean(true);
        }
    }

    protected CheckoutRequest() {
    }

    public CheckoutRequest(int n, int n2) {
        this.m_aItemID = n;
        this.m_lockStatus = n2;
    }
}

