/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.vts.comm;

import com.starbase.starteam.vts.comm.Command;
import com.starbase.starteam.vts.comm.CommandFile;
import com.starbase.starteam.vts.comm.PacketHeader;
import com.starbase.starteam.vts.comm.Zipper;
import com.starbase.util.Assert;
import com.starbase.util.ByteOrder;
import java.io.IOException;
import java.io.OutputStream;

class SendCommandFile
extends CommandFile {
    private Command m_cmd = null;
    private int m_nBufPos = 0;
    private byte[] m_aBuf = new byte[65536];
    private Zipper m_zipper = new Zipper();
    private OutputStream m_outputStream = null;
    private PacketHeader m_header = new PacketHeader();
    private byte[] m_tmp = new byte[4];
    private int[] m_tmp2 = new int[1];
    private int[] m_tmpResult = new int[2];

    void setCompaction(int n) {
        super.setCompaction(n);
        this.m_zipper.reset();
    }

    protected void reset() {
        super.reset();
        this.m_nBufPos = 0;
    }

    OutputStream getOutputStream() {
        return this.m_outputStream;
    }

    private void prepareToSend(byte[] byArray, int n, int n2) {
        if (this.compressingData()) {
            if (!this.m_zipper.isInputNeeded()) {
                Assert.internalError("SendCommandFile.prepareToSend()");
            }
            if (n2 > 0) {
                this.m_zipper.setInput(byArray, n, n2);
            }
        }
    }

    private void prepareToFlush() {
        if (this.compressingData()) {
            this.m_zipper.finish();
        }
    }

    boolean moreToFlush() {
        if (this.compressingData()) {
            return !this.m_zipper.isFinished();
        }
        return false;
    }

    private void processSendData(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, int[] nArray) {
        int n5 = 0;
        int n6 = 0;
        if (this.compressingData()) {
            int n7 = this.m_zipper.getTotalBytesIn();
            n6 = this.m_zipper.zip(byArray2, n3, n4);
            n5 = this.m_zipper.getTotalBytesIn() - n7;
        } else {
            if (n2 > n4) {
                n2 = n4;
            }
            System.arraycopy(byArray, n, byArray2, n3, n2);
            n5 = n2;
            n6 = n2;
        }
        nArray[0] = n5;
        nArray[1] = n6;
    }

    private void flushData(byte[] byArray, int[] nArray, int n) {
        block0: {
            int n2 = 0;
            int n3 = 0;
            if (!this.compressingData()) break block0;
            int n4 = this.m_zipper.getTotalBytesIn();
            n2 = this.m_zipper.zip(byArray, nArray[0], n);
            n3 = this.m_zipper.getTotalBytesIn() - n4;
            nArray[0] = nArray[0] + n2;
        }
    }

    void write(byte[] byArray, int n, int n2) throws IOException {
        this.prepareToSend(byArray, n, n2);
        while (n2 > 0) {
            this.processSendData(byArray, n, n2, this.m_aBuf, this.m_nBufPos, this.getFreeByteCount(), this.m_tmpResult);
            int n3 = this.m_tmpResult[0];
            int n4 = this.m_tmpResult[1];
            n += n3;
            n2 -= n3;
            this.m_nBufPos += n4;
            if (this.getFreeByteCount() != 0) continue;
            this.sendPacket(0);
            if (this.m_nBufPos == 0) continue;
            Assert.internalError("SendCommandFile.write(), m_nBufPos=" + this.m_nBufPos);
        }
    }

    private void flushOutput() throws IOException {
        this.m_tmp2[0] = this.m_nBufPos;
        this.prepareToFlush();
        while (this.moreToFlush()) {
            this.flushData(this.m_aBuf, this.m_tmp2, this.getFreeByteCount());
            this.m_nBufPos = this.m_tmp2[0];
            if (this.getFreeByteCount() != 0) continue;
            this.sendPacket(0);
            if (this.m_nBufPos != 0) {
                Assert.internalError("SendCommandFile.flushOutput(), m_nBufPos=" + this.m_nBufPos);
            }
            this.m_tmp2[0] = 0;
        }
        this.sendPacket(PacketHeader.PKTFLAG_ENDOFDATA);
        this.m_outputStream.flush();
    }

    void close() throws IOException {
        if (this.m_bClosed) {
            return;
        }
        if (this.m_outputStream == null) {
            Assert.internalError("SendCommandFile.close(), m_outputStream == null");
        }
        this.flushOutput();
        this.m_bClosed = true;
    }

    protected final void sendPacket(int n) throws IOException {
        this.m_header.m_signature = PacketHeader.ST_PACKET_SIGNATURE;
        this.m_header.m_packetSize = this.m_nBufPos;
        this.m_header.m_dataSize = this.m_nBufPos;
        this.m_header.m_flags = n;
        if (this.m_bException) {
            this.m_header.setException();
        }
        if (this.isCompressionOn() && !this.m_bException) {
            this.m_header.setCompacted();
        }
        if (!this.m_bException) {
            this.encryptPacket(this.m_aBuf, this.m_header);
        }
        this.writePacketHeader(this.m_header);
        this.m_outputStream.write(this.m_aBuf, 0, this.m_header.m_packetSize);
        this.m_cmd.wrote(this.m_header.m_packetSize);
        this.m_nBufPos = 0;
    }

    final void writeInt(int n) throws IOException {
        ByteOrder.writeInt(this.m_tmp, n);
        this.m_outputStream.write(this.m_tmp, 0, 4);
    }

    private final void writePacketHeader(PacketHeader packetHeader) throws IOException {
        this.writeInt(packetHeader.m_signature);
        this.writeInt(packetHeader.m_packetSize);
        this.writeInt(packetHeader.m_dataSize);
        this.writeInt(packetHeader.m_flags);
    }

    protected final void dumpPacket() {
        this.m_nBufPos = 0;
    }

    protected final void encryptPacket(byte[] byArray, PacketHeader packetHeader) {
        int n;
        if (packetHeader.m_packetSize == 0) {
            return;
        }
        if (this.m_aCipher == null) {
            return;
        }
        packetHeader.m_packetSize = n = this.m_aCipher.encrypt(byArray, packetHeader.m_packetSize, 65536);
        packetHeader.setEncrypted();
    }

    protected final int getFreeByteCount() {
        if (this.m_nCipherBlockLen + this.m_nBufPos > 65536) {
            Assert.internalError("SendCommandFile.getFreeByteCount(), m_nCipherBlockLen=" + this.m_nCipherBlockLen + ", m_nBufPos=" + this.m_nBufPos);
        }
        return 65536 - this.m_nCipherBlockLen - this.m_nBufPos;
    }

    SendCommandFile(Command command, OutputStream outputStream) {
        this.m_cmd = command;
        this.m_outputStream = outputStream;
    }
}

