/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.vts.comm;

import System.Exception;
import com.starbase.starteam.vts.comm.Command;
import com.starbase.starteam.vts.comm.NetMonitorConsole;
import com.starbase.starteam.vts.comm.NetMonitorFile;
import com.starbase.starteam.vts.comm.NetMonitorGUI;
import com.starbase.starteam.vts.comm.NetMonitorImpl;
import com.starbase.starteam.vts.comm.ServerCommandEvent;
import com.starbase.starteam.vts.comm.ServerCommandListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Vector;

public class NetMonitor {
    private static int m_nextID = 0;
    private static boolean m_On = false;
    private static NetMonitorImpl m_delegate = null;
    private static int m_nTotalRunning = 0;
    private static Vector m_listeners = new Vector();
    private boolean m_bRunning = false;
    private long m_Start = 0L;
    private long m_End = 0L;
    private int m_Sent = 0;
    private int m_Got = 0;
    private int m_ID = NetMonitor.getNextSessionID();
    private int m_nCommand = 0;
    private int m_commandID = 0;
    private String m_commandName = null;

    public static synchronized void on() {
        NetMonitor.kill();
        m_On = true;
        m_delegate = new NetMonitorGUI();
    }

    public static synchronized void onConsole() {
        NetMonitor.kill();
        m_On = true;
        m_delegate = new NetMonitorConsole();
    }

    public static synchronized void onFile(File file) {
        NetMonitor.kill();
        m_On = true;
        m_delegate = new NetMonitorFile(file);
    }

    public static synchronized void kill() {
        if (m_delegate != null) {
            m_delegate.destroy();
        }
        m_On = m_listeners.size() > 0;
    }

    public static void println(String string) {
        if (m_On) {
            NetMonitorImpl netMonitorImpl;
            String string2 = ">> ";
            String string3 = System.getProperty("line.separator");
            if (!(string = string + string2).endsWith(string3)) {
                string = string + string3;
            }
            if ((netMonitorImpl = m_delegate) != null) {
                NetMonitorImpl netMonitorImpl2 = netMonitorImpl;
                synchronized (netMonitorImpl2) {
                    netMonitorImpl.display(string);
                }
            }
        }
    }

    public static synchronized int getRunningCommandCount() {
        return m_nTotalRunning;
    }

    public static synchronized void addServerCommandListener(ServerCommandListener serverCommandListener) {
        Vector vector = m_listeners;
        synchronized (vector) {
            m_listeners.addElement(serverCommandListener);
            m_On = true;
        }
    }

    public static synchronized void removeServerCommandListener(ServerCommandListener serverCommandListener) {
        Vector vector = m_listeners;
        synchronized (vector) {
            m_listeners.removeElement(serverCommandListener);
            m_On = m_delegate != null || m_listeners.size() > 0;
        }
    }

    private static synchronized int getNextSessionID() {
        return ++m_nextID;
    }

    private static synchronized void tally(boolean bl) {
        if (bl) {
            ++m_nTotalRunning;
        } else if (m_nTotalRunning > 0) {
            --m_nTotalRunning;
        }
    }

    void start(int n, String string, short s) {
        if (m_On) {
            NetMonitor netMonitor = this;
            synchronized (netMonitor) {
                this.m_Start = System.currentTimeMillis();
                ++this.m_nCommand;
                this.m_commandID = n;
                this.m_commandName = string;
                this.m_Sent = 0;
                this.m_Got = 0;
                this.m_End = this.m_Start;
                if (!this.m_bRunning) {
                    NetMonitor.tally(true);
                    this.m_bRunning = true;
                }
                String string2 = "Start: (rev {0}) {1} ";
                String string3 = MessageFormat.format(string2, Short.toString(s), string);
                NetMonitorImpl netMonitorImpl = m_delegate;
                if (netMonitorImpl != null) {
                    NetMonitorImpl netMonitorImpl2 = netMonitorImpl;
                    synchronized (netMonitorImpl2) {
                        netMonitorImpl.showVM();
                        netMonitorImpl.display(string3);
                    }
                }
                this.onStart();
            }
        }
    }

    void wrote(int n) {
        if (m_On) {
            NetMonitor netMonitor = this;
            synchronized (netMonitor) {
                this.m_Sent += n;
            }
        }
    }

    void read(int n) {
        if (m_On) {
            NetMonitor netMonitor = this;
            synchronized (netMonitor) {
                this.m_Got += n;
            }
        }
    }

    void error(Throwable throwable) {
        if (m_On) {
            NetMonitor netMonitor = this;
            synchronized (netMonitor) {
                if (this.m_bRunning) {
                    this.m_End = System.currentTimeMillis();
                    NetMonitor.tally(false);
                    this.m_bRunning = false;
                    this.onError(throwable);
                }
            }
        }
    }

    void end() {
        if (m_On) {
            NetMonitor netMonitor = this;
            synchronized (netMonitor) {
                if (this.m_bRunning) {
                    this.m_End = System.currentTimeMillis();
                    NetMonitor.tally(false);
                    this.m_bRunning = false;
                    String string = System.getProperty("line.separator");
                    String string2 = "Time: {0} millis; Sent: {1} bytes; Got: {2} bytes";
                    String string3 = MessageFormat.format(string2, Long.toString(this.m_End - this.m_Start), Integer.toString(this.m_Sent), Integer.toString(this.m_Got));
                    NetMonitorImpl netMonitorImpl = m_delegate;
                    if (netMonitorImpl != null) {
                        NetMonitorImpl netMonitorImpl2 = netMonitorImpl;
                        synchronized (netMonitorImpl2) {
                            netMonitorImpl.showVM();
                            netMonitorImpl.display(string3 + string);
                        }
                    }
                    this.onEnd();
                }
            }
        }
    }

    static String getVMEM() {
        long l = Runtime.getRuntime().totalMemory();
        long l2 = Runtime.getRuntime().freeMemory();
        String string = "Memory: Total: {0}; Free: {1}";
        return MessageFormat.format(string, Long.toString(l), Long.toString(l2));
    }

    private void onStart() {
        if (m_listeners.size() > 0) {
            Vector vector = m_listeners;
            synchronized (vector) {
                ServerCommandEvent serverCommandEvent = new ServerCommandEvent(this, false, null);
                Enumeration enumeration = m_listeners.elements();
                while (enumeration.hasMoreElements()) {
                    ServerCommandListener serverCommandListener = (ServerCommandListener)enumeration.nextElement();
                    try {
                        try {
                            serverCommandListener.start(serverCommandEvent);
                        }
                        catch (Throwable throwable) {}
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private void onEnd() {
        if (m_listeners.size() > 0) {
            Vector vector = m_listeners;
            synchronized (vector) {
                ServerCommandEvent serverCommandEvent = new ServerCommandEvent(this, true, null);
                Enumeration enumeration = m_listeners.elements();
                while (enumeration.hasMoreElements()) {
                    ServerCommandListener serverCommandListener = (ServerCommandListener)enumeration.nextElement();
                    try {
                        try {
                            serverCommandListener.end(serverCommandEvent);
                        }
                        catch (Throwable throwable) {}
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private void onError(Throwable throwable) {
        if (m_listeners.size() > 0) {
            Vector vector = m_listeners;
            synchronized (vector) {
                ServerCommandEvent serverCommandEvent = new ServerCommandEvent(this, true, throwable);
                Enumeration enumeration = m_listeners.elements();
                while (enumeration.hasMoreElements()) {
                    ServerCommandListener serverCommandListener = (ServerCommandListener)enumeration.nextElement();
                    try {
                        try {
                            serverCommandListener.error(serverCommandEvent);
                        }
                        catch (Throwable throwable2) {}
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    int getSessionID() {
        return this.m_ID;
    }

    int getCommandNumber() {
        return this.m_nCommand;
    }

    int getCommandID() {
        return this.m_commandID;
    }

    String getCommandName() {
        return this.m_commandName;
    }

    int getBytesSent() {
        return this.m_Sent;
    }

    int getBytesReceived() {
        return this.m_Got;
    }

    long getCommandTime() {
        return this.m_End - this.m_Start;
    }

    NetMonitor(Command command) {
    }
}

