/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.vts.comm;

import com.starbase.starteam.vts.comm.EncryptContext;
import com.starbase.starteam.vts.comm.EncryptionAlgorithm;
import com.starbase.starteam.vts.comm.Res;
import com.starbase.starteam.vts.comm.ResIDs;
import com.starbase.util.Assert;

final class CAPIEncryptContext
implements EncryptContext {
    private static final String LIBRARY = "StSDKCAPIEncryptContext_02";
    private static boolean m_bLoaded = false;
    private long m_NativeObjectPointer = 0L;

    private static void init() {
        if (!m_bLoaded) {
            System.loadLibrary(LIBRARY);
            m_bLoaded = true;
        }
    }

    protected void finalize() throws Throwable {
        this.nativeDestructNativeObject();
    }

    private native void nativeDestructNativeObject();

    private native void nativeBeginKeyExchange(int var1);

    private native int nativeGetBlockLength();

    private native int nativeEncrypt(byte[] var1, int var2, int var3);

    private native int nativeDecrypt(byte[] var1, int var2);

    private native byte[] nativeExportPublicKeyToCAPI();

    private native void nativeGenerateSessionKey();

    private native void nativeImportCAPIPublicKey(byte[] var1);

    private native byte[] nativeExportSessionKeyToCAPI();

    private native void nativeImportCAPISessionKey(byte[] var1);

    private native void nativeEndKeyExchange();

    private native void nativeDispose();

    private native boolean nativeValidServerHash(byte[] var1);

    private native byte[] nativeGetClientHash();

    public int getBlockLength() {
        return this.nativeGetBlockLength();
    }

    public int encrypt(byte[] byArray, int n, int n2) {
        return this.nativeEncrypt(byArray, n, n2);
    }

    public int decrypt(byte[] byArray, int n) {
        return this.nativeDecrypt(byArray, n);
    }

    public void beginKeyExchange(EncryptionAlgorithm encryptionAlgorithm, int n) {
        if (n != 40) {
            throw new IllegalArgumentException(Res.getString(ResIDs.ONLY_40_BIT_KEYS_SUPPORTED));
        }
        int n2 = 0;
        if (encryptionAlgorithm == EncryptionAlgorithm.RC4) {
            n2 = 1;
        } else if (encryptionAlgorithm == EncryptionAlgorithm.RC2_ECB) {
            n2 = 2;
        } else if (encryptionAlgorithm == EncryptionAlgorithm.RC2_CBC) {
            n2 = 3;
        } else if (encryptionAlgorithm == EncryptionAlgorithm.RC2_CFB) {
            n2 = 4;
        } else {
            Assert.internalError("CAPIEncryptContext.beginKeyExchange(), algorithmID=" + n2);
        }
        this.nativeBeginKeyExchange(n2);
    }

    public byte[] exportPublicKeyToCAPI() {
        return this.nativeExportPublicKeyToCAPI();
    }

    public void generateSessionKey() {
        this.nativeGenerateSessionKey();
    }

    public void importCAPIPublicKey(byte[] byArray) {
        this.nativeImportCAPIPublicKey(byArray);
    }

    public byte[] exportSessionKeyToCAPI() {
        return this.nativeExportSessionKeyToCAPI();
    }

    public void importCAPISessionKey(byte[] byArray) {
        this.nativeImportCAPISessionKey(byArray);
    }

    public boolean validServerHash(byte[] byArray) {
        return this.nativeValidServerHash(byArray);
    }

    public byte[] getClientHash() {
        return this.nativeGetClientHash();
    }

    public void endKeyExchange() {
        this.nativeEndKeyExchange();
    }

    public void dispose() {
        this.nativeDispose();
    }

    public CAPIEncryptContext() {
        CAPIEncryptContext.init();
    }
}

