/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.vts.comm;

import com.starbase.starteam.Server;
import com.starbase.starteam.ServerException;
import com.starbase.starteam.vts.comm.BinaryChunkInputStream;
import com.starbase.starteam.vts.comm.Cipher;
import com.starbase.starteam.vts.comm.Command;
import com.starbase.starteam.vts.comm.CommandExceptionDetected;
import com.starbase.starteam.vts.comm.ReceiveCommandFile;
import com.starbase.starteam.vts.comm.SendCommandFile;
import com.starbase.starteam.vts.pickle.Variant;
import com.starbase.util.Assert;
import com.starbase.util.ByteOrder;
import com.starbase.util.GUID;
import com.starbase.util.MD5;
import com.starbase.util.OLEDate;
import com.starbase.util.UTF8;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;

public class BinaryCommand
extends Command {
    private static final String m_emptyString = "";
    private static final int[] m_emptyIntArray = new int[0];
    private static final byte[] m_emptyByteArray = new byte[0];

    void resetForNewCommand(int n, int n2, int n3, int n4, int n5, Cipher cipher, Cipher cipher2, int n6, GUID gUID, int n7, int n8, double d, int n9) throws IOException {
        this.m_bPopping = false;
        this.m_bPushing = false;
        this.m_ClientID = gUID;
        this.m_nConnectID = n7;
        this.m_nComponentID = n8;
        this.m_nCommandID = n6;
        this.m_nCommandUserID = n9;
        this.m_commandTime = d;
        this.m_nSessionTag = n;
        this.m_nClientTimestamp = n2 != 0 ? n2 : this.generateClientTimestamp();
        this.m_nFlags = n3;
        if (this.m_checkingParameters) {
            this.m_nFlags |= 0x10;
        }
        this.m_nKeyID = n4;
        this.m_aSendFile.reset();
        this.m_aReceiveFile.reset();
        if ((n3 & 1) != 0) {
            this.enableCompaction(n5);
        }
        if ((n3 & 2) != 0) {
            this.enableEncryption(n4, cipher, cipher2);
        }
    }

    void enableCompaction(int n) {
        if (n != 0) {
            this.m_nFlags |= 1;
            this.m_aSendFile.setCompaction(n);
            this.m_aReceiveFile.setCompaction(n);
        }
    }

    void enableEncryption(int n, Cipher cipher, Cipher cipher2) {
        this.m_nFlags |= 2;
        this.m_aSendFile.setCipher(cipher);
        this.m_aReceiveFile.setCipher(cipher2);
    }

    public InputStream getChunkStream() throws IOException {
        return new BufferedInputStream(new BinaryChunkInputStream(this), 8192);
    }

    public final void writeTime(double d) throws IOException {
        this.writeDouble(d);
    }

    public final void writeTime(Date date) throws IOException {
        this.writeDouble(OLEDate.doubleFromLong(date.getTime()));
    }

    public final double readTime() throws IOException {
        return this.readDouble();
    }

    public final void writeShort(short s) throws IOException {
        ByteOrder.writeShort(this.m_aBuf, s);
        this.push(this.m_aBuf, 0, 2, 0x11000000);
    }

    public final short readShort() throws IOException {
        this.pop(this.m_aBuf, 2, 0x11000000);
        return ByteOrder.readShort(this.m_aBuf);
    }

    public final void writeUShort(short s) throws IOException {
        ByteOrder.writeShort(this.m_aBuf, s);
        this.push(this.m_aBuf, 0, 2, 0x12000000);
    }

    public final short readUShort() throws IOException {
        this.pop(this.m_aBuf, 2, 0x12000000);
        return ByteOrder.readShort(this.m_aBuf);
    }

    public final void writeInt(int n) throws IOException {
        ByteOrder.writeInt(this.m_aBuf, n);
        this.push(this.m_aBuf, 0, 4, 0x21000000);
    }

    public final int readInt() throws IOException {
        this.pop(this.m_aBuf, 4, 0x21000000);
        return ByteOrder.readInt(this.m_aBuf);
    }

    public final void writeUInt(int n) throws IOException {
        ByteOrder.writeInt(this.m_aBuf, n);
        this.push(this.m_aBuf, 0, 4, 0x22000000);
    }

    public final int readUInt() throws IOException {
        this.pop(this.m_aBuf, 4, 0x22000000);
        return ByteOrder.readInt(this.m_aBuf);
    }

    public final void writeLong(long l) throws IOException {
        ByteOrder.writeLong(this.m_aBuf, l);
        this.push(this.m_aBuf, 0, 8, 0x61000000);
    }

    public final long readLong() throws IOException {
        this.pop(this.m_aBuf, 8, 0x61000000);
        return ByteOrder.readLong(this.m_aBuf);
    }

    public final void writeDouble(double d) throws IOException {
        ByteOrder.writeDouble(this.m_aBuf, d);
        this.push(this.m_aBuf, 0, 8, 0x40000000);
    }

    public final double readDouble() throws IOException {
        this.pop(this.m_aBuf, 8, 0x40000000);
        return ByteOrder.readDouble(this.m_aBuf);
    }

    public final void writeString(String string) throws IOException {
        if (this.getRevisionLevel() >= 67) {
            byte[] byArray = UTF8.StringToUtf8(string);
            int n = byArray.length;
            ByteOrder.writeInt(this.m_aBuf, n);
            this.push(this.m_aBuf, 0, 4, 0x21000000);
            if (n > 0) {
                this.push(byArray, 0, n, 0x50000000);
            }
        } else {
            int n = string.length();
            ByteOrder.writeInt(this.m_aBuf, n);
            this.push(this.m_aBuf, 0, 4, 0x21000000);
            byte[] byArray = new byte[n];
            int n2 = 0;
            while (n2 < n) {
                byArray[n2] = (byte)(string.charAt(n2) & 0xFF);
                ++n2;
            }
            if (n > 0) {
                this.push(byArray, 0, n, 0x50000000);
            }
        }
    }

    public final String readString() throws IOException {
        this.pop(this.m_aBuf, 4, 0x21000000);
        int n = ByteOrder.readInt(this.m_aBuf);
        byte[] byArray = null;
        if (n <= 0) {
            return m_emptyString;
        }
        byArray = new byte[n];
        this.pop(byArray, n, 0x50000000);
        if (this.getRevisionLevel() >= 67) {
            return UTF8.Utf8ToString(byArray);
        }
        char[] cArray = new char[n];
        int n2 = 0;
        while (n2 < n) {
            cArray[n2] = (char)(byArray[n2] & 0xFF);
            ++n2;
        }
        return new String(cArray);
    }

    public final void writePassword(String string) throws IOException {
        this.writeString(string);
    }

    public final void writePassword(byte[] byArray) throws IOException {
        this.writeBlob(byArray);
    }

    public final String readLoginInfo() throws IOException {
        return String.valueOf(this.readInt());
    }

    public final byte[] readRawLoginInfo() throws IOException {
        return this.readRaw(4);
    }

    public final void writeStringArray(String[] stringArray) throws IOException {
        int n = stringArray.length;
        ByteOrder.writeInt(this.m_aBuf, n);
        this.push(this.m_aBuf, 0, 4, 0x21000000);
        int n2 = 0;
        while (n2 < n) {
            this.writeString(stringArray[n2]);
            ++n2;
        }
    }

    public final String[] readStringArray() throws IOException {
        this.pop(this.m_aBuf, 4, 0x21000000);
        int n = ByteOrder.readInt(this.m_aBuf);
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = this.readString();
            ++n2;
        }
        return stringArray;
    }

    public final void writeIntArray(int[] nArray) throws IOException {
        int n = nArray.length;
        this.writeInt(n);
        int n2 = 0;
        while (n2 < n) {
            this.writeInt(nArray[n2]);
            ++n2;
        }
    }

    public final int[] readIntArray() throws IOException {
        int n = this.readInt();
        if (n == 0) {
            return m_emptyIntArray;
        }
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = this.readInt();
            ++n2;
        }
        return nArray;
    }

    public final void writeVariantBytes(byte[] byArray) throws IOException {
        if (byArray.length == 0 && this.getRevisionLevel() < 67) {
            this.writeInt(1);
            byte[] byArray2 = new byte[]{-1};
            this.push(byArray2, 0, byArray2.length, 0x50000000);
        } else {
            this.writeInt(byArray.length);
            if (byArray.length > 0) {
                this.push(byArray, 0, byArray.length, 0x50000000);
            }
        }
    }

    public final byte[] readVariantBytes() throws IOException {
        byte[] byArray;
        int n = this.readInt();
        byte[] byArray2 = byArray = n == 0 ? m_emptyByteArray : new byte[n];
        if (n > 0 || this.getRevisionLevel() < 67) {
            this.pop(byArray, n, 0x50000000);
        }
        return byArray;
    }

    public final void writeVariantIDs(int[] nArray) throws IOException {
        if (this.getRevisionLevel() >= 68) {
            this.writeIntArray(nArray);
        } else {
            byte[] byArray = ByteOrder.intArrayToByteArray(nArray);
            this.writeVariantBytes(byArray);
        }
    }

    public final int[] readVariantIDs() throws IOException {
        if (this.getRevisionLevel() >= 68) {
            return this.readIntArray();
        }
        byte[] byArray = this.readVariantBytes();
        return ByteOrder.byteArrayToIntArray(byArray);
    }

    public final void writeBlob(byte[] byArray) throws IOException {
        if (this.getRevisionLevel() >= 67) {
            int n = byArray.length;
            this.writeInt(n);
            this.push(byArray, 0, n, 0x50000000);
        } else {
            int n;
            int n2 = 1024;
            int n3 = n = byArray.length;
            int n4 = 0;
            while (n3 > 0) {
                int n5 = n3 < n2 ? n3 : n2;
                this.writeInt(n5);
                this.push(byArray, n4, n5, 0x50000000);
                n4 += n5;
                n3 -= n5;
            }
            if (n3 != 0) {
                Assert.internalError("BinaryCommand.writeBlob(), nLeft=" + n3);
            }
            this.writeInt(-1);
        }
    }

    public final byte[] readBlob() throws IOException {
        if (this.getRevisionLevel() >= 67) {
            int n = this.readInt();
            byte[] byArray = new byte[n];
            this.pop(byArray, n, 0x50000000);
            return byArray;
        }
        int n = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        while (n != -1) {
            n = this.readInt();
            if (n == -1) continue;
            byte[] byArray = new byte[n];
            this.pop(byArray, n, 0x50000000);
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public final int writeFileStream(InputStream inputStream) throws IOException {
        return this.writeStream(inputStream, true);
    }

    public final int writeStream(InputStream inputStream) throws IOException {
        return this.writeStream(inputStream, false);
    }

    private int writeStream(InputStream inputStream, boolean bl) throws IOException {
        if (bl && this.supportsSingleBlockFileStreaming()) {
            this.writeLong(-1L);
        }
        int n = 0;
        int n2 = 32768;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, n2);
        byte[] byArray = new byte[n2];
        int n3 = 0;
        while (n3 != -1) {
            n3 = bufferedInputStream.read(byArray, 0, n2);
            if (n3 == -1) continue;
            n += n3;
            this.writeInt(n3);
            this.push(byArray, 0, n3, 0x50000000);
        }
        this.writeInt(-1);
        return n;
    }

    public final long readStream(OutputStream outputStream) throws IOException {
        int n = 0;
        int n2 = 0;
        int n3 = 65536;
        byte[] byArray = new byte[n3];
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        n = this.readInt();
        while (n != -1) {
            int n4 = n;
            while (n4 != 0) {
                int n5 = n3 > n4 ? n4 : n3;
                this.pop(byArray, n5, 0x50000000);
                bufferedOutputStream.write(byArray, 0, n5);
                n4 -= n5;
            }
            n2 += n;
            n = this.readInt();
        }
        bufferedOutputStream.flush();
        return n2;
    }

    public void writeMD5(MD5 mD5) throws IOException {
        byte[] byArray = mD5.getData();
        this.writeInt(byArray.length);
        this.push(byArray, 0, byArray.length, 0x50000000);
    }

    public MD5 readMD5() throws IOException {
        MD5 mD5 = new MD5();
        int n = this.readInt();
        byte[] byArray = new byte[n];
        this.pop(byArray, n, 0x50000000);
        mD5.setData(byArray);
        return mD5;
    }

    public void writeGUID(GUID gUID) throws IOException {
        byte[] byArray = gUID.getData();
        int n = byArray[0] & 0xFF;
        int n2 = byArray[1] & 0xFF;
        int n3 = byArray[2] & 0xFF;
        int n4 = byArray[3] & 0xFF;
        this.writeUInt(n + (n2 << 8) + (n3 << 16) + (n4 << 24));
        short s = (short)(byArray[4] & 0xFF);
        short s2 = (short)(byArray[5] & 0xFF);
        this.writeUShort((short)(s + (s2 << 8)));
        short s3 = (short)(byArray[6] & 0xFF);
        short s4 = (short)(byArray[7] & 0xFF);
        this.writeUShort((short)(s3 + (s4 << 8)));
        byte[] byArray2 = new byte[8];
        int n5 = 8;
        while (n5 < 16) {
            byArray2[n5 - 8] = byArray[n5];
            ++n5;
        }
        this.writeRaw(byArray2);
    }

    public GUID readGUID() throws IOException {
        byte[] byArray = new byte[16];
        int n = this.readUInt();
        byArray[0] = (byte)(n & 0xFF);
        byArray[1] = (byte)(n >>> 8 & 0xFF);
        byArray[2] = (byte)(n >>> 16 & 0xFF);
        byArray[3] = (byte)(n >>> 24 & 0xFF);
        n = this.readUShort();
        byArray[4] = (byte)(n & 0xFF);
        byArray[5] = (byte)(n >>> 8 & 0xFF);
        n = this.readUShort();
        byArray[6] = (byte)(n & 0xFF);
        byArray[7] = (byte)(n >>> 8 & 0xFF);
        byte[] byArray2 = this.readRaw(8);
        int n2 = 8;
        while (n2 < 16) {
            byArray[n2] = byArray2[n2 - 8];
            ++n2;
        }
        return new GUID(byArray);
    }

    public final void writeByte(byte by) throws IOException {
        this.m_aBuf[0] = by;
        this.push(this.m_aBuf, 0, 1, 0x50000000);
    }

    public final byte readByte() throws IOException {
        this.pop(this.m_aBuf, 1, 0x50000000);
        return this.m_aBuf[0];
    }

    public final void writeRaw(byte[] byArray) throws IOException {
        this.push(byArray, 0, byArray.length, 0x50000000);
    }

    public final byte[] readRaw(int n) throws IOException {
        byte[] byArray = new byte[n];
        this.pop(byArray, n, 0x50000000);
        return byArray;
    }

    public final byte[] readRaw() throws IOException {
        int n = this.readInt();
        byte[] byArray = new byte[n];
        this.pop(byArray, n, 0x50000000);
        return byArray;
    }

    public final void writeBoolean(boolean bl) throws IOException {
        this.writeInt(bl ? 1 : 0);
    }

    public final boolean readBoolean() throws IOException {
        return this.readInt() != 0;
    }

    public final Locale readLocale() throws IOException {
        String string = this.readString();
        String string2 = this.readString();
        String string3 = this.readString();
        return new Locale(string, string2, string3);
    }

    public final void writeLocale(Locale locale) throws IOException {
        this.writeString(locale.getLanguage());
        this.writeString(locale.getCountry());
        this.writeString(locale.getVariant());
    }

    public final GUID[] readGUIDArray() throws IOException {
        int n = this.readInt();
        GUID[] gUIDArray = new GUID[n];
        int n2 = 0;
        while (n2 < n) {
            GUID gUID;
            gUIDArray[n2] = gUID = this.readGUID();
            ++n2;
        }
        return gUIDArray;
    }

    public int readBuffer(byte[] byArray, int n) throws IOException {
        return -1;
    }

    void terminatePush() throws IOException {
        this.getSendFile().close();
        this.m_bPushing = false;
    }

    void terminatePop() throws IOException {
        try {
            this.getReceiveFile().close();
            this.m_bPopping = false;
            this.endCommand();
        }
        catch (CommandExceptionDetected commandExceptionDetected) {
            this.popException();
        }
    }

    void popException() throws IOException {
        String string = this.readString();
        String string2 = this.readString();
        int n = this.readInt();
        boolean bl = this.readBoolean();
        int n2 = this.readInt();
        double d = this.readTime();
        String string3 = this.readString();
        int n3 = this.readInt();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        int n4 = 0;
        while (n4 < n3) {
            String string4 = this.readString();
            Variant variant = Variant.read(this);
            hashtable.put(string4, variant.getData());
            ++n4;
        }
        throw ServerException.forError(this.getServer(), string, string2, n, string3, bl, d, n2, hashtable);
    }

    BinaryCommand(Server server, Socket socket) throws IOException {
        this.m_server = server;
        this.m_aSendFile = new SendCommandFile(this, new BufferedOutputStream(socket.getOutputStream()));
        this.m_aReceiveFile = new ReceiveCommandFile(this, new BufferedInputStream(socket.getInputStream(), 8192));
    }
}

