/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.commandline;

import com.starbase.starteam.File;
import com.starbase.starteam.Folder;
import com.starbase.starteam.Status;
import com.starbase.starteam.commandline.AutoEOLOption;
import com.starbase.starteam.commandline.CommonCommand;
import com.starbase.starteam.commandline.CommonSpec;
import com.starbase.starteam.commandline.Option;
import com.starbase.starteam.commandline.Res;
import com.starbase.starteam.commandline.ResIDs;
import com.starbase.util.Assert;
import java.io.IOException;

class UpdateStatus
extends CommonCommand {
    String description() {
        return Res.getString(ResIDs.UPDATE_STATUS_DESCRIPTION);
    }

    String name() {
        return "update-status";
    }

    boolean treatNoFilesAsAll() {
        return true;
    }

    boolean iterateOnLocalFiles() {
        return false;
    }

    boolean iterateOnServerFiles() {
        return true;
    }

    boolean ignoreUserFileList() {
        return false;
    }

    int run(String[] stringArray) throws IOException {
        CommonSpec commonSpec = new CommonSpec(true, false);
        commonSpec.addOption(new AutoEOLOption("AutoEOL"));
        commonSpec.addOption(new Option("SendContents", false));
        commonSpec.addOption(new Option("Verbose", false));
        this.setSpec(commonSpec);
        return this.runCommand(stringArray);
    }

    private boolean getAutoEOL() {
        if (this.getIsOptionOn("AutoEOL")) {
            return this.getBooleanOption("AutoEOL");
        }
        return false;
    }

    private boolean getUseMD5() {
        return !this.getIsOptionOn("SendContents");
    }

    private boolean isVerbose() {
        return this.getIsOptionOn("Verbose");
    }

    void processLocalFile(Folder folder, String string) throws IOException {
        Assert.internalError("UpdateStatus.processLocalFile()");
    }

    void processOneFile(Folder folder, File file) throws IOException {
        int n = file.getStatus();
        boolean bl = this.getAutoEOL();
        boolean bl2 = this.getUseMD5();
        file.updateStatus(bl, bl2);
        int n2 = file.getStatus();
        if (this.isVerbose() || n != n2) {
            this.message(Res.formatKey(ResIDs.UPDATE_STATUS_UPDATED_MESSAGE, new Object[]{file.getName(), Status.name(n2), Status.name(n)}));
        }
    }

    void processNoFiles() {
        Assert.internalError("UpdateStatus.processNoFiles()");
    }

    UpdateStatus() {
    }
}

