/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.commandline;

import com.starbase.starteam.File;
import com.starbase.starteam.Folder;
import com.starbase.starteam.commandline.CommonCommand;
import com.starbase.starteam.commandline.CommonSpec;
import com.starbase.starteam.commandline.Option;
import com.starbase.starteam.commandline.Res;
import com.starbase.starteam.commandline.ResIDs;
import com.starbase.util.Assert;
import java.io.IOException;

class Remove
extends CommonCommand {
    String description() {
        return Res.getString(ResIDs.REMOVE_FILES_DESCRIPTION);
    }

    String name() {
        return "remove";
    }

    boolean treatNoFilesAsAll() {
        return true;
    }

    boolean iterateOnLocalFiles() {
        return false;
    }

    boolean iterateOnServerFiles() {
        return true;
    }

    boolean ignoreUserFileList() {
        return false;
    }

    int run(String[] stringArray) throws IOException {
        CommonSpec commonSpec = new CommonSpec(true, false);
        commonSpec.addOption(new Option("DeleteLocalFile", false));
        commonSpec.removeViewConfigOptions();
        this.setSpec(commonSpec);
        return this.runCommand(stringArray);
    }

    private boolean deleteLocal() {
        return this.getIsOptionOn("DeleteLocalFile");
    }

    void processLocalFile(Folder folder, String string) throws IOException {
        Assert.internalError("Remove.processLocalFile()");
    }

    void processOneFile(Folder folder, File file) throws IOException {
        if (this.deleteLocal()) {
            file.removeAndDeleteLocal();
        } else {
            file.remove();
        }
        this.message(Res.formatKey(ResIDs.REMOVE_FILES_REMOVED_MSG, new Object[]{file.getName()}));
    }

    void processNoFiles() {
        Assert.internalError("Remove.processNoFile()");
    }

    Remove() {
    }
}

