/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.commandline;

import com.starbase.starteam.ChangeRequest;
import com.starbase.starteam.Item;
import com.starbase.starteam.Link;
import com.starbase.starteam.Project;
import com.starbase.starteam.PropertyEnums;
import com.starbase.starteam.PropertyNames;
import com.starbase.starteam.StarTeamClientOptions;
import com.starbase.starteam.Task;
import com.starbase.starteam.Type;
import com.starbase.starteam.View;
import com.starbase.starteam.commandline.Res;
import com.starbase.starteam.commandline.ResIDs;
import com.starbase.util.GUID;
import java.io.IOException;

class ProcessItem {
    private static final String EMPTY_STRING = "";
    public static final String REQ_STATUS = "Status";
    public static final String REQ_PRIORITY = "Priority";
    public static final String REQ_NUMBER = "RequirementNumber";
    public static final String REQ_NAME = "Name";
    public static final String REQ_PARENT_OBJECT_ID = "ParentRequirementID";
    public static final int REQ_STATUS_SUBMITTED = 0;
    public static final int REQ_STATUS_PENDING = 1;
    public static final int REQ_STATUS_ACCEPTED = 2;
    public static final int REQ_STATUS_DRAFT = 3;
    public static final int REQ_STATUS_DEFERRED = 4;
    public static final int REQ_STATUS_REVIEW = 5;
    public static final int REQ_STATUS_COMPLETE = 6;
    public static final int REQ_STATUS_READY_FOR_CCB = 7;
    public static final int REQ_STATUS_REJECTED = 8;
    public static final int REQ_STATUS_APPROVED = 9;
    public static final int REQ_PRIORITY_UNASSIGNED = 0;
    public static final int REQ_PRIORITY_ESSENTIAL = 1;
    public static final int REQ_PRIORITY_USEFUL = 2;
    public static final int REQ_PRIORITY_DESIRABLE = 3;
    public static final String PROJECT_PROCESS_SELECT_REQ = "ProcessSelectRequirement";
    public static final String PROJECT_PROCESS_SHOW_REQ_APPROVED = "ProcessShowReqApproved";
    private static final GUID m_requirementsGUID = new GUID("3f650429-d29a-4c7e-b086-4a60d853678d");

    public static boolean isRequirementsComponent(Type type) {
        return m_requirementsGUID.equals(type.getComponentGUID());
    }

    public static String getRequirementDisplayName() {
        return Res.getString(ResIDs.PROCESS_ITEM_REQUIREMENT_DISPLAY);
    }

    public static String getTypeDisplayName(Type type) {
        if (type.getName().equals(type.getServer().getTypeNames().CHANGEREQUEST)) {
            return Res.getString(ResIDs.PROCESS_ITEM_CHANGE_REQUEST_DISPLAY);
        }
        if (ProcessItem.isRequirementsComponent(type)) {
            return ProcessItem.getRequirementDisplayName();
        }
        return type.getDisplayName();
    }

    public static String shorten(String string, int n) {
        int n2 = string.length();
        int n3 = n > n2 ? n2 : n;
        StringBuffer stringBuffer = new StringBuffer(n > n2 ? n2 : n + 3);
        int n4 = 0;
        while (n4 < n3) {
            char c = string.charAt(n4);
            if (c != '\t' && c != '\r' && c != '\n') {
                stringBuffer.append(c);
            } else {
                stringBuffer.append(" ");
            }
            ++n4;
        }
        if (n3 < n2) {
            stringBuffer.append("...");
        }
        return stringBuffer.toString();
    }

    public static boolean requiresProcessRules(Project project) {
        String string = project.getServer().getPropertyNames().PROJECT_PROCESS_REQUIRED;
        return project.getType().hasPropertyForName(string) && project.getInt(string) != 0;
    }

    public static void markProcessItemFixed(Item item) {
        if (item == null) {
            return;
        }
        PropertyNames propertyNames = item.getPropertyNames();
        PropertyEnums propertyEnums = item.getServer().getPropertyEnums();
        boolean bl = false;
        if (ProcessItem.isCR(item)) {
            item.put(propertyNames.CR_STATUS, new Integer(propertyEnums.CR_STATUS_FIXED));
            item.put(propertyNames.CR_RESPONSIBILITY, new Integer(item.getInt(propertyNames.CR_ENTERED_BY)));
            item.put(propertyNames.CR_ADDRESSED_IN, new Integer(-2));
            bl = true;
        } else if (ProcessItem.isTask(item)) {
            item.put(item.getPropertyNames().TASK_STATUS, new Integer(item.getServer().getPropertyEnums().TASK_STATUS_FINISHED));
            bl = true;
        } else if (ProcessItem.isRequirement(item)) {
            item.put(REQ_STATUS, new Integer(6));
            bl = true;
        }
        if (bl) {
            item.update();
        }
    }

    public static String getProcessItemName(Item item) {
        if (item == null) {
            return EMPTY_STRING;
        }
        if (ProcessItem.isCR(item)) {
            return Res.formatKey(ResIDs.PROCESS_ITEM_CHANGE_REQUEST_ITEM_DISPLAY, new Object[]{new Integer(((ChangeRequest)item).getNumber())});
        }
        if (ProcessItem.isTask(item)) {
            return Res.formatKey(ResIDs.PROCESS_ITEM_TASK_ITEM_DISPLAY, new Object[]{new Integer(((Task)item).getNumber())});
        }
        if (ProcessItem.isRequirement(item)) {
            return Res.formatKey(ResIDs.PROCESS_ITEM_REQUIREMENT_ITEM_DISPLAY, new Object[]{new Integer(item.getInt(REQ_NUMBER))});
        }
        throw new RuntimeException(Res.formatKey(ResIDs.PROCESS_ITEM_INVALID_PROCESS_ITEM_ERROR_MSG, new Object[]{ProcessItem.getTypeDisplayName(item.getType())}));
    }

    public static String getProcessToolTip(Item item) {
        if (item == null) {
            return EMPTY_STRING;
        }
        String string = EMPTY_STRING;
        if (ProcessItem.isCR(item)) {
            string = ((ChangeRequest)item).getSynopsis();
        } else if (ProcessItem.isTask(item)) {
            string = ((Task)item).getName();
        } else if (ProcessItem.isRequirement(item)) {
            string = item.getString(REQ_NAME);
        } else {
            throw new IllegalArgumentException(Res.formatKey(ResIDs.PROCESS_ITEM_INVALID_PROCESS_ITEM_ERROR_MSG, new Object[]{ProcessItem.getTypeDisplayName(item.getType())}));
        }
        return ProcessItem.shorten(string, 70);
    }

    public static boolean getValidProcessItemType(Item item) {
        if (item == null) {
            return false;
        }
        Project project = item.getView().getProject();
        PropertyNames propertyNames = item.getPropertyNames();
        PropertyEnums propertyEnums = item.getServer().getPropertyEnums();
        if (ProcessItem.requiresProcessRules(project)) {
            if (ProcessItem.isCR(item)) {
                return project.getInt(propertyNames.PROJECT_PROCESS_SELECT_CR) != 0;
            }
            if (ProcessItem.isTask(item)) {
                return project.getInt(propertyNames.PROJECT_PROCESS_SELECT_TASK) != 0;
            }
            if (ProcessItem.isRequirement(item)) {
                return project.getInt(PROJECT_PROCESS_SELECT_REQ) != 0;
            }
        } else {
            return ProcessItem.isCR(item) || ProcessItem.isTask(item) || ProcessItem.isRequirement(item);
        }
        return false;
    }

    public static boolean getValidProcessType(Type type) {
        if (type == null) {
            return false;
        }
        if (type.getName().equals(type.getServer().getTypeNames().CHANGEREQUEST)) {
            return true;
        }
        if (type.getName().equals(type.getServer().getTypeNames().TASK)) {
            return true;
        }
        return ProcessItem.isRequirementsComponent(type);
    }

    public static boolean getValidProcessItemState(Item item) throws IOException {
        int n;
        if (item == null) {
            return false;
        }
        Project project = item.getView().getProject();
        PropertyNames propertyNames = item.getPropertyNames();
        PropertyEnums propertyEnums = item.getServer().getPropertyEnums();
        if (!ProcessItem.getValidProcessItemType(item)) {
            throw new IOException(Res.formatKey(ResIDs.PROCESS_ITEM_INVALID_PROCESS_ITEM_TYPE_ERROR_MSG, new Object[]{item.getType().getDisplayName()}));
        }
        item.discard();
        if (item.getServer().getRevisionLevel() >= 81) {
            n = item.getServer().getMyUserAccount().getID();
            if (item.getLocker() >= 0 && item.getLocker() != n) {
                throw new IOException(Res.getString(ResIDs.PROCESS_ITEM_LOCKED_BY_USER_ERROR_MSG));
            }
        }
        if (!ProcessItem.requiresProcessRules(project)) {
            return true;
        }
        if (ProcessItem.isCR(item)) {
            if (project.getInt(propertyNames.PROJECT_PROCESS_SELECT_CR) != 0) {
                if (project.getInt(propertyNames.PROJECT_PROCESS_SHOW_CR_OPEN) == 0 && project.getInt(propertyNames.PROJECT_PROCESS_SHOW_CR_IN_PROGRESS) == 0) {
                    return true;
                }
                n = item.getInt(propertyNames.CR_STATUS);
                if (n == propertyEnums.CR_STATUS_OPEN) {
                    return project.getInt(propertyNames.PROJECT_PROCESS_SHOW_CR_OPEN) != 0;
                }
                if (n == propertyEnums.CR_STATUS_IN_PROGRESS) {
                    return project.getInt(propertyNames.PROJECT_PROCESS_SHOW_CR_IN_PROGRESS) != 0;
                }
                throw new IOException(Res.getString(ResIDs.PROCESS_ITEM_BAD_CR_STATE_ERROR_MSG));
            }
        } else if (ProcessItem.isTask(item)) {
            if (project.getInt(propertyNames.PROJECT_PROCESS_SELECT_TASK) != 0) {
                if (project.getInt(propertyNames.PROJECT_PROCESS_SHOW_TASK_READY) == 0 && project.getInt(propertyNames.PROJECT_PROCESS_SHOW_TASK_IN_PROGRESS) == 0) {
                    return true;
                }
                n = item.getInt(propertyNames.TASK_STATUS);
                if (n == propertyEnums.TASK_STATUS_READY_TO_START) {
                    return project.getInt(propertyNames.PROJECT_PROCESS_SHOW_TASK_READY) != 0;
                }
                if (n == propertyEnums.TASK_STATUS_IN_PROGRESS) {
                    return project.getInt(propertyNames.PROJECT_PROCESS_SHOW_TASK_IN_PROGRESS) != 0;
                }
                throw new IOException(Res.getString(ResIDs.PROCESS_ITEM_BAD_TASK_STATE_ERROR_MSG));
            }
        } else if (ProcessItem.isRequirement(item) && project.getInt(PROJECT_PROCESS_SELECT_REQ) != 0) {
            if (project.getInt(PROJECT_PROCESS_SHOW_REQ_APPROVED) == 0) {
                return true;
            }
            n = item.getInt(REQ_STATUS);
            if (n == 9) {
                return project.getInt(PROJECT_PROCESS_SHOW_REQ_APPROVED) != 0;
            }
            throw new IOException(Res.getString(ResIDs.PROCESS_ITEM_BAD_REQUIREMENT_STATE_ERROR_MSG));
        }
        return false;
    }

    public static void setProcessItem(Item item) throws IOException {
        View view = item.getView();
        String string = "Project Component::ProcessActiveItem\\";
        String string2 = string + view.getServer().getRepositoryID().toString().toLowerCase() + "\\" + view.getID() + "\\ItemID";
        String string3 = string + view.getServer().getRepositoryID().toString().toLowerCase() + "\\" + view.getID() + "\\ClassID";
        StarTeamClientOptions starTeamClientOptions = StarTeamClientOptions.getDefault();
        starTeamClientOptions.setOption(string2, Integer.toString(item.getItemID()));
        starTeamClientOptions.setOption(string3, Integer.toString(item.getType().getClassID()));
        starTeamClientOptions.save();
    }

    public static void clearProcessItem(View view) throws IOException {
        String string = "Project Component::ProcessActiveItem\\";
        String string2 = string + view.getServer().getRepositoryID().toString().toLowerCase() + "\\" + view.getID() + "\\ItemID";
        String string3 = string + view.getServer().getRepositoryID().toString().toLowerCase() + "\\" + view.getID() + "\\ClassID";
        StarTeamClientOptions starTeamClientOptions = StarTeamClientOptions.getDefault();
        starTeamClientOptions.setOption(string2, "-1");
        starTeamClientOptions.setOption(string3, "-1");
        starTeamClientOptions.save();
    }

    public static int getProcessItemID(View view) throws IOException {
        String string = "Project Component::ProcessActiveItem\\";
        String string2 = string + view.getServer().getRepositoryID().toString().toLowerCase() + "\\" + view.getID() + "\\ItemID";
        StarTeamClientOptions starTeamClientOptions = StarTeamClientOptions.getDefault();
        starTeamClientOptions.reloadIfNeeded();
        String string3 = starTeamClientOptions.getOption(string2, null);
        int n = -1;
        if (string3 != null) {
            try {
                n = Integer.parseInt(string3);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    public static int getProcessClassID(View view) throws IOException {
        String string = "Project Component::ProcessActiveItem\\";
        String string2 = string + view.getServer().getRepositoryID().toString().toLowerCase() + "\\" + view.getID() + "\\ClassID";
        StarTeamClientOptions starTeamClientOptions = StarTeamClientOptions.getDefault();
        starTeamClientOptions.reloadIfNeeded();
        String string3 = starTeamClientOptions.getOption(string2, null);
        int n = -1;
        if (string3 != null) {
            try {
                n = Integer.parseInt(string3);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    public static Item getProcessItem(View view) throws IOException {
        int n = ProcessItem.getProcessItemID(view);
        int n2 = ProcessItem.getProcessClassID(view);
        if (n != -1 && n2 != -1) {
            try {
                Type type = view.getServer().typeForClassID(n2);
                if (type == null) {
                    return null;
                }
                return view.getDisembodiedItem(n, type);
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    public static void linkProcessItem(Item item, Item item2) {
        Link.linkAndPin(item, item2, EMPTY_STRING, true);
    }

    private static boolean isTask(Item item) {
        Type type = item.getType();
        return type.getName().equals(item.getServer().getTypeNames().TASK);
    }

    private static boolean isCR(Item item) {
        Type type = item.getType();
        return type.getName().equals(item.getServer().getTypeNames().CHANGEREQUEST);
    }

    private static boolean isRequirement(Item item) {
        return ProcessItem.isRequirementsComponent(item.getType());
    }

    ProcessItem() {
    }
}

