/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.commandline;

import com.starbase.starteam.File;
import com.starbase.starteam.Folder;
import com.starbase.starteam.StarTeamClientOptions;
import com.starbase.starteam.StatusMethod;
import com.starbase.starteam.commandline.CommonCommand;
import com.starbase.starteam.commandline.CommonSpec;
import com.starbase.starteam.commandline.Option;
import com.starbase.starteam.commandline.Res;
import com.starbase.starteam.commandline.ResIDs;
import com.starbase.starteam.vts.comm.NetMonitor;
import com.starbase.util.Assert;
import java.io.IOException;

class PersonalOptions
extends CommonCommand {
    String description() {
        return Res.getString(ResIDs.PERSONAL_OPTIONS_DESCRIPTION);
    }

    String name() {
        return "set-personal-options";
    }

    boolean treatNoFilesAsAll() {
        return false;
    }

    boolean iterateOnLocalFiles() {
        return false;
    }

    boolean iterateOnServerFiles() {
        return false;
    }

    boolean ignoreUserFileList() {
        return true;
    }

    int run(String[] stringArray) throws IOException {
        CommonSpec commonSpec = new CommonSpec(false, false);
        Object object = new Object();
        commonSpec.addOption(new Option("PersonalCentralStatus", false, object));
        commonSpec.addOption(new Option("PersonalPerFolderStatus", false, object));
        commonSpec.addOption(new Option("PersonalCentralRepository", false));
        commonSpec.addOption(new Option("PersonalListOptions", false));
        commonSpec.removeOption("Project");
        commonSpec.removeOption("PasswordFile");
        commonSpec.removeOption("Compress");
        commonSpec.removeOption("Encrypt");
        commonSpec.removeOption("CaseSensitiveFolders");
        commonSpec.removeViewConfigOptions();
        commonSpec.removeOption("Recurse");
        commonSpec.removeOption("Rootpath");
        commonSpec.removeOption("Folderpath");
        commonSpec.removeOption("StatusFilter");
        this.setSpec(commonSpec);
        return this.runCommand(stringArray);
    }

    void processLocalFile(Folder folder, String string) throws IOException {
        Assert.internalError("PersonalOptions.processLocalFile()");
    }

    void processOneFile(Folder folder, File file) throws IOException {
        Assert.internalError("PersonalOptions.processOneFile()");
    }

    void processNoFiles() throws IOException {
        Assert.internalError("PersonalOptions.processNoFile()");
    }

    private boolean anOptionSpecified() {
        return this.getIsOptionOn("PersonalCentralStatus") || this.getIsOptionOn("PersonalPerFolderStatus") || this.getIsOptionOn("PersonalCentralRepository") || this.getIsOptionOn("PersonalListOptions");
    }

    protected int runCommandImpl(String[] stringArray) throws IOException {
        try {
            String string;
            boolean bl = this.parseArguments(stringArray);
            if (this.showLogo()) {
                CommonCommand.printStartupMsg();
            }
            if (this.showHelp()) {
                this.showUsage();
                return 0;
            }
            if (this.showNetMonitor()) {
                NetMonitor.on();
            }
            if (!bl) {
                this.reportBadOptions(this.getSpec().errorMessage());
                return 1;
            }
            if (!this.anOptionSpecified()) {
                this.reportBadOptions(Res.getString(ResIDs.PERSONAL_OPTIONS_NO_OPTIONS_SPECIFIED_ERROR_MSG));
                return 1;
            }
            StarTeamClientOptions starTeamClientOptions = StarTeamClientOptions.getDefault();
            starTeamClientOptions.reloadIfNeeded();
            boolean bl2 = false;
            if (this.getIsOptionOn("PersonalCentralStatus")) {
                starTeamClientOptions.setOption("File Component::DefaultStatusMethod", "1");
                this.message(Res.getString(ResIDs.PERSONAL_OPTIONS_STATUS_SET_CENTRAL_MSG));
                bl2 = true;
            }
            if (this.getIsOptionOn("PersonalPerFolderStatus")) {
                starTeamClientOptions.setOption("File Component::DefaultStatusMethod", "2");
                this.message(Res.getString(ResIDs.PERSONAL_OPTIONS_STATUS_SET_FOLDER_MSG));
                bl2 = true;
            }
            if (this.getIsOptionOn("PersonalCentralRepository") && (string = this.getStringOption("PersonalCentralRepository")) != null) {
                starTeamClientOptions.setOption("File Component::CentralStatusDir", string);
                this.message(Res.formatKey(ResIDs.PERSONAL_OPTIONS_REPOSITORY_SET_MSG, new Object[]{string}));
                bl2 = true;
            }
            if (this.getIsOptionOn("PersonalListOptions")) {
                string = starTeamClientOptions.getOption("File Component::DefaultStatusMethod", "1").equals("1") ? Res.getString(ResIDs.PERSONAL_OPTIONS_CENTRAL_REPOSITORY) : Res.getString(ResIDs.PERSONAL_OPTIONS_PER_FOLDER);
                this.message(Res.formatKey(ResIDs.PERSONAL_OPTIONS_STATUS_METHOD_MSG, new Object[]{string}));
                this.message(Res.formatKey(ResIDs.PERSONAL_OPTIONS_CENTRAL_REPOSITORY_MSG, new Object[]{starTeamClientOptions.getCentralStatusDirectory()}));
            }
            if (bl2) {
                starTeamClientOptions.save();
                StatusMethod.setDefaultStatusMethod(starTeamClientOptions.getDefaultStatusMethod());
                string = starTeamClientOptions.getCentralStatusDirectory();
                if (string != null) {
                    StatusMethod.setCentralStatusDirectory(string);
                }
            }
            return 0;
        }
        catch (Throwable throwable) {
            this.reportError(throwable);
            NetMonitor.kill();
            return 1;
        }
    }

    PersonalOptions() {
    }
}

