/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.commandline;

import com.starbase.starteam.File;
import com.starbase.starteam.Folder;
import com.starbase.starteam.Item;
import com.starbase.starteam.Status;
import com.starbase.starteam.User;
import com.starbase.starteam.commandline.CommonCommand;
import com.starbase.starteam.commandline.CommonSpec;
import com.starbase.starteam.commandline.Res;
import com.starbase.starteam.commandline.ResIDs;
import com.starbase.util.Assert;
import java.io.IOException;

class History
extends CommonCommand {
    String description() {
        return Res.getString(ResIDs.HISTORY_DESCRIPTION);
    }

    String name() {
        return "hist";
    }

    boolean treatNoFilesAsAll() {
        return true;
    }

    boolean iterateOnLocalFiles() {
        return false;
    }

    boolean iterateOnServerFiles() {
        return true;
    }

    boolean ignoreUserFileList() {
        return false;
    }

    int run(String[] stringArray) throws IOException {
        CommonSpec commonSpec = new CommonSpec(true, false);
        this.setSpec(commonSpec);
        return this.runCommand(stringArray);
    }

    void processLocalFile(Folder folder, String string) throws IOException {
        Assert.internalError("History.processLocalFile()");
    }

    void processOneFile(Folder folder, File file) throws IOException {
        Item[] itemArray = file.getHistory();
        this.message(Res.formatKey(ResIDs.HISTORY_HISTORY_FOR_MSG, new Object[]{file.getName()}));
        this.message(Res.formatKey(ResIDs.HISTORY_DESCRIPTION_MSG, new Object[]{file.getDescription()}));
        User user = file.getServer().getUser(file.getLocker());
        this.message(Res.formatKey(ResIDs.HISTORY_LOCKED_BY_MSG, new Object[]{user == null ? "" : user.getName()}));
        this.message(Res.formatKey(ResIDs.HISTORY_STATUS_MSG, new Object[]{Status.name(file.getStatus())}));
        int n = 0;
        while (n < itemArray.length) {
            File file2 = (File)itemArray[n];
            User user2 = file.getServer().getUser(file2.getModifiedBy());
            this.message("----------------------------");
            this.message(Res.formatKey(ResIDs.HISTORY_REVISION_INFO_MSG, new Object[]{new Integer(file2.getViewVersion()), file2.getView().getName(), file2.getDotNotation()}));
            this.message(Res.formatKey(ResIDs.HISTORY_AUTHOR_INFO_MSG, new Object[]{user2 != null ? user2.getName() : Res.getString(ResIDs.HISTORY_UNKNOWN), file2.getModifiedTime()}));
            String string = file2.getComment();
            if (string != null && string.length() != 0) {
                this.message(string);
                this.message("");
            }
            ++n;
        }
        this.message("=============================================================================");
        this.message("");
    }

    private String padRight(String string, int n) {
        return string + this.pad(n - string.length());
    }

    private String padLeft(String string, int n) {
        return this.pad(n - string.length()) + string;
    }

    private String pad(int n) {
        if (n <= 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(" ");
            ++n2;
        }
        return stringBuffer.toString();
    }

    void processNoFiles() {
        Assert.internalError("History.processNoFile()");
    }

    History() {
    }
}

