/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.commandline;

import com.starbase.diff.BasicCompare;
import com.starbase.diff.ColumnMask;
import com.starbase.diff.ConsoleWriter;
import com.starbase.diff.DiffException;
import com.starbase.diff.EditList;
import com.starbase.diff.ParsedCharSequence;
import com.starbase.diff.StarTeamDiff;
import com.starbase.starteam.File;
import com.starbase.starteam.Folder;
import com.starbase.starteam.Keyword;
import com.starbase.starteam.KeywordReader;
import com.starbase.starteam.Label;
import com.starbase.starteam.commandline.ColumnMaskOption;
import com.starbase.starteam.commandline.CommonCommand;
import com.starbase.starteam.commandline.CommonSpec;
import com.starbase.starteam.commandline.EOLSpecifierOption;
import com.starbase.starteam.commandline.Option;
import com.starbase.starteam.commandline.PositiveIntegerOption;
import com.starbase.starteam.commandline.Res;
import com.starbase.starteam.commandline.ResIDs;
import com.starbase.starteam.commandline.TimeOption;
import com.starbase.util.Assert;
import com.starbase.util.FileUtils;
import com.starbase.util.LineReader;
import com.starbase.util.OLEDate;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.Date;
import java.util.Vector;

class Diff
extends CommonCommand {
    private StarTeamDiff m_differ = new StarTeamDiff();
    private BasicCompare m_compare = null;
    private java.io.File m_source_to_delete = null;
    private java.io.File m_target_to_delete = null;
    private java.io.File m_diff_source = null;
    private java.io.File m_diff_target = null;
    private String m_sourceDisplay = null;
    private String m_targetDisplay = null;
    private Object m_sourceSpec = null;
    private Object m_targetSpec = null;
    private boolean m_anyWithDiff = false;
    private boolean m_eol = false;
    private String m_sourceEncoding;
    private String m_targetEncoding;

    String description() {
        return Res.getString(ResIDs.DIFF_DESCRIPTION);
    }

    String name() {
        return "diff";
    }

    boolean treatNoFilesAsAll() {
        return true;
    }

    boolean iterateOnLocalFiles() {
        return false;
    }

    boolean iterateOnServerFiles() {
        return true;
    }

    boolean ignoreUserFileList() {
        return false;
    }

    int run(String[] stringArray) throws IOException {
        CommonSpec commonSpec = new CommonSpec(true, false);
        Object object = new Object();
        commonSpec.addOption(new EOLSpecifierOption("EOLSpecifier"));
        commonSpec.addOption(new Option("ALL-whitespace", false, object));
        commonSpec.addOption(new Option("PVCS-whitespace", false, object));
        commonSpec.addOption(new Option("UnixDiff-whitespace", false, object));
        commonSpec.addOption(new Option("IgnoreCase", false));
        commonSpec.addOption(new ColumnMaskOption("ColumnMask", false));
        commonSpec.addOption(new PositiveIntegerOption("TabConvert", true, false));
        commonSpec.addOption(new PositiveIntegerOption("ContextLines", true, false));
        commonSpec.addOption(new Option("HideLineNumbers", false));
        commonSpec.addOption(new Option("HideDiffOutput", false));
        commonSpec.addOption(new Option("DiffErrorCode", false));
        Object var4_4 = null;
        commonSpec.addOption(new PositiveIntegerOption("VersionNumber", false, 0, 2, var4_4));
        commonSpec.addOption(new TimeOption("VersionDate", 0, 2, var4_4));
        commonSpec.addOption(new Option("VersionLabel", 0, 2, var4_4));
        commonSpec.addOption(new Option("SrcTgtEncoding", false));
        this.setSpec(commonSpec);
        int n = this.runCommand(stringArray);
        if (this.getReturnErrorCode()) {
            switch (n) {
                case 0: {
                    return this.m_anyWithDiff ? 2 : 0;
                }
                case 1: 
                case 101: 
                case 102: {
                    return n;
                }
            }
            Assert.internalError("Diff.run(),ret=" + n);
            return n;
        }
        return n;
    }

    protected boolean parseArguments(String[] stringArray) {
        boolean bl = super.parseArguments(stringArray);
        if (bl) {
            Vector<Option> vector = new Vector<Option>();
            vector.addElement(this.getSpec().findPossibleOption(Option.getName("VersionNumber")));
            vector.addElement(this.getSpec().findPossibleOption(Option.getName("VersionDate")));
            vector.addElement(this.getSpec().findPossibleOption(Option.getName("VersionLabel")));
            Vector vector2 = this.getSpec().getOptionValues(vector);
            if (vector2.size() > 2) {
                this.getSpec().setErrorMsg(Res.formatKey(ResIDs.DIFF_TWO_OPTIONS_ALLOWED_ERROR_MSG, new Object[]{Option.OPTION_PREFIX, Option.getName("VersionNumber"), Option.OPTION_PREFIX, Option.getName("VersionDate"), Option.OPTION_PREFIX, Option.getName("VersionLabel")}));
                return false;
            }
            this.m_sourceSpec = null;
            this.m_targetSpec = null;
            if (vector2.size() == 1) {
                this.m_sourceSpec = vector2.elementAt(0);
            } else if (vector2.size() == 2) {
                this.m_sourceSpec = vector2.elementAt(0);
                this.m_targetSpec = vector2.elementAt(1);
            }
            this.m_sourceEncoding = System.getProperty("file.encoding");
            this.m_targetEncoding = System.getProperty("file.encoding");
            if (this.getIsOptionOn("SrcTgtEncoding")) {
                String string;
                this.m_sourceEncoding = string = this.getStringOption("SrcTgtEncoding");
                this.m_targetEncoding = string;
            }
            if (!this.isEncodingSupported(this.m_sourceEncoding)) {
                this.getSpec().setErrorMsg(Res.formatKey(ResIDs.DIFF_ENCODING_NOT_SUPPORTED_ERROR_MSG, new Object[]{this.m_sourceEncoding}));
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean getAutoEOL() {
        return this.m_eol;
    }

    private boolean getReturnErrorCode() {
        return this.getIsOptionOn("DiffErrorCode");
    }

    private boolean getShowDiffOutput() {
        return !this.getIsOptionOn("HideDiffOutput");
    }

    private boolean getShowLineNumbers() {
        return !this.getIsOptionOn("HideLineNumbers");
    }

    private int getTabConvert() {
        return this.getIsOptionOn("TabConvert") ? this.getIntegerOption("TabConvert") : 4;
    }

    private int getContextLines() {
        return this.getIsOptionOn("ContextLines") ? this.getIntegerOption("ContextLines") : -1;
    }

    private ColumnMask[] getColumnMask() {
        return this.getIsOptionOn("ColumnMask") ? (ColumnMask[])this.getOptionObject("ColumnMask") : null;
    }

    protected void preOperation() throws IOException {
        Label label;
        String string;
        Object object;
        this.m_eol = false;
        if (this.getIsOptionOn("EOLSpecifier")) {
            object = this.getStringOption("EOLSpecifier");
            if (((String)object).equals("off")) {
                this.m_eol = false;
            } else {
                this.m_eol = true;
                if (!((String)object).equals("default")) {
                    this.getServer().getClientContext().setEOL((String)object);
                }
            }
        }
        object = this.getColumnMask();
        int n = 0;
        if (this.getIsOptionOn("IgnoreCase")) {
            n |= 0x100;
        }
        if (this.getIsOptionOn("PVCS-whitespace")) {
            n |= 0x11;
        } else if (this.getIsOptionOn("ALL-whitespace")) {
            n |= 0x15;
        } else if (this.getIsOptionOn("UnixDiff-whitespace")) {
            n |= 0x1A;
        }
        this.m_compare = new BasicCompare(n, (ColumnMask[])object);
        if (this.m_sourceSpec != null && this.m_sourceSpec instanceof String) {
            string = (String)this.m_sourceSpec;
            label = this.findLabel(string);
            if (label == null) {
                throw new IOException(Res.formatKey(ResIDs.DIFF_LABEL_MISSING_ERROR_MSG, new Object[]{string}));
            }
            this.m_sourceSpec = label;
        }
        if (this.m_targetSpec != null && this.m_targetSpec instanceof String) {
            string = (String)this.m_targetSpec;
            label = this.findLabel(string);
            if (label == null) {
                throw new IOException(Res.formatKey(ResIDs.DIFF_LABEL_MISSING_ERROR_MSG, new Object[]{string}));
            }
            this.m_targetSpec = label;
        }
    }

    void processLocalFile(Folder folder, String string) throws IOException {
        Assert.internalError("Diff.processLocalFile()");
    }

    void processNoFiles() {
        Assert.internalError("Diff.processNoFiles()");
    }

    void processOneFile(Folder folder, File file) throws IOException {
        Keyword[] keywordArray = null;
        if (file.usesKeywords()) {
            keywordArray = file.getBlankKeywords();
        }
        try {
            block13: {
                try {
                    ParsedCharSequence parsedCharSequence;
                    this.prepareFiles(file);
                    if (FileUtils.isBinary(this.m_diff_source) || FileUtils.isBinary(this.m_diff_target)) {
                        long l = FileUtils.cmp(this.m_diff_source, this.m_diff_target);
                        if (l != -1L) {
                            this.m_anyWithDiff = true;
                        }
                        if (this.getShowDiffOutput()) {
                            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(System.out));
                            bufferedWriter.write(this.m_sourceDisplay);
                            bufferedWriter.newLine();
                            bufferedWriter.write(this.m_targetDisplay);
                            bufferedWriter.newLine();
                            if (l == -1L) {
                                bufferedWriter.write(Res.getString(ResIDs.DIFF_BINARY_FILES_IDENTICAL_MSG));
                                bufferedWriter.newLine();
                            } else {
                                bufferedWriter.write(Res.formatKey(ResIDs.DIFF_BINARY_FILES_DIFFER_MSG, new Object[]{new Long(l)}));
                            }
                            bufferedWriter.newLine();
                            bufferedWriter.flush();
                        }
                        break block13;
                    }
                    ParsedCharSequence parsedCharSequence2 = this.parseFile(this.m_diff_source, keywordArray, this.m_sourceEncoding);
                    EditList editList = this.m_differ.diff(parsedCharSequence2, parsedCharSequence = this.parseFile(this.m_diff_target, keywordArray, this.m_targetEncoding), this.m_compare);
                    if (editList.length() != 0) {
                        this.m_anyWithDiff = true;
                    }
                    if (!this.getShowDiffOutput()) break block13;
                    BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(System.out));
                    bufferedWriter.write(this.m_sourceDisplay);
                    bufferedWriter.newLine();
                    bufferedWriter.write(this.m_targetDisplay);
                    bufferedWriter.newLine();
                    if (editList.length() == 0) {
                        bufferedWriter.write(Res.getString(ResIDs.DIFF_REVISIONS_ARE_IDENTICAL_MSG));
                        bufferedWriter.newLine();
                    } else {
                        ConsoleWriter consoleWriter = new ConsoleWriter(bufferedWriter, this.getShowLineNumbers(), this.getTabConvert(), this.getContextLines(), parsedCharSequence2, parsedCharSequence);
                        consoleWriter.write(editList, parsedCharSequence2.size(), parsedCharSequence.size());
                    }
                    bufferedWriter.newLine();
                    bufferedWriter.flush();
                }
                catch (DiffException diffException) {
                    Assert.internalError("Diff.processOneFile()", diffException);
                    Object var5_13 = null;
                    this.deleteTempFiles();
                }
            }
            Object var5_12 = null;
            this.deleteTempFiles();
        }
        catch (Throwable throwable) {
            Object var5_14 = null;
            this.deleteTempFiles();
            throw throwable;
        }
    }

    private void deleteTempFiles() {
        if (this.m_source_to_delete != null) {
            this.m_source_to_delete.delete();
            this.m_source_to_delete = null;
        }
        if (this.m_target_to_delete != null) {
            this.m_target_to_delete.delete();
            this.m_target_to_delete = null;
        }
    }

    private void prepareFiles(File file) throws IOException {
        this.m_source_to_delete = null;
        this.m_target_to_delete = null;
        this.prepareSource(file);
        this.prepareTarget(file);
    }

    private void prepareSource(File file) throws IOException {
        String string = file.getFullName();
        String string2 = this.getTempFileName(string, "src");
        this.m_diff_source = this.m_source_to_delete = new java.io.File(string2);
        this.m_sourceDisplay = this.checkoutBySpec(this.m_sourceSpec, string2, file);
    }

    private void prepareTarget(File file) throws IOException {
        if (this.m_targetSpec == null) {
            this.m_target_to_delete = null;
            this.m_diff_target = new java.io.File(file.getFullName());
            this.m_targetDisplay = Res.formatKey(ResIDs.DIFF_TARGET_DISPLAY, new Object[]{file.getName()});
        } else {
            String string = file.getFullName();
            String string2 = this.getTempFileName(string, "tgt");
            this.m_diff_target = this.m_target_to_delete = new java.io.File(string2);
            this.m_targetDisplay = this.checkoutBySpec(this.m_targetSpec, string2, file);
        }
    }

    private String getTempFileName(String string, String string2) throws IOException {
        int n = 10;
        String string3 = string + "." + string2;
        java.io.File file = new java.io.File(string3);
        if (!file.exists()) {
            return string3;
        }
        String string4 = null;
        int n2 = 1;
        while (n2 <= n) {
            String string5 = string3 + "." + n2;
            file = new java.io.File(string5);
            if (!file.exists()) {
                string4 = string5;
                break;
            }
            ++n2;
        }
        if (string4 != null) {
            return string4;
        }
        throw new IOException(Res.formatKey(ResIDs.DIFF_UNABLE_TO_CREATE_TEMP_FILE_ERROR_MSG, new Object[]{string3}));
    }

    private String checkoutBySpec(Object object, String string, File file) throws IOException {
        int n;
        File file2 = null;
        if (object == null) {
            file2 = file;
        } else if (object instanceof Integer) {
            n = (Integer)object;
            file2 = (File)file.getFromHistoryByVersion(n);
            if (file2 == null) {
                throw new IOException(Res.formatKey(ResIDs.DIFF_REVISION_DOES_NOT_EXIST_ERROR_MSG, new Object[]{new Integer(n), file.getName()}));
            }
        } else if (object instanceof Label) {
            Label label = (Label)object;
            file2 = (File)file.getFromHistoryByLabelID(label.getID());
            if (file2 == null) {
                throw new IOException(Res.formatKey(ResIDs.DIFF_LABEL_NOT_ASSOCIATED_WITH_FILE_ERROR_MSG, new Object[]{label.getName(), file.getName()}));
            }
        } else if (object instanceof Date) {
            OLEDate oLEDate = new OLEDate(((Date)object).getTime());
            file2 = (File)file.getFromHistoryByDate(oLEDate);
            if (file2 == null) {
                throw new IOException(Res.formatKey(ResIDs.DIFF_NO_REVISION_EXISTS_AS_OF_DATE_ERROR_MSG, new Object[]{file.getName(), new Date(oLEDate.getLongValue())}));
            }
        } else {
            Assert.internalError("Diff.checkoutBySpec(),specclass=" + object.getClass().getName());
        }
        n = 0;
        boolean bl = true;
        file2.checkoutTo(new java.io.File(string), 3, bl, this.getAutoEOL(), n != 0);
        return Res.formatKey(ResIDs.DIFF_DISPLAY, new Object[]{file.getName(), new Integer(file2.getViewVersion()), new Date(file2.getModifiedTime().getLongValue())});
    }

    private ParsedCharSequence parseFile(java.io.File file, Keyword[] keywordArray, String string) throws IOException {
        Reader reader = new InputStreamReader((InputStream)new FileInputStream(file), string);
        if (keywordArray != null) {
            reader = new KeywordReader(new LineReader(reader), keywordArray, false);
        }
        return new ParsedCharSequence(new BufferedReader(reader));
    }

    private boolean isEncodingSupported(String string) {
        boolean bl;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(new byte[0]);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)byteArrayInputStream, string);
            bl = true;
        }
        catch (Throwable throwable) {
            bl = false;
        }
        return bl;
    }

    Diff() {
    }
}

