/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.commandline;

import com.starbase.diff.BasicColumnMask;
import com.starbase.diff.ColumnMask;
import com.starbase.starteam.commandline.Option;
import com.starbase.starteam.commandline.Res;
import com.starbase.starteam.commandline.ResIDs;
import java.util.StringTokenizer;
import java.util.Vector;

class ColumnMaskOption
extends Option {
    static final String NUMBERED_COLUMN_SPECIFIER = "(numeric)";

    String getUsageDescription() {
        return Res.formatKey(ResIDs.COLUMN_MASK_USAGE, new Object[]{"1-6 (numeric), 20-30"});
    }

    Object getPropertyValue(String string) {
        return this.parseWhole(string);
    }

    private ColumnMask[] parseWhole(String string) {
        Object[] objectArray = null;
        Vector<ColumnMask> vector = new Vector<ColumnMask>();
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            ColumnMask columnMask = this.parseOne(string2);
            if (columnMask == null) {
                bl = false;
                break;
            }
            vector.addElement(columnMask);
            bl = true;
        }
        if (bl) {
            objectArray = new ColumnMask[vector.size()];
            vector.copyInto(objectArray);
        }
        return objectArray;
    }

    private ColumnMask parseOne(String string) {
        int n;
        BasicColumnMask basicColumnMask = null;
        string = string.trim();
        boolean bl = false;
        if (string.endsWith(NUMBERED_COLUMN_SPECIFIER)) {
            bl = true;
            string = string.substring(0, string.length() - NUMBERED_COLUMN_SPECIFIER.length());
        }
        if ((n = string.indexOf("-")) != -1) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1, string.length());
            try {
                int n2 = Integer.valueOf(string2.trim());
                int n3 = Integer.valueOf(string3.trim());
                if (n2 <= n3 && n2 > 0 && n3 > 0) {
                    basicColumnMask = new BasicColumnMask(n2, n3, bl);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return basicColumnMask;
    }

    ColumnMaskOption(String string, boolean bl) {
        super(string, bl);
    }

    ColumnMaskOption(String string, boolean bl, Object object) {
        super(string, bl, object);
    }
}

