/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.commandline;

import com.starbase.starteam.File;
import com.starbase.starteam.Folder;
import com.starbase.starteam.commandline.CommandLineQuitException;
import com.starbase.starteam.commandline.CommonCommand;
import com.starbase.starteam.commandline.CommonSpec;
import com.starbase.starteam.commandline.Res;
import com.starbase.starteam.commandline.ResIDs;
import com.starbase.starteam.vts.comm.SystemRevisionNumbers;
import com.starbase.util.Assert;
import java.io.IOException;

class ClientStatus
extends CommonCommand {
    String description() {
        return Res.getString(ResIDs.CLIENT_STATUS_DESCRIPTION);
    }

    String name() {
        return "move-status";
    }

    boolean treatNoFilesAsAll() {
        return true;
    }

    boolean iterateOnLocalFiles() {
        return false;
    }

    boolean iterateOnServerFiles() {
        return true;
    }

    boolean ignoreUserFileList() {
        return false;
    }

    int run(String[] stringArray) throws IOException {
        CommonSpec commonSpec = new CommonSpec(true, false);
        this.setSpec(commonSpec);
        return this.runCommand(stringArray);
    }

    protected void preOperation() throws IOException {
        if (SystemRevisionNumbers.isClientManagedStatus(this.getServer().getRevisionLevel())) {
            this.message(Res.getString(ResIDs.FILES_STORE_STATUS_LOCALLY_MSG));
            throw new CommandLineQuitException();
        }
    }

    void processLocalFile(Folder folder, String string) throws IOException {
        Assert.internalError("ClientStatus.processLocalFile()");
    }

    void processOneFile(Folder folder, File file) throws IOException {
        boolean bl = file.upgradeSyncInfo();
        this.message(Res.formatKey(ResIDs.CLIENT_STATUS_COMMAND_MSG, new Object[]{file.getName(), bl ? Res.getString(ResIDs.CLIENT_STATUS_STATUS_STORED) : Res.getString(ResIDs.CLIENT_STATUS_NO_STATUS_FOUND)}));
    }

    void processNoFiles() {
        Assert.internalError("ClientStatus.processNoFile()");
    }

    ClientStatus() {
    }
}

