/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.commandline;

import com.starbase.starteam.File;
import com.starbase.starteam.Folder;
import com.starbase.starteam.Project;
import com.starbase.starteam.StarTeamURL;
import com.starbase.starteam.commandline.CommonCommand;
import com.starbase.starteam.commandline.CommonSpec;
import com.starbase.starteam.commandline.ExcludeOption;
import com.starbase.starteam.commandline.Option;
import com.starbase.starteam.commandline.Res;
import com.starbase.starteam.commandline.ResIDs;
import com.starbase.starteam.commandline.ServerSpecOption;
import com.starbase.starteam.vts.comm.NetMonitor;
import com.starbase.util.Assert;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

class AddProject
extends CommonCommand {
    private String m_folderExcludeList = null;

    String description() {
        return Res.getString(ResIDs.ADD_PROJECT_DESCRIPTION);
    }

    String name() {
        return "add-project";
    }

    boolean treatNoFilesAsAll() {
        return false;
    }

    boolean iterateOnLocalFiles() {
        return false;
    }

    boolean iterateOnServerFiles() {
        return false;
    }

    boolean ignoreUserFileList() {
        return true;
    }

    private String getProjectName() {
        return this.getStringOption("ProjectName");
    }

    private String getProjectRoot() throws IOException {
        return this.getStringOption("ProjectRoot");
    }

    private String getProjectDescription() {
        String string = this.getStringOption("ProjectDescription");
        if (string == null) {
            string = "";
        }
        return string;
    }

    private String getKeywordList() {
        return this.getStringOption("ProjectKeyword");
    }

    private String getServerSpec() {
        return this.getStringOption("ServerSpec");
    }

    private String getKeywordFile() {
        return this.getStringOption("ProjectKeywordFile");
    }

    private int getFolderExclude() throws RuntimeException {
        String string = this.getStringOption("FolderExclude");
        if ("inherit".equals(string.toLowerCase())) {
            return 2;
        }
        if ("local".equals(string.toLowerCase())) {
            return 1;
        }
        if ("none".equals(string.toLowerCase())) {
            return 0;
        }
        throw new RuntimeException(Res.formatKey(ResIDs.BAD_EXCLUDE_FLAG_ERROR_MSG, new Object[]{string}));
    }

    private String getExcludeListFile() {
        return this.getStringOption("FolderExcludeFile");
    }

    private String getFolderExcludeList() throws IOException {
        if (this.getIsOptionOn("FolderExcludeList")) {
            return this.getStringOption("FolderExcludeList");
        }
        if (this.getIsOptionOn("FolderExcludeFile")) {
            String string = this.getExcludeListFromFile(this.getExcludeListFile());
            return string;
        }
        return null;
    }

    int run(String[] stringArray) throws IOException {
        CommonSpec commonSpec = new CommonSpec(false, false);
        commonSpec.addOption(new ServerSpecOption("ServerSpec", true));
        commonSpec.addOption(new Option("ProjectName", true));
        commonSpec.addOption(new Option("ProjectRoot", true));
        commonSpec.addOption(new Option("ProjectDescription", false));
        Object object = new Object();
        commonSpec.addOption(new Option("ProjectKeyword", false, object));
        commonSpec.addOption(new Option("ProjectKeywordFile", false, object));
        commonSpec.addOption(new ExcludeOption("FolderExclude", false));
        Object object2 = new Object();
        commonSpec.addOption(new Option("FolderExcludeList", false, object2));
        commonSpec.addOption(new Option("FolderExcludeFile", false, object2));
        commonSpec.removeOption("Project");
        commonSpec.removeOption("CaseSensitiveFolders");
        commonSpec.removeViewConfigOptions();
        commonSpec.removeOption("Rootpath");
        commonSpec.removeOption("Folderpath");
        commonSpec.removeOption("StatusFilter");
        this.setSpec(commonSpec);
        return this.runCommand(stringArray);
    }

    void processLocalFile(Folder folder, String string) throws IOException {
        Assert.internalError("AddProject.processLocalFile()");
    }

    void processOneFile(Folder folder, File file) throws IOException {
        Assert.internalError("AddProject.processOneFile()");
    }

    void processNoFiles() throws IOException {
        Assert.internalError("AddProject.processNoFile()");
    }

    protected void preOperation() throws IOException {
        this.m_folderExcludeList = this.getFolderExcludeList();
    }

    protected int runCommandImpl(String[] stringArray) throws IOException {
        try {
            boolean bl = this.parseArguments(stringArray);
            if (this.showLogo()) {
                CommonCommand.printStartupMsg();
            }
            if (this.showHelp()) {
                this.showUsage();
                return 0;
            }
            if (this.showNetMonitor()) {
                NetMonitor.on();
            }
            if (!bl) {
                this.reportBadOptions(this.getSpec().errorMessage());
                return 1;
            }
            this.cacheUnusedUserFileList();
            this._ProjectSpecifier = new StarTeamURL(this.getServerSpec());
            this.resolveUserName();
            this.resolvePassword();
            boolean bl2 = this.openServer();
            if (!bl2) {
                this.confirm(Res.formatKey(ResIDs.UNABLE_TO_CONNECT_ERROR_MSG, new Object[]{this.getHostName(), new Integer(this.getPort())}), null);
                return 1;
            }
            this.getServer().logOn(this.getUserName(), this.getPassword());
            this.preOperation();
            this.addProject();
            return 0;
        }
        catch (Throwable throwable) {
            this.reportError(throwable);
            NetMonitor.kill();
            return 1;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getKeywordFromFile(String string) throws IOException {
        String string2;
        java.io.File file = new java.io.File(string);
        if (!file.exists()) {
            throw new IOException(Res.formatKey(ResIDs.KEYWORD_FILE_MISSING_ERROR_MSG, new Object[]{string}));
        }
        if (file.isDirectory()) {
            throw new IOException(Res.formatKey(ResIDs.KEYWORD_FILE_IS_DIRECTORY_ERROR_MSG, new Object[]{string}));
        }
        if (!file.canRead()) {
            throw new IOException(Res.formatKey(ResIDs.KEYWORD_FILE_NOT_READABLE_ERROR_MSG, new Object[]{string}));
        }
        StringBuffer stringBuffer = new StringBuffer((int)file.length());
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
            String string3 = bufferedReader.readLine();
            while (string3 != null) {
                stringBuffer.append(string3);
                string3 = bufferedReader.readLine();
            }
            string2 = stringBuffer.toString();
            Object var6_7 = null;
            if (bufferedReader == null) return string2;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (bufferedReader == null) throw throwable;
            bufferedReader.close();
            throw throwable;
        }
        bufferedReader.close();
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getExcludeListFromFile(String string) throws IOException {
        String string2;
        java.io.File file = new java.io.File(string);
        if (!file.exists()) {
            throw new IOException(Res.formatKey(ResIDs.EXCLUDE_FILE_MISSING_ERROR_MSG, new Object[]{string}));
        }
        if (file.isDirectory()) {
            throw new IOException(Res.formatKey(ResIDs.EXCLUDE_FILE_IS_DIRECTORY_ERROR_MSG, new Object[]{string}));
        }
        if (!file.canRead()) {
            throw new IOException(Res.formatKey(ResIDs.EXCLUDE_FILE_NOT_READABLE_ERROR_MSG, new Object[]{string}));
        }
        StringBuffer stringBuffer = new StringBuffer((int)file.length());
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
            String string3 = bufferedReader.readLine();
            while (string3 != null) {
                stringBuffer.append(string3);
                string3 = bufferedReader.readLine();
            }
            string2 = stringBuffer.toString();
            Object var6_7 = null;
            if (bufferedReader == null) return string2;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (bufferedReader == null) throw throwable;
            bufferedReader.close();
            throw throwable;
        }
        bufferedReader.close();
        return string2;
    }

    private void addProject() throws IOException {
        String string = this.getProjectName();
        String string2 = this.getProjectRoot();
        Project project = new Project(this.getServer(), string, string2);
        project.setDescription(this.getProjectDescription());
        project.update();
        boolean bl = false;
        if (this.getIsOptionOn("ProjectKeyword")) {
            project.setExpandKeywords(true);
            project.setKeywordExpansionFileExtensions(this.getKeywordList());
            bl = true;
        }
        if (this.getIsOptionOn("ProjectKeywordFile")) {
            project.setExpandKeywords(true);
            project.setKeywordExpansionFileExtensions(this.getKeywordFromFile(this.getKeywordFile()));
            bl = true;
        }
        if (bl) {
            project.update();
        }
        Folder folder = this.getRootFolder(project);
        bl = false;
        if (this.getIsOptionOn("FolderExclude")) {
            int n = this.getFolderExclude();
            folder.setExcludeFlags(n);
            bl = true;
        }
        if (this.m_folderExcludeList != null) {
            if (folder == null) {
                folder = this.getRootFolder(project);
            }
            folder.setExcludeList(this.m_folderExcludeList);
            bl = true;
        }
        if (bl) {
            folder.update();
        }
        this.message(Res.formatKey(ResIDs.PROJECT_ADDED_MSG, new Object[]{string}));
        if (this.getIsOptionOn("Recurse")) {
            this.processSubFolders(folder);
        }
    }

    private Folder getRootFolder(Project project) {
        return project.getDefaultView().getRootFolder();
    }

    private void processSubFolders(Folder folder) throws IOException {
        String[] stringArray;
        java.io.File file = new java.io.File(folder.getPath());
        this.message(Res.formatKey(ResIDs.FOLDER_INFORMATION_MSG, new Object[]{folder.getName(), folder.getPath()}));
        if (file.isDirectory() && (stringArray = file.list()).length > 0) {
            int n = 0;
            while (n < stringArray.length) {
                java.io.File file2 = new java.io.File(folder.getPath(), stringArray[n]);
                if (file2.isDirectory()) {
                    Folder folder2 = new Folder(folder);
                    folder2.setName(stringArray[n]);
                    folder2.setDefaultPathFragment(stringArray[n]);
                    folder2.update();
                    this.message(Res.formatKey(ResIDs.FOLDER_ADDED_MSG, new Object[]{stringArray[n]}));
                }
                ++n;
            }
            Folder[] folderArray = folder.getSubFolders();
            int n2 = 0;
            while (n2 < folderArray.length) {
                this.processSubFolders(folderArray[n2]);
                ++n2;
            }
        }
    }

    AddProject() {
    }
}

