/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.Project_Cmd_Close;
import com.starbase.starteam.Project_Cmd_Open;
import com.starbase.starteam.Res;
import com.starbase.starteam.ResIDs;
import com.starbase.starteam.Server;
import com.starbase.starteam.View;

class ViewSession {
    private Server m_Server;
    private int m_ConnectID;
    private boolean m_Encrypt;
    private boolean m_Compress;
    private boolean m_Alive = false;

    void init(Server server, View view) {
        if (server.getSession() == null) {
            throw new IllegalStateException(Res.getString(ResIDs.LOGON_REQUIRED));
        }
        Project_Cmd_Open project_Cmd_Open = new Project_Cmd_Open(server, server.getSession().getID(), view.getProject().getID(), view.getViewID(), view.getConfiguration());
        project_Cmd_Open.execute();
        this.setID(project_Cmd_Open.getConnectID());
        this.m_Alive = true;
    }

    boolean isAlive() {
        return this.m_Alive;
    }

    void setAlive(boolean bl) {
        this.m_Alive = bl;
    }

    boolean isCompressionRequired() {
        return this.m_Compress;
    }

    void setCompressionRequired(boolean bl) {
        this.m_Compress = bl;
    }

    boolean isEncryptionRequired() {
        return this.m_Encrypt;
    }

    void setEncryptionRequired(boolean bl) {
        this.m_Encrypt = bl;
    }

    int getID() {
        return this.m_ConnectID;
    }

    void setID(int n) {
        this.m_ConnectID = n;
    }

    Server getServer() {
        return this.m_Server;
    }

    private void setServer(Server server) {
        this.m_Server = server;
    }

    void terminate() {
        this.m_Alive = false;
        Project_Cmd_Close project_Cmd_Close = new Project_Cmd_Close(this.getServer().getSession().getID(), this.getID());
        project_Cmd_Close.execute(this.getServer().useConnection(), this.getServer().getSession().getID(), this.getID(), 0);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(super.toString() + ": ");
        stringBuffer.append("ID=" + this.getID());
        stringBuffer.append(", isEncryptionRequired=" + this.isEncryptionRequired());
        stringBuffer.append(", isCompressionRequired=" + this.isCompressionRequired());
        stringBuffer.append(", isAlive=" + this.isAlive());
        return stringBuffer.toString();
    }

    ViewSession(Server server, View view) {
        this.setServer(server);
        this.init(server, view);
    }

    ViewSession() {
        this.m_ConnectID = 0;
    }
}

