/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.AclEntry;
import com.starbase.starteam.Cacheable;
import com.starbase.starteam.Catalog;
import com.starbase.starteam.CmdGetFilterClassID;
import com.starbase.starteam.CmdGetQueryClassID;
import com.starbase.starteam.CmdRefreshClassInfo;
import com.starbase.starteam.Filter;
import com.starbase.starteam.FilterEvent_Marshaler;
import com.starbase.starteam.FilterListener;
import com.starbase.starteam.Filter_Cache;
import com.starbase.starteam.Filter_CacheRefCollection;
import com.starbase.starteam.Folder;
import com.starbase.starteam.IFilterQueryListener;
import com.starbase.starteam.ISecurableContainer;
import com.starbase.starteam.Item;
import com.starbase.starteam.Item_CacheRefCollection;
import com.starbase.starteam.NamedCacheRef;
import com.starbase.starteam.NoSuchPropertyException;
import com.starbase.starteam.Property;
import com.starbase.starteam.Property_Data;
import com.starbase.starteam.QueryEvent_Marshaler;
import com.starbase.starteam.QueryInfo;
import com.starbase.starteam.QueryInfo_Cache;
import com.starbase.starteam.QueryInfo_CacheRefCollection;
import com.starbase.starteam.QueryListener;
import com.starbase.starteam.Res;
import com.starbase.starteam.ResIDs;
import com.starbase.starteam.SecurityAccess;
import com.starbase.starteam.Server;
import com.starbase.starteam.ServerComponentInfo;
import com.starbase.starteam.TypeEvent_Marshaler;
import com.starbase.starteam.TypeListener;
import com.starbase.starteam.TypeNames;
import com.starbase.starteam.Type_Cache;
import com.starbase.starteam.Type_CacheManager;
import com.starbase.starteam.Type_Data;
import com.starbase.starteam.names.NameUtils;
import com.starbase.starteam.vts.pickle.PropertyInfo2;
import com.starbase.util.Assert;
import com.starbase.util.GUID;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Type
extends NamedCacheRef
implements Cloneable,
ISecurableContainer {
    private static final int SCOPE_SELF = 1;
    private static final int SCOPE_PROPERTIES = 2;
    private static final int SCOPE_FILTERS = 4;
    private static final int SCOPE_QUERIES = 8;
    private static final int SCOPE_CATALOG = 16;
    private static final int SCOPE_DEFAULT = 3;
    private static final int SCOPE_ALL = 65535;
    private static final int SCOPE_CUSTOM = 0x10000000;
    private Server m_server = null;
    private Catalog m_catalog = null;
    private ServerComponentInfo m_componentInfo = null;
    private String m_name = null;
    private int m_filterClassID;
    private boolean m_bFilterClassIDRetrieved = false;
    private int m_queryClassID;
    private boolean m_bQueryClassIDRetrieved = false;
    private Filter_CacheRefCollection m_filters = null;
    private QueryInfo_CacheRefCollection m_queries = null;
    private Hashtable m_properties = new Hashtable();
    private Hashtable m_propertiesUpperCase = new Hashtable();
    private Hashtable m_pids = new Hashtable();
    private FilterEvent_Marshaler m_filterEventMarshaler = null;
    private QueryEvent_Marshaler m_queryEventMarshaler = null;

    Type_Data getData() {
        return (Type_Data)this.getCachedObject();
    }

    private void refreshPropertyMaps() {
        Vector vector = this.getData().getPropertyData();
        int n = 0;
        while (n < vector.size()) {
            Property property = new Property(this, (Property_Data)vector.elementAt(n));
            if (!this.hasPropertyForName(property.getName())) {
                this.addProperty(property);
            } else {
                Property property2 = this.propertyForName(property.getName());
                property2.refreshFrom(property);
            }
            ++n;
        }
    }

    protected void setCachedObject(Cacheable cacheable) {
        super.setCachedObject(cacheable);
        this.refreshPropertyMaps();
    }

    protected String getRefName() {
        return this.getName();
    }

    void setDirty() {
        Type_Cache type_Cache = this.getServer().getServerCacheManager().getTypeCache();
        type_Cache.setObjectDirty(this.getClassID());
    }

    public int pidForIndex(int n) {
        return this.getData().pidForIndex(n);
    }

    int indexForPid(int n) {
        return this.getData().indexForPid(n);
    }

    int indexForName(String string) {
        return this.getData().indexForName(string);
    }

    int getPrimaryDescriptorIndex() {
        return this.getData().getPrimaryDescriptorIndex();
    }

    Enumeration getCachedPropertyNames() {
        return this.getData().getCachedPropertyNames();
    }

    private Type_CacheManager getTypeCacheManager() {
        return this.m_server.getServerCacheManager().getTypeCacheManager(this.getClassID());
    }

    private Filter_CacheRefCollection getFilterCacheRefCollection() {
        if (this.m_filters == null) {
            this.m_filters = new Filter_CacheRefCollection(this.getTypeCacheManager().getFilterCache(), this);
        }
        return this.m_filters;
    }

    private QueryInfo_CacheRefCollection getQueryInfoCacheRefCollection() {
        if (this.m_queries == null) {
            this.m_queries = new QueryInfo_CacheRefCollection(this.getTypeCacheManager().getQueryInfoCache(), (Object)this);
        }
        return this.m_queries;
    }

    void clearMembers() {
        if (this.m_filters != null) {
            this.m_filters.clear();
        }
        this.m_bFilterClassIDRetrieved = false;
        if (this.m_queries != null) {
            this.m_queries.clear();
        }
        this.m_bQueryClassIDRetrieved = false;
        this.m_catalog = null;
    }

    void refreshMembers() {
        if (this.m_filters != null && this.m_filters.isRefreshRequired()) {
            this.m_filters.refresh();
            this.m_bFilterClassIDRetrieved = false;
        }
        if (this.m_queries != null && this.m_queries.isRefreshRequired()) {
            this.m_queries.refresh();
            this.m_bQueryClassIDRetrieved = false;
        }
        if (this.m_catalog != null) {
            this.m_catalog.refresh();
        }
    }

    boolean isRefreshMembersRequired() {
        if (this.m_filters != null && this.m_filters.isRefreshRequired()) {
            return true;
        }
        if (this.m_queries != null && this.m_queries.isRefreshRequired()) {
            return true;
        }
        return this.m_catalog != null && this.m_catalog.isRefreshRequired();
    }

    public void discardFiltersAndQueries() {
        if (this.m_filters != null) {
            this.m_filters.discard();
        }
        if (this.m_queries != null) {
            this.m_queries.discard();
        }
    }

    public Type copy() {
        return this.copy(3);
    }

    private Type copy(int n) {
        try {
            Type type = (Type)this.clone();
            if ((n & 2) != 0) {
                type.m_pids = new Hashtable();
                type.m_properties = new Hashtable();
                type.m_propertiesUpperCase = new Hashtable();
                Property[] propertyArray = this.getProperties();
                int n2 = 0;
                while (n2 < propertyArray.length) {
                    type.addProperty(propertyArray[n2].copy());
                    ++n2;
                }
            }
            if ((n & 4) != 0 || (n & 0x10000000) != 0 && this.m_filters != null && this.m_filters.isPopulated()) {
                type.m_filters = new Filter_CacheRefCollection(this.getFilterCacheRefCollection());
            }
            if ((n & 8) != 0 || (n & 0x10000000) != 0 && this.m_queries != null && this.m_queries.isPopulated()) {
                type.m_queries = new QueryInfo_CacheRefCollection(this.getQueryInfoCacheRefCollection());
            }
            if ((n & 0x10) != 0 || (n & 0x10000000) == 0 || this.m_catalog != null) {
                // empty if block
            }
            return type;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Assert.internalError("Type.copy()");
            return null;
        }
    }

    public boolean isEqualTo(Type type) {
        if (type == null) {
            return false;
        }
        return this.getData().isEqualTo(type.getData());
    }

    public Server getServer() {
        return this.m_server;
    }

    public Catalog getCatalog() {
        if (this.m_catalog == null) {
            this.m_catalog = new Catalog(this.m_server, this, -1);
        }
        return this.m_catalog;
    }

    public String getDisplayName() {
        if (this.m_server.getSupportedFeatures().isServerLocalized()) {
            return this.getData().getDisplayName();
        }
        String string = this.getName();
        return NameUtils.getLocalizedTypeName(this, string);
    }

    public String getName() {
        if (this.m_name == null) {
            this.m_name = this.m_server.getTypeNames().getCanonicalName(this.getData().getDBTableName());
        }
        return this.m_name;
    }

    public String getDBTableName() {
        return this.getData().getDBTableName();
    }

    public int getClassID() {
        return this.getData().getID();
    }

    public String toString() {
        return this.getDisplayName();
    }

    void setComponentInfo(ServerComponentInfo serverComponentInfo) {
        this.m_componentInfo = serverComponentInfo;
    }

    public boolean isComponentType() {
        return this.m_componentInfo != null;
    }

    public boolean isItemType() {
        return this.isComponentType() && !this.getName().equals(this.getServer().getTypeNames().PROJECT);
    }

    public boolean isMPXSupported() {
        TypeNames typeNames = this.getServer().getTypeNames();
        String string = this.getName();
        if (this.isItemType()) {
            return !string.equals("Audit");
        }
        if (string.equals("Folder")) {
            return true;
        }
        if (string.equals("Label")) {
            return true;
        }
        if (string.equals("Project")) {
            return true;
        }
        if (string.equals("Type")) {
            return true;
        }
        if (string.equals("User")) {
            return true;
        }
        if (string.equals("User")) {
            return true;
        }
        return string.equals("View");
    }

    public GUID getComponentGUID() {
        if (this.m_componentInfo != null) {
            return this.m_componentInfo.getID();
        }
        return null;
    }

    void addProperty(Property property) {
        String string = property.getName();
        if (this.hasPropertyForName(string)) {
            Assert.internalError("Type.addProperty(), name=" + string);
        }
        this.m_pids.put(new Integer(property.getID()), property);
        this.m_properties.put(string, property);
        this.m_propertiesUpperCase.put(string.toUpperCase(), property);
    }

    private Property _propertyForName(String string) {
        Property property = null;
        property = (Property)this.m_properties.get(string);
        if (property == null) {
            return (Property)this.m_propertiesUpperCase.get(string.toUpperCase());
        }
        return property;
    }

    public Property propertyForName(String string) {
        Property property = this._propertyForName(string);
        if (property == null) {
            throw new NoSuchPropertyException(this.getName(), string);
        }
        return property;
    }

    public boolean hasPropertyForName(String string) {
        return this._propertyForName(string) != null;
    }

    public Property propertyForPID(int n) {
        Property property = (Property)this.m_pids.get(new Integer(n));
        if (property == null) {
            throw new NoSuchPropertyException(this.getName(), n);
        }
        return property;
    }

    public boolean hasPropertyForPID(int n) {
        Property property = (Property)this.m_pids.get(new Integer(n));
        return property != null;
    }

    public Property[] propertiesForNames(String[] stringArray) {
        Property[] propertyArray = null;
        if (stringArray == null) {
            return this.getProperties();
        }
        propertyArray = new Property[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            propertyArray[n] = this.propertyForName(stringArray[n]);
            ++n;
        }
        return propertyArray;
    }

    public int getPropertyCount() {
        return this.m_properties.size();
    }

    int getCacheablePropertyCount() {
        return this.getData().getCacheablePropertyCount();
    }

    public Property[] getProperties() {
        Property[] propertyArray = new Property[this.m_properties.size()];
        Enumeration enumeration = this.m_properties.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            propertyArray[n++] = (Property)enumeration.nextElement();
        }
        return propertyArray;
    }

    Property[] getDescriptors() {
        Vector<Property> vector = new Vector<Property>();
        Property[] propertyArray = this.getProperties();
        int n = 0;
        while (n < propertyArray.length) {
            if (propertyArray[n].isPrimaryDescriptor()) {
                vector.insertElementAt(propertyArray[n], 0);
            } else if (propertyArray[n].isDescriptor()) {
                vector.addElement(propertyArray[n]);
            }
            ++n;
        }
        Object[] objectArray = new Property[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    int getFilterClassID() {
        if (!this.m_bFilterClassIDRetrieved) {
            Server server = this.getServer();
            GUID gUID = server.getComponentGUID(this);
            if (gUID == null || server.getComponentID(gUID) == 0) {
                this.m_filterClassID = -1;
            } else {
                CmdGetFilterClassID cmdGetFilterClassID = new CmdGetFilterClassID(server, this.getClassID());
                cmdGetFilterClassID.execute();
                this.m_filterClassID = cmdGetFilterClassID.m_classID;
            }
            this.m_bFilterClassIDRetrieved = true;
        }
        return this.m_filterClassID;
    }

    int getQueryClassID() {
        if (!this.m_bQueryClassIDRetrieved) {
            Server server = this.getServer();
            GUID gUID = server.getComponentGUID(this);
            if (gUID == null || server.getComponentID(gUID) == 0) {
                this.m_queryClassID = -1;
            } else {
                CmdGetQueryClassID cmdGetQueryClassID = new CmdGetQueryClassID(server, this.getClassID());
                cmdGetQueryClassID.execute();
                this.m_queryClassID = cmdGetQueryClassID.m_classID;
            }
            this.m_bQueryClassIDRetrieved = true;
        }
        return this.m_queryClassID;
    }

    public void refreshFiltersAndQueries() {
        this.getQueryInfoCacheRefCollection().refresh();
        this.getFilterCacheRefCollection().refresh();
    }

    Filter_Cache getFilterCache() {
        return this.getTypeCacheManager().getFilterCache();
    }

    QueryInfo_Cache getQueryInfoCache() {
        return this.getTypeCacheManager().getQueryInfoCache();
    }

    public Filter[] getFilters() {
        this.getFilterCacheRefCollection().populate();
        Vector vector = this.getFilterCacheRefCollection().getRefs();
        Filter[] filterArray = new Filter[vector.size()];
        Enumeration enumeration = vector.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            filterArray[n++] = (Filter)enumeration.nextElement();
        }
        return filterArray;
    }

    public boolean hasFilterForName(String string) {
        Filter filter = null;
        try {
            filter = this.getFilterForName(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        return true;
    }

    public Filter getFilterForName(String string) {
        this.getFilterCacheRefCollection().populate();
        Filter filter = (Filter)this.getFilterCacheRefCollection().getByName(string);
        if (filter != null) {
            return filter;
        }
        throw new IllegalArgumentException(Res.formatKey(ResIDs.NO_SUCH_FILTER_NAME_FMT, new Object[]{string}));
    }

    public boolean hasFilterForID(int n) {
        Filter filter = null;
        try {
            filter = this.getFilterForID(n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        return true;
    }

    public Filter getFilterForID(int n) {
        this.getFilterCacheRefCollection().populate();
        Filter filter = (Filter)this.getFilterCacheRefCollection().getByID(n);
        if (filter != null) {
            return filter;
        }
        throw new IllegalArgumentException(Res.formatKey(ResIDs.NO_SUCH_FILTER_ID_FMT, new Object[]{new Integer(n)}));
    }

    public QueryInfo[] getQueries() {
        this.getQueryInfoCacheRefCollection().populate();
        Vector vector = this.getQueryInfoCacheRefCollection().getRefs();
        QueryInfo[] queryInfoArray = new QueryInfo[vector.size()];
        Enumeration enumeration = vector.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            queryInfoArray[n++] = (QueryInfo)enumeration.nextElement();
        }
        return queryInfoArray;
    }

    public boolean hasQueryForName(String string) {
        QueryInfo queryInfo = null;
        try {
            queryInfo = this.getQueryForName(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        return true;
    }

    public QueryInfo getQueryForName(String string) {
        this.getQueryInfoCacheRefCollection().populate();
        QueryInfo queryInfo = (QueryInfo)this.getQueryInfoCacheRefCollection().getByName(string);
        if (queryInfo != null) {
            return queryInfo;
        }
        throw new IllegalArgumentException(Res.formatKey(ResIDs.NO_SUCH_QUERY_NAME_FMT, new Object[]{string}));
    }

    public boolean hasQueryForID(int n) {
        QueryInfo queryInfo = null;
        try {
            queryInfo = this.getQueryForID(n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        return true;
    }

    public QueryInfo getQueryForID(int n) {
        this.getQueryInfoCacheRefCollection().populate();
        QueryInfo queryInfo = (QueryInfo)this.getQueryInfoCacheRefCollection().getByID(n);
        if (queryInfo != null) {
            return queryInfo;
        }
        throw new IllegalArgumentException(Res.formatKey(ResIDs.NO_SUCH_QUERY_ID_FMT, new Object[]{new Integer(n)}));
    }

    public AclEntry[] getACL() {
        return SecurityAccess.getComponentACL(this);
    }

    public AclEntry[] getComponentACL() {
        return SecurityAccess.getComponentACL(this);
    }

    public void setACL(AclEntry[] aclEntryArray) {
        SecurityAccess.setComponentACL(this, true, aclEntryArray);
    }

    public void setComponentACL(AclEntry[] aclEntryArray) {
        SecurityAccess.setComponentACL(this, true, aclEntryArray);
    }

    public AclEntry[] getFilterACL() {
        return SecurityAccess.getComponentLevelACL(this, this.getFilterClassID());
    }

    public void setFilterACL(AclEntry[] aclEntryArray) {
        SecurityAccess.setComponentLevelACL(this, this.getFilterClassID(), true, aclEntryArray);
    }

    public AclEntry[] getQueryACL() {
        return SecurityAccess.getComponentLevelACL(this, this.getQueryClassID());
    }

    public void setQueryACL(AclEntry[] aclEntryArray) {
        SecurityAccess.setComponentLevelACL(this, this.getQueryClassID(), true, aclEntryArray);
    }

    public boolean isRefreshFiltersAndQueriesRequired() {
        return this.getFilterCacheRefCollection().isRefreshRequired() || this.getQueryInfoCacheRefCollection().isRefreshRequired();
    }

    Item[] getItems(Folder folder) {
        String string = this.getName();
        Item_CacheRefCollection item_CacheRefCollection = folder.getItemCollection(string);
        item_CacheRefCollection.populateItems();
        return item_CacheRefCollection.toArray();
    }

    void populate(Folder folder, String[] stringArray, int n) {
        String string = this.getName();
        Vector vector = folder.getItemCollections(string, n);
        Item_CacheRefCollection.populate(vector, stringArray);
    }

    boolean isRefreshRequired(Folder folder, String[] stringArray, int n) {
        String string = this.getName();
        Vector vector = folder.getItemCollections(string, n);
        return Item_CacheRefCollection.isRefreshRequired(vector, stringArray);
    }

    void refresh(Folder folder, String[] stringArray, int n) {
        String string = this.getName();
        Vector vector = folder.getItemCollections(string, n);
        Item_CacheRefCollection.refresh(vector, stringArray);
    }

    void discard(Folder folder, int n) {
        String string = this.getName();
        Vector vector = new Vector();
        Folder.flattenFolderTree(folder, vector, n);
        int n2 = 0;
        while (n2 < vector.size()) {
            Folder folder2 = (Folder)vector.elementAt(n2);
            folder2.discardItems(string);
            ++n2;
        }
        folder.getView().clearItemsForType(string);
    }

    public void addTypeListener(TypeListener typeListener) {
        this.getTypeEventMarshaler().addListener(typeListener, this);
    }

    public void removeTypeListener(TypeListener typeListener) {
        this.getTypeEventMarshaler().removeListener(typeListener, this);
    }

    TypeEvent_Marshaler getTypeEventMarshaler() {
        return this.getServer().getTypeEventMarshaler();
    }

    public void addFilterQueryListener(IFilterQueryListener iFilterQueryListener) {
        boolean bl = false;
        if (iFilterQueryListener instanceof FilterListener) {
            this.getFilterEventMarshaler().addListener((FilterListener)iFilterQueryListener);
            bl = true;
        }
        if (iFilterQueryListener instanceof QueryListener) {
            this.getQueryEventMarshaler().addListener((QueryListener)iFilterQueryListener);
            bl = true;
        }
        if (!bl) {
            String string = Res.formatKey(ResIDs.LIST_FMT, new Object[]{"FilterListener", "QueryListener"});
            throw new IllegalArgumentException(Res.formatKey(ResIDs.UNRECOGNIZED_LISTENER_FMT, new Object[]{string}));
        }
    }

    public void removeFilterQueryListener(IFilterQueryListener iFilterQueryListener) {
        if (iFilterQueryListener instanceof FilterListener) {
            this.getFilterEventMarshaler().removeListener((FilterListener)iFilterQueryListener);
        }
        if (iFilterQueryListener instanceof QueryListener) {
            this.getQueryEventMarshaler().removeListener((QueryListener)iFilterQueryListener);
        }
    }

    FilterEvent_Marshaler getFilterEventMarshaler() {
        if (this.m_filterEventMarshaler == null) {
            Type type = this;
            synchronized (type) {
                if (this.m_filterEventMarshaler == null) {
                    int n = this.getClassID();
                    TypeEvent_Marshaler typeEvent_Marshaler = this.getServer().getTypeEventMarshaler();
                    Type type2 = typeEvent_Marshaler.getType(n);
                    this.m_filterEventMarshaler = this != type2 ? type2.getFilterEventMarshaler() : new FilterEvent_Marshaler(this);
                }
            }
        }
        return this.m_filterEventMarshaler;
    }

    QueryEvent_Marshaler getQueryEventMarshaler() {
        if (this.m_queryEventMarshaler == null) {
            Type type = this;
            synchronized (type) {
                if (this.m_queryEventMarshaler == null) {
                    int n = this.getClassID();
                    TypeEvent_Marshaler typeEvent_Marshaler = this.getServer().getTypeEventMarshaler();
                    Type type2 = typeEvent_Marshaler.getType(n);
                    this.m_queryEventMarshaler = this != type2 ? type2.getQueryEventMarshaler() : new QueryEvent_Marshaler(this);
                }
            }
        }
        return this.m_queryEventMarshaler;
    }

    private void cacheTranslations() {
        Server server = this.getServer();
        CmdRefreshClassInfo cmdRefreshClassInfo = new CmdRefreshClassInfo(3);
        cmdRefreshClassInfo.execute(server.useConnection(), server.getSession().getID(), 0, this.getClassID());
        PropertyInfo2[] propertyInfo2Array = cmdRefreshClassInfo.getProperties();
        Property[] propertyArray = this.getProperties();
        int n = 0;
        while (n < propertyArray.length) {
            Property property = propertyArray[n];
            PropertyInfo2 propertyInfo2 = this.findInfo(property.getID(), propertyInfo2Array);
            if (propertyInfo2 != null) {
                property.getData().setData(propertyInfo2);
            }
            ++n;
        }
        this.getData().setTranslationCache(cmdRefreshClassInfo.getTranslationCache());
    }

    private PropertyInfo2 findInfo(int n, PropertyInfo2[] propertyInfo2Array) {
        int n2 = 0;
        while (n2 < propertyInfo2Array.length) {
            PropertyInfo2 propertyInfo2 = propertyInfo2Array[n2];
            if (n == propertyInfo2.m_ID) {
                return propertyInfo2;
            }
            ++n2;
        }
        return null;
    }

    void cacheTranslationsIfNeeded(Property property) {
        if (this.getServer().getSupportedFeatures().hasCustomTranslations() && !property.hasCachedTranslations()) {
            this.cacheTranslations();
        }
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        String string = System.getProperty("line.separator");
        stringBuffer.append(this.getDisplayName());
        stringBuffer.append(", ");
        stringBuffer.append(this.getDBTableName());
        stringBuffer.append(", ");
        stringBuffer.append(this.getClassID());
        stringBuffer.append(string);
        stringBuffer.append("--------------------------------------");
        stringBuffer.append(string);
        Enumeration enumeration = this.m_properties.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(((Property)enumeration.nextElement()).toDebugString());
        }
        return stringBuffer.toString();
    }

    public ISecurableContainer getParentContainer() {
        return null;
    }

    public AclEntry[] getContainerLevelACL(String string) {
        if (this.getName().compareTo(string) == 0) {
            return this.getComponentACL();
        }
        throw new IllegalArgumentException(Res.formatKey(ResIDs.INVALID_CONTAINER_TYPE_FMT, new Object[]{new String(string)}));
    }

    public void setContainerLevelACL(AclEntry[] aclEntryArray, String string) {
        if (this.getName().compareTo(string) == 0) {
            this.setComponentACL(aclEntryArray);
            return;
        }
        throw new IllegalArgumentException(Res.formatKey(ResIDs.INVALID_CONTAINER_TYPE_FMT, new Object[]{new String(string)}));
    }

    public boolean hasPermission(int n) {
        return this.isItemType() ? SecurityAccess.componentLevelAccessTest(this, n) : false;
    }

    public boolean hasPermission(int n, String string) {
        if (this.getName().compareTo(string) == 0) {
            return this.hasPermission(n);
        }
        throw new IllegalArgumentException(Res.formatKey(ResIDs.INVALID_CONTAINER_TYPE_FMT, new Object[]{new String(string)}));
    }

    Type(Server server, Type_Data type_Data) {
        super(type_Data);
        this.m_server = server;
        this.refreshPropertyMaps();
    }
}

