/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.GroupSortInfo;
import com.starbase.starteam.ItemList;
import com.starbase.starteam.Property;
import com.starbase.starteam.PropertySortCollection;

class TextCollection
extends PropertySortCollection {
    private String[] m_dest;
    private String[] m_scratchpad;

    public void swap(int n, int n2) {
        String string = this.m_dest[n];
        this.m_dest[n] = this.m_dest[n2];
        this.m_dest[n2] = string;
    }

    public void copySequence(int n, int n2) {
        System.arraycopy(this.m_scratchpad, n, this.m_dest, n, n2);
    }

    public void setFromScratchpad(int n, int n2) {
        this.m_dest[n2] = this.m_scratchpad[n];
    }

    public void saveToScratchpad(int n, int n2) {
        this.m_scratchpad[n2] = this.m_dest[n];
    }

    public int compareScratchpad(int n, int n2) {
        if (this.m_bAscending) {
            return this.m_scratchpad[n].compareTo(this.m_scratchpad[n2]);
        }
        return this.m_scratchpad[n2].compareTo(this.m_scratchpad[n]);
    }

    public int compare(int n, int n2) {
        if (this.m_bAscending) {
            return this.m_dest[n].compareTo(this.m_dest[n2]);
        }
        return this.m_dest[n2].compareTo(this.m_dest[n]);
    }

    public TextCollection(ItemList itemList, GroupSortInfo groupSortInfo, Property property) {
        super(itemList, groupSortInfo, property);
        this.m_bAscending = groupSortInfo.isAscending();
        int n = itemList.size();
        this.m_dest = new String[n];
        this.m_scratchpad = new String[n];
        int n2 = 0;
        while (n2 < n) {
            String string = itemList.getAt(n2).getDisplayValue(property);
            if (!groupSortInfo.isCaseSensitive()) {
                string = string.toLowerCase();
            }
            this.m_dest[n2] = string;
            this.m_scratchpad[n2] = string;
            ++n2;
        }
    }
}

