/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.Folder;
import com.starbase.starteam.Item;
import com.starbase.starteam.NoSuchPropertyException;
import com.starbase.starteam.Property;
import com.starbase.starteam.PropertyNames;
import com.starbase.starteam.Query;
import com.starbase.starteam.Res;
import com.starbase.starteam.ResIDs;
import com.starbase.starteam.Server;
import com.starbase.starteam.TaskDependency;
import com.starbase.starteam.Type;
import com.starbase.starteam.User;
import com.starbase.starteam.View;
import com.starbase.starteam.WorkRecord;
import com.starbase.util.Assert;
import com.starbase.util.OLEDate;
import java.util.Enumeration;
import java.util.Vector;

public class Task
extends Item {
    private Vector m_records = new Vector();
    private Vector m_newRecords = new Vector();
    private Vector m_deletedRecords = new Vector();
    private Vector m_predecessorLinks = new Vector();
    private Vector m_successorLinks = new Vector();
    private Vector m_newPredecessorLinks = new Vector();
    private Vector m_deletedPredecessorLinks = new Vector();
    private boolean m_cachedWorkRecords = false;
    private boolean m_cachedDependencyLinks = false;

    public Object put(String string, Object object) throws NoSuchPropertyException, ClassCastException {
        PropertyNames propertyNames = this.getPropertyNames();
        if (string.equals(propertyNames.TASK_IS_REPLICATED)) {
            boolean bl = this.isReplicated();
            Integer n = (Integer)this.getType().propertyForName(string).coerce(object);
            this.setReplicated(n != 0);
            return new Integer(bl ? 1 : 0);
        }
        if (string.equals(propertyNames.TASK_ORIGIN)) {
            int n = this.getOrigin();
            Integer n2 = (Integer)this.getType().propertyForName(string).coerce(object);
            this.setOrigin(n2);
            return new Integer(n);
        }
        return super.put(string, object);
    }

    protected void validateForPut(String string, Property property) throws ClassCastException, NoSuchPropertyException {
        if (!string.equals(this.getPropertyNames().TASK_ORIGIN)) {
            super.validateForPut(string, property);
        }
    }

    public double getEstimatedHoursVariance() {
        return this.getDouble(this.getPropertyNames().TASK_ESTIMATED_HOURS_VARIANCE);
    }

    public int getEstimatedStartVariance() {
        return this.getInt(this.getPropertyNames().TASK_ESTIMATED_START_VARIANCE);
    }

    public int getEstimatedFinishVariance() {
        return this.getInt(this.getPropertyNames().TASK_ESTIMATED_FINISH_VARIANCE);
    }

    public int getParentID() {
        return this.getInt(this.getPropertyNames().TASK_PARENT_ID);
    }

    void setParentID(int n) {
        this.put(this.getPropertyNames().TASK_PARENT_ID, new Integer(n));
    }

    public double getDuration() {
        return this.getDouble(this.getPropertyNames().TASK_DURATION);
    }

    public void setDuration(double d) {
        this.put(this.getPropertyNames().TASK_DURATION, new Double(d));
    }

    public int getNumber() {
        return this.getInt(this.getPropertyNames().TASK_NUMBER);
    }

    public int getNeedsAttention() {
        return this.getInt(this.getPropertyNames().TASK_NEEDS_ATTENTION);
    }

    public void setNeedsAttention(int n) {
        this.put(this.getPropertyNames().TASK_NEEDS_ATTENTION, new Integer(n));
    }

    public int[] getPossibleNeedsAttention() {
        return this.getPossibleValues(this.getPropertyNames().TASK_NEEDS_ATTENTION);
    }

    public String getNeedsAttentionDisplayName(int n) {
        return this.getEnumDisplayName(this.getPropertyNames().TASK_NEEDS_ATTENTION, n);
    }

    public String getName() {
        return this.getString(this.getPropertyNames().TASK_NAME);
    }

    public void setName(String string) {
        this.put(this.getPropertyNames().TASK_NAME, string);
    }

    public String getAttentionNotes() {
        return this.getString(this.getPropertyNames().TASK_ATTENTION_NOTES);
    }

    public void setAttentionNotes(String string) {
        this.put(this.getPropertyNames().TASK_ATTENTION_NOTES, string);
    }

    public String getNotes() {
        return this.getString(this.getPropertyNames().TASK_NOTES);
    }

    public void setNotes(String string) {
        this.put(this.getPropertyNames().TASK_NOTES, string);
    }

    public int getPercentComplete() {
        return this.getInt(this.getPropertyNames().TASK_PERCENT_COMPLETE);
    }

    public void setPercentComplete(int n) {
        this.put(this.getPropertyNames().TASK_PERCENT_COMPLETE, new Integer(n));
    }

    public int getMilestone() {
        return this.getInt(this.getPropertyNames().TASK_MILESTONE);
    }

    public void setMilestone(int n) {
        this.put(this.getPropertyNames().TASK_MILESTONE, new Integer(n));
    }

    public int[] getPossibleMilestone() {
        return this.getPossibleValues(this.getPropertyNames().TASK_MILESTONE);
    }

    public String getMilestoneDisplayName(int n) {
        return this.getEnumDisplayName(this.getPropertyNames().TASK_MILESTONE, n);
    }

    public int getTaskType() {
        return this.getInt(this.getPropertyNames().TASK_TYPE);
    }

    public int[] getPossibleTaskType() {
        return this.getPossibleValues(this.getPropertyNames().TASK_TYPE);
    }

    public String getTaskTypeDisplayName(int n) {
        return this.getEnumDisplayName(this.getPropertyNames().TASK_TYPE, n);
    }

    public int getPriority() {
        return this.getInt(this.getPropertyNames().TASK_PRIORITY);
    }

    public void setPriority(int n) {
        this.put(this.getPropertyNames().TASK_PRIORITY, new Integer(n));
    }

    public int[] getPossiblePriority() {
        return this.getPossibleValues(this.getPropertyNames().TASK_PRIORITY);
    }

    public String getPriorityDisplayName(int n) {
        return this.getEnumDisplayName(this.getPropertyNames().TASK_PRIORITY, n);
    }

    public int getConstraintType() {
        return this.getInt(this.getPropertyNames().TASK_CONSTRAINT_TYPE);
    }

    public int[] getPossibleConstraintType() {
        return this.getPossibleValues(this.getPropertyNames().TASK_CONSTRAINT_TYPE);
    }

    public String getConstraintTypeDisplayName(int n) {
        return this.getEnumDisplayName(this.getPropertyNames().TASK_CONSTRAINT_TYPE, n);
    }

    public OLEDate getConstraintDate() {
        return this.getOLEDate(this.getPropertyNames().TASK_CONSTRAINT_DATE);
    }

    public int getResponsibility() {
        return this.getInt(this.getPropertyNames().TASK_RESPONSIBILITY);
    }

    public void setResponsibility(int n) {
        this.put(this.getPropertyNames().TASK_RESPONSIBILITY, new Integer(n));
    }

    public String getGUID() {
        return this.getString(this.getPropertyNames().TASK_GUID);
    }

    public double getEstimatedHours() {
        return this.getDouble(this.getPropertyNames().TASK_ESTIMATED_HOURS);
    }

    public int getUniqueID() {
        return this.getInt(this.getPropertyNames().TASK_UNIQUE_ID);
    }

    public OLEDate getEstimatedStart() {
        return this.getOLEDate(this.getPropertyNames().TASK_ESTIMATED_START);
    }

    public void setEstimatedStart(OLEDate oLEDate) {
        this.put(this.getPropertyNames().TASK_ESTIMATED_START, oLEDate);
    }

    public String getWBSCode() {
        return this.getString(this.getPropertyNames().TASK_WBS_CODE);
    }

    public OLEDate getEstimatedFinish() {
        return this.getOLEDate(this.getPropertyNames().TASK_ESTIMATED_FINISH);
    }

    public void setEstimatedFinish(OLEDate oLEDate) {
        this.put(this.getPropertyNames().TASK_ESTIMATED_FINISH, oLEDate);
    }

    public String getMSProjectFileName() {
        return this.getString(this.getPropertyNames().TASK_MSPROJECT_FILENAME);
    }

    public double getActualHours() {
        return this.getDouble(this.getPropertyNames().TASK_ACTUAL_HOURS);
    }

    public OLEDate getMSProjectLastUpdate() {
        return this.getOLEDate(this.getPropertyNames().TASK_MSPROJECT_LAST_UPDATE);
    }

    public OLEDate getActualStart() {
        return this.getOLEDate(this.getPropertyNames().TASK_ACTUAL_START);
    }

    public OLEDate getActualFinish() {
        return this.getOLEDate(this.getPropertyNames().TASK_ACTUAL_FINISH);
    }

    public int getResourceCount() {
        return this.getInt(this.getPropertyNames().TASK_RESOURCE_COUNT);
    }

    public int[] getResources() {
        return this.getIntArray(this.getPropertyNames().TASK_RESOURCE_COUNT, this.getPropertyNames().TASK_RESOURCE_IDS);
    }

    public int getChildrenCount() {
        this.verifyNotDisembodied();
        if (this.getServer().getRevisionLevel() >= 74) {
            int n = this.getObjectID();
            if (n == -1) {
                return 0;
            }
            int n2 = 0;
            Item[] itemArray = this.getParentFolder().getItems(this.getTypeNames().TASK);
            int n3 = 0;
            while (n3 < itemArray.length) {
                Task task = (Task)itemArray[n3];
                int n4 = task.getParentID();
                if (n4 == n) {
                    ++n2;
                }
                ++n3;
            }
            return n2;
        }
        return this.getInt(this.getPropertyNames().TASK_CHILDREN_COUNT);
    }

    public int getWorkRecordCount() {
        return this.getInt(this.getPropertyNames().TASK_WORKRECORD_COUNT);
    }

    public String[] getResourceNames() {
        int[] nArray = this.getResources();
        String[] stringArray = new String[nArray.length];
        User[] userArray = this.getServer().getUsers();
        int n = 0;
        while (n < nArray.length) {
            int n2 = 0;
            while (n2 < userArray.length) {
                if (userArray[n2].getID() == nArray[n]) {
                    stringArray[n] = userArray[n2].getName();
                    break;
                }
                ++n2;
            }
            ++n;
        }
        return stringArray;
    }

    public int getIsMyTask() {
        if (this.getServer().getRevisionLevel() >= 72) {
            int[] nArray = this.getResources();
            int n = this.getServer().getSession().getUserID();
            int n2 = 0;
            while (n2 < nArray.length) {
                if (nArray[n2] == n) {
                    return this.getServer().getPropertyEnums().TASK_IS_MY_TASK_YES;
                }
                ++n2;
            }
            return this.getServer().getPropertyEnums().TASK_IS_MY_TASK_NO;
        }
        return this.getInt(this.getPropertyNames().TASK_IS_MY_TASK);
    }

    public int[] getPossibleIsMyTask() {
        return this.getPossibleValues(this.getPropertyNames().TASK_IS_MY_TASK);
    }

    public String getIsMyTaskDisplayName(int n) {
        return this.getEnumDisplayName(this.getPropertyNames().TASK_IS_MY_TASK, n);
    }

    public int getOrigin() {
        return this.getInt(this.getPropertyNames().TASK_ORIGIN);
    }

    public void setOrigin(int n) {
        String string = this.getPropertyNames().TASK_ORIGIN;
        String string2 = this.getPropertyNames().TASK_GUID;
        String string3 = this.getOriginDisplayName(n);
        if (n == this.getServer().getPropertyEnums().TASK_ORIGIN_MSPROJECT) {
            Object[] objectArray = new Object[]{string, string3, string2};
            throw new IllegalArgumentException(Res.formatKey(ResIDs.MSPROJECT_ORIGIN_FMT, objectArray));
        }
        super.put(string, new Integer(n));
        super.put(string2, new String(""));
    }

    public int[] getPossibleOrigin() {
        return this.getPossibleValues(this.getPropertyNames().TASK_ORIGIN);
    }

    public String getOriginDisplayName(int n) {
        return this.getEnumDisplayName(this.getPropertyNames().TASK_ORIGIN, n);
    }

    public int getStatus() {
        return this.getInt(this.getPropertyNames().TASK_STATUS);
    }

    public void setStatus(int n) {
        this.put(this.getPropertyNames().TASK_STATUS, new Integer(n));
    }

    public int[] getPossibleStatus() {
        return this.getPossibleValues(this.getPropertyNames().TASK_STATUS);
    }

    public String getStatusDisplayName(int n) {
        return this.getEnumDisplayName(this.getPropertyNames().TASK_STATUS, n);
    }

    public OLEDate getDependencyLastUpdate() {
        return this.getOLEDate(this.getPropertyNames().TASK_WORK_DEPENDENCY_LAST_UPDATE);
    }

    public WorkRecord[] getWorkRecords() {
        Object object;
        if (!this.isNew()) {
            this.get(this.getPropertyNames().OBJECT_ID);
            this.get(this.getPropertyNames().MODIFIED_TIME);
        }
        if (!this.m_cachedWorkRecords && !this.isNew()) {
            object = Query.newQueryContainedBy(this.getTypeNames().WORKRECORD, this);
            this.m_records = this.getServer().getItems((Query)object);
            this.m_cachedWorkRecords = true;
        }
        object = new WorkRecord[this.m_records.size()];
        this.m_records.copyInto((Object[])object);
        return object;
    }

    public void addWorkRecord(WorkRecord workRecord) {
        this.m_records.addElement(workRecord);
        this.m_newRecords.addElement(workRecord);
    }

    public void removeWorkRecord(WorkRecord workRecord) {
        if (workRecord == null) {
            Assert.nullArgument("WorkRecord");
        }
        if (!this.m_records.removeElement(workRecord)) {
            throw new IllegalArgumentException(Res.getString(ResIDs.TASK_REMOVEWORKRECORD));
        }
        this.m_deletedRecords.addElement(workRecord);
    }

    public TaskDependency[] getPredecessorLinks() {
        if (!this.m_cachedDependencyLinks) {
            this.fetchDependencies();
        }
        Object[] objectArray = new TaskDependency[this.m_predecessorLinks.size()];
        this.m_predecessorLinks.copyInto(objectArray);
        return objectArray;
    }

    public void addPredecessorLink(int n, int n2, int n3) {
        int n4 = this.getInt(this.getPropertyNames().OBJECT_ID);
        Type type = this.getServer().typeForName(this.getTypeNames().TASKDEPENDENCY);
        TaskDependency taskDependency = new TaskDependency(n, n4, n2, n3, type);
        this.m_predecessorLinks.addElement(taskDependency);
        this.m_newPredecessorLinks.addElement(taskDependency);
    }

    public void removeDependency(TaskDependency taskDependency) {
        if (taskDependency == null) {
            Assert.nullArgument("TaskDependency");
        }
        if (!this.m_predecessorLinks.removeElement(taskDependency) && !this.m_successorLinks.removeElement(taskDependency)) {
            throw new IllegalArgumentException(Res.getString(ResIDs.TASK_REMOVEDEPENDENCY));
        }
        this.m_deletedPredecessorLinks.addElement(taskDependency);
    }

    public TaskDependency[] getSuccessorLinks() {
        if (!this.m_cachedDependencyLinks) {
            this.fetchDependencies();
        }
        Object[] objectArray = new TaskDependency[this.m_successorLinks.size()];
        this.m_successorLinks.copyInto(objectArray);
        return objectArray;
    }

    public void addResource(int n) {
        this.addToIntArray(this.getPropertyNames().TASK_RESOURCE_COUNT, this.getPropertyNames().TASK_RESOURCE_IDS, n);
    }

    public void removeResource(int n) {
        this.removeFromIntArray(this.getPropertyNames().TASK_RESOURCE_COUNT, this.getPropertyNames().TASK_RESOURCE_IDS, n);
    }

    public void update() {
        if (!this.isNew()) {
            this.get(this.getPropertyNames().OBJECT_ID);
            this.get(this.getPropertyNames().MODIFIED_TIME);
        }
        super.update();
        this.m_newRecords = new Vector();
        this.m_deletedRecords = new Vector();
        this.m_newPredecessorLinks = new Vector();
        this.m_deletedPredecessorLinks = new Vector();
    }

    WorkRecord[] getNewWorkRecords() {
        Object[] objectArray = new WorkRecord[this.m_newRecords.size()];
        this.m_newRecords.copyInto(objectArray);
        return objectArray;
    }

    WorkRecord[] getModifiedWorkRecords() {
        Vector<WorkRecord> vector = new Vector<WorkRecord>();
        int n = 0;
        while (n < this.m_records.size()) {
            WorkRecord workRecord = (WorkRecord)this.m_records.elementAt(n);
            if (workRecord.isDirty() && !this.m_newRecords.contains(workRecord)) {
                vector.addElement(workRecord);
            }
            ++n;
        }
        Object[] objectArray = new WorkRecord[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    WorkRecord[] getDeletedWorkRecords() {
        Object[] objectArray = new WorkRecord[this.m_deletedRecords.size()];
        this.m_deletedRecords.copyInto(objectArray);
        return objectArray;
    }

    boolean hasDirtyWorkRecords() {
        return this.getNewWorkRecords().length != 0 || this.getDeletedWorkRecords().length != 0 || this.getModifiedWorkRecords().length != 0;
    }

    TaskDependency[] getNewPredecessorLinks() {
        Object[] objectArray = new TaskDependency[this.m_newPredecessorLinks.size()];
        this.m_newPredecessorLinks.copyInto(objectArray);
        return objectArray;
    }

    TaskDependency[] getModifiedDependencies() {
        TaskDependency taskDependency;
        Vector<TaskDependency> vector = new Vector<TaskDependency>();
        int n = 0;
        while (n < this.m_predecessorLinks.size()) {
            taskDependency = (TaskDependency)this.m_predecessorLinks.elementAt(n);
            if (taskDependency.isDirty()) {
                vector.addElement(taskDependency);
            }
            ++n;
        }
        n = 0;
        while (n < this.m_successorLinks.size()) {
            taskDependency = (TaskDependency)this.m_successorLinks.elementAt(n);
            if (taskDependency.isDirty()) {
                vector.addElement(taskDependency);
            }
            ++n;
        }
        Object[] objectArray = new TaskDependency[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    TaskDependency[] getDeletedPredecessorLinks() {
        Object[] objectArray = new TaskDependency[this.m_deletedPredecessorLinks.size()];
        this.m_deletedPredecessorLinks.copyInto(objectArray);
        return objectArray;
    }

    boolean hasDirtyDependencies() {
        return this.getNewPredecessorLinks().length != 0 || this.getDeletedPredecessorLinks().length != 0 || this.getModifiedDependencies().length != 0;
    }

    private void fetchDependencies() {
        if (!this.isNew()) {
            Query query = Query.newQueryContainedBy(this.getTypeNames().TASKDEPENDENCY, this);
            Vector vector = this.getServer().getItems(query);
            int n = this.getInt(this.getPropertyNames().OBJECT_ID);
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                TaskDependency taskDependency = (TaskDependency)enumeration.nextElement();
                if (taskDependency.getTaskID() == n) {
                    this.m_predecessorLinks.addElement(taskDependency);
                    continue;
                }
                this.m_successorLinks.addElement(taskDependency);
            }
        }
        this.m_cachedDependencyLinks = true;
    }

    public void discard() {
        this.m_records = new Vector();
        this.m_newRecords = new Vector();
        this.m_deletedRecords = new Vector();
        this.m_predecessorLinks = new Vector();
        this.m_successorLinks = new Vector();
        this.m_newPredecessorLinks = new Vector();
        this.m_deletedPredecessorLinks = new Vector();
        this.m_cachedDependencyLinks = false;
        this.m_cachedWorkRecords = false;
        super.discard();
    }

    public boolean isDirty() {
        return super.isDirty() || this.hasDirtyWorkRecords() || this.hasDirtyDependencies();
    }

    public boolean isReplicated() {
        return this.getOrigin() == this.getServer().getPropertyEnums().TASK_ORIGIN_MSPROJECT;
    }

    public void setReplicated(boolean bl) {
        this.setOrigin(bl ? this.getServer().getPropertyEnums().TASK_ORIGIN_MSPROJECT : this.getServer().getPropertyEnums().TASK_ORIGIN_STARTEAM);
    }

    Task(Server server, View view) {
        super(server.getTypeNames().TASK, server, view);
    }

    Task(Server server, View view, int n) {
        super(server.getTypeNames().TASK, server, view, n);
    }

    public Task(Folder folder) {
        super(folder.getTypeNames().TASK, folder.getServer(), folder.getView());
        this.setParentFolder(folder);
    }

    public Task(Task task) {
        this(task.getParentFolder());
        this.setParentID(task.getItemID());
    }
}

