/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import System.Exception;
import com.starbase.starteam.BuildNumber;
import com.starbase.starteam.FileBasedStatusManager;
import com.starbase.starteam.FileSyncInfo;
import com.starbase.starteam.Res;
import com.starbase.starteam.ResIDs;
import com.starbase.starteam.SDKRuntimeException;
import com.starbase.starteam.SimpleSyncRecord;
import com.starbase.util.Assert;
import com.starbase.util.BaseFileUtils;
import com.starbase.util.MD5;
import com.starbase.util.UTF8;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Hashtable;

class SyncDB {
    private static final int MAGIC_COOKIE = 1224337155;
    private static final String DIR_NAME = ".sbas";
    private static final String DB_NAME = "Sync";
    private static final String LOCK_NAME = "SyncLock";
    private long localtime = -1L;
    private long localsize = -1L;
    private String path = null;
    private String creator = null;
    private String origpath = null;
    private Hashtable records;
    private File syncfile;
    private File lockfile;
    private FileBasedStatusManager statusmanager;
    private Lock currentLock = null;
    private Hashtable m_recordIndices = new Hashtable();
    private Hashtable m_guidCache = new Hashtable();
    private int m_endPosition = -1;
    private int m_counterIndex = -1;
    private int m_counter = -1;

    static String makeSubDirName(byte[] byArray) {
        int n = (byArray[0] & 0xFF) * 16 + (byArray[1] & 0xC0) / 16;
        if (n == 0) {
            return "000";
        }
        StringBuffer stringBuffer = new StringBuffer(3);
        if (n < 256) {
            stringBuffer.append("0");
        }
        if (n < 16) {
            stringBuffer.append("0");
        }
        stringBuffer.append(Integer.toHexString(n));
        return stringBuffer.toString();
    }

    static String byteString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < byArray.length) {
            int n2 = byArray[n] & 0xFF;
            String string = Integer.toHexString(n2);
            if (n2 < 16) {
                stringBuffer.append("0");
            }
            stringBuffer.append(string);
            ++n;
        }
        return stringBuffer.toString();
    }

    public String getPath() {
        return this.path;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getSourcePath() {
        return this.origpath;
    }

    public void refresh() throws IOException {
        if (this.isSyncModified()) {
            this.load();
        }
    }

    private boolean isSyncModified() {
        long l = this.syncfile.lastModified();
        long l2 = this.syncfile.length();
        boolean bl = this.localtime != l || this.localsize != l2;
        return bl;
    }

    public int size() {
        return this.records.size();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Lock obtainLock() throws IOException {
        SyncDB syncDB = this;
        synchronized (syncDB) {
            if (this.currentLock != null) {
                return this.currentLock;
            }
            boolean bl = this.lockfile.delete();
            if (!bl) {
                if (!this.syncfile.exists()) {
                    if (!this.createEmptySyncFile()) {
                        return null;
                    }
                } else {
                    long l;
                    long l2 = l = System.currentTimeMillis();
                    while ((l2 = System.currentTimeMillis()) - l <= 2000L && !(bl = this.lockfile.delete())) {
                    }
                    this.localtime = 0L;
                    this.localsize = 0L;
                }
            }
            SyncDB syncDB2 = this;
            this.currentLock = syncDB2.new LockImpl();
            if (syncDB2 != null) return this.currentLock;
            throw null;
        }
    }

    public FileSyncInfo getSyncInfo(String string) throws IOException {
        SyncDB syncDB = this;
        synchronized (syncDB) {
            this.refresh();
            FileSyncInfo fileSyncInfo = (FileSyncInfo)this.records.get(string);
            Object var3_4 = null;
            return fileSyncInfo;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setSyncInfo(String string, FileSyncInfo fileSyncInfo) throws IOException {
        Lock lock;
        block17: {
            lock = null;
            try {
                SyncDB syncDB = this;
                synchronized (syncDB) {
                    block15: {
                        block16: {
                            if (this.currentLock == null && (lock = this.obtainLock()) == null) {
                                if (this.syncfile.exists()) throw new IOException(Res.getString(ResIDs.UNABLE_TO_OBTAIN_SYNCDB_LOCK));
                                Object var7_5 = null;
                                break block15;
                            }
                            if (this.isSyncModified()) {
                                this.loadSyncFile();
                            }
                            FileSyncInfo fileSyncInfo2 = this.records.put(string, fileSyncInfo);
                            boolean bl = false;
                            try {
                                try {
                                    if (fileSyncInfo2 == null) {
                                        this.appendSyncRecord(string, fileSyncInfo);
                                        break block16;
                                    }
                                    Integer n = (Integer)this.m_recordIndices.get(string);
                                    if (n == null) {
                                        this.saveSyncFile();
                                        break block16;
                                    }
                                    if (!this.updateSyncRecord(n, string, fileSyncInfo)) {
                                        this.saveSyncFile();
                                    }
                                }
                                catch (RuntimeException runtimeException) {
                                    this.rollback(string, fileSyncInfo2);
                                    bl = true;
                                    throw runtimeException;
                                }
                                catch (IOException iOException) {
                                    this.rollback(string, fileSyncInfo2);
                                    bl = true;
                                    throw iOException;
                                }
                            }
                            catch (Exception exception) {
                                SDKRuntimeException sDKRuntimeException = new SDKRuntimeException(exception.get_Message());
                                if (bl) throw sDKRuntimeException;
                                this.rollback(string, fileSyncInfo2);
                                bl = true;
                                throw sDKRuntimeException;
                            }
                        }
                        break block17;
                    }
                }
                Object var5_6 = null;
                if (lock == null) return;
                lock.dispose();
                return;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                if (lock == null) throw throwable;
                lock.dispose();
                throw throwable;
            }
        }
        Object var5_7 = null;
        if (lock == null) return;
        lock.dispose();
    }

    private void appendSyncRecord(String string, FileSyncInfo fileSyncInfo) throws IOException {
        Integer n = (Integer)this.m_guidCache.get(fileSyncInfo.getRevisionIdentifier().getRepositoryID());
        if (n == null) {
            this.saveSyncFile();
        } else {
            RandomAccessFile randomAccessFile = null;
            try {
                try {
                    randomAccessFile = new RandomAccessFile(this.syncfile, "rw");
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.wipeClean();
                    Object var6_7 = null;
                    if (randomAccessFile != null) {
                        randomAccessFile.close();
                        this.localtime = this.syncfile.lastModified();
                        this.localsize = this.syncfile.length();
                    }
                    return;
                }
                RAOutputStream rAOutputStream = new RAOutputStream(randomAccessFile);
                rAOutputStream.seek(this.m_endPosition);
                this.m_recordIndices.put(string, new Integer(this.m_endPosition));
                int[] nArray = new int[]{this.m_endPosition};
                SyncDB.writeString(rAOutputStream, string, nArray);
                this.write(fileSyncInfo, rAOutputStream, this.m_guidCache, null, nArray);
                this.m_endPosition = nArray[0];
                rAOutputStream.seek(this.m_counterIndex);
                ++this.m_counter;
                SyncDB.writeInt(rAOutputStream, this.m_counter, nArray);
            }
            finally {
                Object var6_8 = null;
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                    this.localtime = this.syncfile.lastModified();
                    this.localsize = this.syncfile.length();
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean updateSyncRecord(int n, String string, FileSyncInfo fileSyncInfo) throws IOException {
        try {
            try {
                boolean bl;
                RandomAccessFile randomAccessFile;
                block25: {
                    boolean bl2;
                    block24: {
                        boolean bl3;
                        block23: {
                            boolean bl4;
                            block22: {
                                boolean bl5;
                                block21: {
                                    boolean bl6;
                                    block19: {
                                        boolean bl7;
                                        block20: {
                                            boolean bl8;
                                            block17: {
                                                byte[] byArray = UTF8.StringToUtf8(string);
                                                randomAccessFile = null;
                                                try {
                                                    Object object;
                                                    int n2;
                                                    int n3;
                                                    int[] nArray;
                                                    RAInputStream rAInputStream;
                                                    block26: {
                                                        String string2;
                                                        int n4;
                                                        block18: {
                                                            try {
                                                                randomAccessFile = new RandomAccessFile(this.syncfile, "rw");
                                                            }
                                                            catch (FileNotFoundException fileNotFoundException) {
                                                                this.wipeClean();
                                                                boolean bl9 = false;
                                                                Object var7_19 = null;
                                                                if (randomAccessFile == null) return bl9;
                                                                randomAccessFile.close();
                                                                this.localtime = this.syncfile.lastModified();
                                                                this.localsize = this.syncfile.length();
                                                                return bl9;
                                                            }
                                                            rAInputStream = new RAInputStream(randomAccessFile);
                                                            nArray = new int[]{n};
                                                            rAInputStream.seek(n);
                                                            int n5 = this.readInt(rAInputStream, nArray);
                                                            if (n5 != byArray.length) {
                                                                bl8 = false;
                                                                Object var7_20 = null;
                                                                if (randomAccessFile == null) return bl8;
                                                                break block17;
                                                            }
                                                            n4 = 0;
                                                            while (true) {
                                                                if (n4 >= n5) {
                                                                    n4 = this.readInt(rAInputStream, nArray);
                                                                    n3 = 0;
                                                                    n2 = -1;
                                                                    string2 = fileSyncInfo.getRevisionIdentifier().getRepositoryID();
                                                                    if (n4 != -1) break block18;
                                                                    object = this.readString(rAInputStream, nArray);
                                                                    if (((String)object).equals(string2)) break;
                                                                    bl6 = false;
                                                                    break block19;
                                                                }
                                                                n3 = rAInputStream.read();
                                                                if (n3 != byArray[n4]) {
                                                                    bl7 = false;
                                                                    break block20;
                                                                }
                                                                ++n4;
                                                            }
                                                            n3 = 1;
                                                            break block26;
                                                        }
                                                        object = (Integer)this.m_guidCache.get(string2);
                                                        if (object == null) {
                                                            bl5 = false;
                                                            break block21;
                                                        }
                                                        n2 = (Integer)object;
                                                        if (n2 == -1) {
                                                            bl4 = false;
                                                            break block22;
                                                        }
                                                        if (n2 != n4) {
                                                            bl3 = false;
                                                            break block23;
                                                        }
                                                        n3 = 0;
                                                    }
                                                    this.readInt(rAInputStream, nArray);
                                                    this.readInt(rAInputStream, nArray);
                                                    this.readInt(rAInputStream, nArray);
                                                    this.readInt(rAInputStream, nArray);
                                                    object = this.readString(rAInputStream, nArray);
                                                    String string3 = fileSyncInfo.getRevisionIdentifier().getDotNotation();
                                                    if (((String)object).length() != string3.length()) {
                                                        bl2 = false;
                                                        break block24;
                                                    }
                                                    RAOutputStream rAOutputStream = new RAOutputStream(randomAccessFile);
                                                    rAOutputStream.seek(n);
                                                    SyncDB.writeString(rAOutputStream, string, nArray);
                                                    this.writeRecord(fileSyncInfo, rAOutputStream, n3 != 0, n2, nArray);
                                                    bl = true;
                                                    break block25;
                                                }
                                                catch (Throwable throwable) {
                                                    Object var7_28 = null;
                                                    if (randomAccessFile != null) {
                                                        randomAccessFile.close();
                                                        this.localtime = this.syncfile.lastModified();
                                                        this.localsize = this.syncfile.length();
                                                    }
                                                    throw throwable;
                                                }
                                            }
                                            randomAccessFile.close();
                                            this.localtime = this.syncfile.lastModified();
                                            this.localsize = this.syncfile.length();
                                            return bl8;
                                        }
                                        Object var7_21 = null;
                                        if (randomAccessFile == null) return bl7;
                                        randomAccessFile.close();
                                        this.localtime = this.syncfile.lastModified();
                                        this.localsize = this.syncfile.length();
                                        return bl7;
                                    }
                                    Object var7_22 = null;
                                    if (randomAccessFile == null) return bl6;
                                    randomAccessFile.close();
                                    this.localtime = this.syncfile.lastModified();
                                    this.localsize = this.syncfile.length();
                                    return bl6;
                                }
                                Object var7_23 = null;
                                if (randomAccessFile == null) return bl5;
                                randomAccessFile.close();
                                this.localtime = this.syncfile.lastModified();
                                this.localsize = this.syncfile.length();
                                return bl5;
                            }
                            Object var7_24 = null;
                            if (randomAccessFile == null) return bl4;
                            randomAccessFile.close();
                            this.localtime = this.syncfile.lastModified();
                            this.localsize = this.syncfile.length();
                            return bl4;
                        }
                        Object var7_25 = null;
                        if (randomAccessFile == null) return bl3;
                        randomAccessFile.close();
                        this.localtime = this.syncfile.lastModified();
                        this.localsize = this.syncfile.length();
                        return bl3;
                    }
                    Object var7_26 = null;
                    if (randomAccessFile == null) return bl2;
                    randomAccessFile.close();
                    this.localtime = this.syncfile.lastModified();
                    this.localsize = this.syncfile.length();
                    return bl2;
                }
                Object var7_27 = null;
                if (randomAccessFile == null) return bl;
                randomAccessFile.close();
                this.localtime = this.syncfile.lastModified();
                this.localsize = this.syncfile.length();
                return bl;
            }
            catch (RuntimeException runtimeException) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void removeSyncInfo(String string) throws IOException {
        Lock lock = null;
        try {
            SyncDB syncDB = this;
            synchronized (syncDB) {
                if (this.currentLock == null && (lock = this.obtainLock()) == null) {
                    throw new IOException(Res.getString(ResIDs.UNABLE_TO_OBTAIN_SYNCDB_LOCK));
                }
                if (this.isSyncModified()) {
                    this.loadSyncFile();
                }
                Object v = this.records.remove(string);
                boolean bl = false;
                try {
                    try {
                        this.saveSyncFile();
                    }
                    catch (RuntimeException runtimeException) {
                        this.rollback(string, v);
                        bl = true;
                        throw runtimeException;
                    }
                    catch (IOException iOException) {
                        this.rollback(string, v);
                        bl = true;
                        throw iOException;
                    }
                }
                catch (Exception exception) {
                    SDKRuntimeException sDKRuntimeException = new SDKRuntimeException(exception.get_Message());
                    if (!bl) {
                        this.rollback(string, v);
                        bl = true;
                    }
                    throw sDKRuntimeException;
                }
            }
            Object var4_10 = null;
            if (lock != null) {
                lock.dispose();
            }
        }
        catch (Throwable throwable) {
            Object var4_11 = null;
            if (lock != null) {
                lock.dispose();
            }
            throw throwable;
        }
    }

    private void rollback(String string, Object object) {
        if (object != null) {
            this.records.put(string, object);
        } else {
            this.records.remove(string);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void load() throws IOException {
        Lock lock;
        block7: {
            lock = null;
            try {
                SyncDB syncDB = this;
                synchronized (syncDB) {
                    block6: {
                        if (this.currentLock == null && (lock = this.obtainLock()) == null) {
                            Object var5_3 = null;
                            break block6;
                        }
                        this.loadSyncFile();
                        break block7;
                    }
                }
                Object var3_4 = null;
                if (lock == null) return;
                lock.dispose();
                return;
            }
            catch (Throwable throwable) {
                Object var3_6 = null;
                if (lock == null) throw throwable;
                lock.dispose();
                throw throwable;
            }
        }
        Object var3_5 = null;
        if (lock == null) return;
        lock.dispose();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readSourceDirectory(File file) throws IOException {
        String string;
        BufferedInputStream bufferedInputStream;
        block10: {
            String string2;
            block9: {
                String string3;
                block8: {
                    String string4;
                    block7: {
                        String string5;
                        block6: {
                            SyncDB syncDB = new SyncDB();
                            syncDB.syncfile = file;
                            FileInputStream fileInputStream = new FileInputStream(file);
                            bufferedInputStream = null;
                            int[] nArray = new int[1];
                            try {
                                bufferedInputStream = new BufferedInputStream(fileInputStream);
                                int n = syncDB.readInt(bufferedInputStream, nArray);
                                if (n != 1224337155) {
                                    string5 = null;
                                    Object var6_11 = null;
                                    if (bufferedInputStream == null) return string5;
                                    break block6;
                                }
                                int n2 = syncDB.readInt(bufferedInputStream, nArray);
                                if (n2 < 1) {
                                    string4 = null;
                                    break block7;
                                }
                                if (n2 > 2) {
                                    string3 = null;
                                    break block8;
                                }
                                if (n2 > 1) {
                                    syncDB.readString(bufferedInputStream, nArray);
                                    string2 = syncDB.readString(bufferedInputStream, nArray);
                                    break block9;
                                }
                                string = null;
                                break block10;
                            }
                            catch (Throwable throwable) {
                                Object var6_16 = null;
                                if (bufferedInputStream == null) throw throwable;
                                ((InputStream)bufferedInputStream).close();
                                throw throwable;
                            }
                        }
                        ((InputStream)bufferedInputStream).close();
                        return string5;
                    }
                    Object var6_12 = null;
                    if (bufferedInputStream == null) return string4;
                    ((InputStream)bufferedInputStream).close();
                    return string4;
                }
                Object var6_13 = null;
                if (bufferedInputStream == null) return string3;
                ((InputStream)bufferedInputStream).close();
                return string3;
            }
            Object var6_14 = null;
            if (bufferedInputStream == null) return string2;
            ((InputStream)bufferedInputStream).close();
            return string2;
        }
        Object var6_15 = null;
        if (bufferedInputStream == null) return string;
        ((InputStream)bufferedInputStream).close();
        return string;
    }

    private void loadSyncFile() {
        try {
            try {
                int n;
                FileInputStream fileInputStream = null;
                try {
                    fileInputStream = new FileInputStream(this.syncfile);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.wipeClean();
                    return;
                }
                BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                int[] nArray = new int[1];
                int n2 = this.readInt(bufferedInputStream, nArray);
                if (n2 != 1224337155) {
                    this.corruptFileError("SyncDB.loadSyncFile(), cookie=" + n2);
                }
                if ((n = this.readInt(bufferedInputStream, nArray)) < 1 || n > 2) {
                    throw new IOException(Res.formatKey(ResIDs.UNKNOWN_SYNC_FILE_VERSION_FMT, new Object[]{new Integer(n)}));
                }
                if (n > 1) {
                    this.creator = this.readString(bufferedInputStream, nArray);
                    this.origpath = this.readString(bufferedInputStream, nArray);
                }
                this.m_counterIndex = nArray[0];
                int n3 = this.readInt(bufferedInputStream, nArray);
                if (n3 < 0) {
                    this.corruptFileError("SyncDB.loadSyncFile(), nRecords=" + n3);
                }
                this.m_counter = n3;
                int n4 = n3 * 2;
                if (n4 < 10) {
                    n4 = 10;
                }
                int n5 = 0;
                if (this.records != null) {
                    n5 = this.records.size();
                }
                this.records = new Hashtable(n4);
                String[] stringArray = new String[n3];
                this.m_guidCache.clear();
                this.m_recordIndices.clear();
                int[] nArray2 = new int[1];
                int n6 = 0;
                while (n6 < n3) {
                    int n7 = nArray[0];
                    String string = this.readString(bufferedInputStream, nArray);
                    this.m_recordIndices.put(string, new Integer(n7));
                    FileSyncInfo fileSyncInfo = this.read(bufferedInputStream, stringArray, nArray2, nArray);
                    this.records.put(string, fileSyncInfo);
                    ++n6;
                }
                this.m_endPosition = nArray[0];
                n6 = ((InputStream)bufferedInputStream).read();
                if (n6 != -1) {
                    this.corruptFileError("SyncDB.loadSyncFile(), !eof");
                }
                ((InputStream)bufferedInputStream).close();
                this.localtime = this.syncfile.lastModified();
                this.localsize = this.syncfile.length();
            }
            catch (IOException iOException) {
                this.wipeClean();
            }
            catch (RuntimeException runtimeException) {
                this.wipeClean();
            }
        }
        catch (Exception exception) {
            this.wipeClean();
        }
    }

    private void wipeClean() {
        this.records.clear();
        this.localtime = -1L;
        this.localsize = -1L;
        this.m_recordIndices.clear();
        this.m_guidCache.clear();
        this.m_endPosition = -1;
        this.m_counterIndex = -1;
        this.m_counter = -1;
    }

    private void saveSyncFile() throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(this.syncfile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.wipeClean();
            return;
        }
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream, 4048);
        int[] nArray = new int[1];
        this.m_counter = 0;
        this.m_guidCache.clear();
        this.m_recordIndices.clear();
        this.m_counterIndex = -1;
        this.m_endPosition = -1;
        SyncDB.writeInt(bufferedOutputStream, 1224337155, nArray);
        SyncDB.writeInt(bufferedOutputStream, 2, nArray);
        SyncDB.writeString(bufferedOutputStream, BuildNumber.getDisplayString(), nArray);
        SyncDB.writeString(bufferedOutputStream, this.path, nArray);
        this.m_counterIndex = nArray[0];
        this.m_counter = this.records.size();
        SyncDB.writeInt(bufferedOutputStream, this.records.size(), nArray);
        Enumeration enumeration = this.records.keys();
        Hashtable hashtable = new Hashtable();
        int[] nArray2 = new int[1];
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.m_recordIndices.put(string, new Integer(nArray[0]));
            FileSyncInfo fileSyncInfo = (FileSyncInfo)this.records.get(string);
            SyncDB.writeString(bufferedOutputStream, string, nArray);
            this.write(fileSyncInfo, bufferedOutputStream, hashtable, nArray2, nArray);
        }
        this.m_endPosition = nArray[0];
        ((OutputStream)bufferedOutputStream).close();
        this.localtime = this.syncfile.lastModified();
        this.localsize = this.syncfile.length();
    }

    private boolean createEmptySyncFile() throws IOException {
        File file = new File(this.syncfile.getParent());
        if (!file.exists()) {
            File file2 = new File(file.getParent());
            if (!file2.exists()) {
                this.wipeClean();
                return false;
            }
            file.mkdir();
        }
        this.wipeClean();
        this.saveSyncFile();
        return true;
    }

    private FileSyncInfo read(InputStream inputStream, String[] stringArray, int[] nArray, int[] nArray2) throws IOException {
        String string = null;
        int n = this.readInt(inputStream, nArray2);
        if (n == -1) {
            string = this.statusmanager.getRepositoryID(this.readString(inputStream, nArray2));
            this.m_guidCache.put(string, new Integer(nArray[0]));
            stringArray[nArray[0]] = string;
            nArray[0] = nArray[0] + 1;
        } else {
            if (n < 0 || n >= stringArray.length) {
                this.corruptFileError("SyncDB.read(), flag=" + n + ", len=" + stringArray.length);
            }
            if ((string = stringArray[n]) == null) {
                this.corruptFileError("SyncDB.read(), flag=" + n + ", serverID=null");
            }
        }
        int n2 = this.readInt(inputStream, nArray2);
        int n3 = this.readInt(inputStream, nArray2);
        int n4 = this.readInt(inputStream, nArray2);
        int n5 = this.readInt(inputStream, nArray2);
        String string2 = this.readString(inputStream, nArray2);
        long l = this.readLong(inputStream, nArray2);
        double d = this.readDouble(inputStream, nArray2);
        byte[] byArray = new byte[16];
        int n6 = 0;
        while (n6 < 16) {
            byArray[n6] = (byte)(this.readOrDie(inputStream) & 0xFF);
            ++n6;
        }
        nArray2[0] = nArray2[0] + 16;
        return new SimpleSyncRecord(string, n2, n3, n4, n5, string2, l, d, byArray);
    }

    void write(FileSyncInfo fileSyncInfo, OutputStream outputStream, Hashtable hashtable, int[] nArray, int[] nArray2) throws IOException {
        String string = fileSyncInfo.getRevisionIdentifier().getRepositoryID();
        Object v = hashtable.get(string);
        boolean bl = false;
        int n = -1;
        if (v == null) {
            bl = true;
            hashtable.put(string, new Integer(nArray[0]));
            this.m_guidCache.put(string, new Integer(nArray[0]));
            nArray[0] = nArray[0] + 1;
        } else {
            bl = false;
            n = (Integer)v;
        }
        this.writeRecord(fileSyncInfo, outputStream, bl, n, nArray2);
    }

    void writeRecord(FileSyncInfo fileSyncInfo, OutputStream outputStream, boolean bl, int n, int[] nArray) throws IOException {
        String string = fileSyncInfo.getRevisionIdentifier().getRepositoryID();
        if (bl) {
            SyncDB.writeInt(outputStream, -1, nArray);
            SyncDB.writeString(outputStream, string, nArray);
        } else {
            if (n < 0) {
                this.corruptFileError("SyncDB.writeRecord(), index=" + n);
            }
            SyncDB.writeInt(outputStream, n, nArray);
        }
        SyncDB.writeInt(outputStream, fileSyncInfo.getRevisionIdentifier().getRootObjectID(), nArray);
        SyncDB.writeInt(outputStream, fileSyncInfo.getRevisionIdentifier().getObjectID(), nArray);
        SyncDB.writeInt(outputStream, fileSyncInfo.getRevisionIdentifier().getRevisionNumber(), nArray);
        SyncDB.writeInt(outputStream, fileSyncInfo.getRevisionIdentifier().getContentRevision(), nArray);
        SyncDB.writeString(outputStream, fileSyncInfo.getRevisionIdentifier().getDotNotation(), nArray);
        SyncDB.writeLong(outputStream, fileSyncInfo.getFileDigest().getFileSize(), nArray);
        SyncDB.writeDouble(outputStream, fileSyncInfo.getFileDigest().getFileTime(), nArray);
        byte[] byArray = fileSyncInfo.getFileDigest().getFileMD5().getData();
        outputStream.write(byArray);
        nArray[0] = nArray[0] + byArray.length;
    }

    private final int readInt(InputStream inputStream, int[] nArray) throws IOException {
        int n = this.readOrDie(inputStream) & 0xFF;
        int n2 = this.readOrDie(inputStream) & 0xFF;
        int n3 = this.readOrDie(inputStream) & 0xFF;
        int n4 = this.readOrDie(inputStream) & 0xFF;
        nArray[0] = nArray[0] + 4;
        return n + (n2 << 8) + (n3 << 16) + (n4 << 24);
    }

    private static final void writeInt(OutputStream outputStream, int n, int[] nArray) throws IOException {
        outputStream.write(n & 0xFF);
        outputStream.write(n >>> 8 & 0xFF);
        outputStream.write(n >>> 16 & 0xFF);
        outputStream.write(n >>> 24 & 0xFF);
        nArray[0] = nArray[0] + 4;
    }

    private final long readLong(InputStream inputStream, int[] nArray) throws IOException {
        long l = this.readOrDie(inputStream) & 0xFF;
        long l2 = this.readOrDie(inputStream) & 0xFF;
        long l3 = this.readOrDie(inputStream) & 0xFF;
        long l4 = this.readOrDie(inputStream) & 0xFF;
        long l5 = this.readOrDie(inputStream) & 0xFF;
        long l6 = this.readOrDie(inputStream) & 0xFF;
        long l7 = this.readOrDie(inputStream) & 0xFF;
        long l8 = this.readOrDie(inputStream) & 0xFF;
        nArray[0] = nArray[0] + 8;
        return l + (l2 << 8) + (l3 << 16) + (l4 << 24) + (l5 << 32) + (l6 << 40) + (l7 << 48) + (l8 << 56);
    }

    private static final void writeLong(OutputStream outputStream, long l, int[] nArray) throws IOException {
        outputStream.write((int)l & 0xFF);
        outputStream.write((int)(l >>> 8) & 0xFF);
        outputStream.write((int)(l >>> 16) & 0xFF);
        outputStream.write((int)(l >>> 24) & 0xFF);
        outputStream.write((int)(l >>> 32) & 0xFF);
        outputStream.write((int)(l >>> 40) & 0xFF);
        outputStream.write((int)(l >>> 48) & 0xFF);
        outputStream.write((int)(l >>> 56) & 0xFF);
        nArray[0] = nArray[0] + 8;
    }

    private String readString(InputStream inputStream, int[] nArray) throws IOException {
        int n = this.readInt(inputStream, nArray);
        if (n < 0) {
            this.corruptFileError("SyncDB.readString(), len=" + n);
        }
        if (n > 5000) {
            this.corruptFileError("SyncDB.readString(), len2=" + n);
        }
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = (byte)(this.readOrDie(inputStream) & 0xFF);
            ++n2;
        }
        nArray[0] = nArray[0] + n;
        return UTF8.Utf8ToString(byArray);
    }

    private static final void writeString(OutputStream outputStream, String string, int[] nArray) throws IOException {
        byte[] byArray = UTF8.StringToUtf8(string);
        SyncDB.writeInt(outputStream, byArray.length, nArray);
        outputStream.write(byArray);
        nArray[0] = nArray[0] + byArray.length;
    }

    private final double readDouble(InputStream inputStream, int[] nArray) throws IOException {
        return Double.longBitsToDouble(this.readLong(inputStream, nArray));
    }

    private static final void writeDouble(OutputStream outputStream, double d, int[] nArray) throws IOException {
        SyncDB.writeLong(outputStream, Double.doubleToLongBits(d), nArray);
    }

    private int readOrDie(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n == -1) {
            this.corruptFileError("SyncDB.readOrDie()");
        }
        return n;
    }

    private void corruptFileError(String string) throws IOException {
        if (this.syncfile != null) {
            String string2 = this.syncfile.getPath();
            try {
                try {
                    string2 = this.syncfile.getCanonicalPath();
                }
                catch (RuntimeException runtimeException) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new IOException(Res.formatKey(ResIDs.SYNCDB_CORRUPT_FMT, new Object[]{string, string2}));
        }
        Assert.internalError(string + ", syncfile=null");
    }

    public void debugDump() throws IOException {
        Enumeration enumeration = this.records.keys();
        System.out.println("=== for: " + this.path + " ===");
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            FileSyncInfo fileSyncInfo = (FileSyncInfo)this.records.get(string);
            System.out.println(string);
            System.out.println("    serverID    : " + fileSyncInfo.getRevisionIdentifier().getRepositoryID());
            System.out.println("    rootID      : " + fileSyncInfo.getRevisionIdentifier().getRootObjectID());
            System.out.println("    contentRev  : " + fileSyncInfo.getRevisionIdentifier().getContentRevision());
            System.out.println("    sync size  : " + fileSyncInfo.getFileDigest().getFileSize());
            System.out.println("    sync time  : " + fileSyncInfo.getFileDigest().getFileTime());
            System.out.println("    sync md5   : " + fileSyncInfo.getFileDigest().getFileMD5());
        }
    }

    static /* synthetic */ Lock access$0(SyncDB syncDB) {
        return syncDB.currentLock;
    }

    private SyncDB() {
    }

    public SyncDB(String string, FileBasedStatusManager fileBasedStatusManager, File file, boolean bl) throws IOException {
        boolean bl2;
        this.statusmanager = fileBasedStatusManager;
        String string2 = BaseFileUtils.getCanonicalPathName(BaseFileUtils.getAbsolutePath(string), bl);
        MD5 mD5 = new MD5();
        mD5.computeBufferMD5(UTF8.StringToUtf8(string2));
        byte[] byArray = mD5.getData();
        String string3 = SyncDB.makeSubDirName(byArray);
        File file2 = new File(file, string3);
        this.path = string2;
        if (!file2.exists() && !(bl2 = file2.mkdirs())) {
            throw new IOException(Res.formatKey(ResIDs.UNABLE_TO_CREATE_DIR_FMT, new Object[]{file2.getPath()}));
        }
        String string4 = SyncDB.byteString(byArray);
        this.syncfile = new File(file2, string4 + ".sdb");
        this.lockfile = new File(file2, string4 + ".lck");
        this.records = new Hashtable();
        this.refresh();
    }

    public SyncDB(String string, FileBasedStatusManager fileBasedStatusManager) throws IOException {
        boolean bl;
        this.statusmanager = fileBasedStatusManager;
        File file = new File(string, DIR_NAME);
        this.path = string;
        if (!file.exists() && !(bl = file.mkdir())) {
            throw new IOException(Res.formatKey(ResIDs.UNABLE_TO_CREATE_DIR_FMT, new Object[]{file.getPath()}));
        }
        this.syncfile = new File(file, DB_NAME);
        this.lockfile = new File(file, LOCK_NAME);
        this.records = new Hashtable();
        this.refresh();
    }

    static class RAInputStream
    extends InputStream {
        private RandomAccessFile m_ra = null;

        public int read(byte[] byArray, int n, int n2) throws IOException {
            return this.m_ra.read(byArray, n, n2);
        }

        public int read(byte[] byArray) throws IOException {
            return this.m_ra.read(byArray);
        }

        public int read() throws IOException {
            return this.m_ra.read();
        }

        public void seek(int n) throws IOException {
            this.m_ra.seek(n);
        }

        public RAInputStream(RandomAccessFile randomAccessFile) {
            this.m_ra = randomAccessFile;
        }
    }

    static class RAOutputStream
    extends OutputStream {
        private RandomAccessFile m_ra = null;

        public void close() throws IOException {
        }

        public void flush() throws IOException {
        }

        public void seek(long l) throws IOException {
            this.m_ra.seek(l);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.m_ra.write(byArray, n, n2);
        }

        public void write(byte[] byArray) throws IOException {
            this.m_ra.write(byArray);
        }

        public void write(int n) throws IOException {
            this.m_ra.write(n);
        }

        public RAOutputStream(RandomAccessFile randomAccessFile) {
            this.m_ra = randomAccessFile;
        }
    }

    private static interface Lock {
        public void dispose();
    }

    private class LockImpl
    implements Lock {
        public void dispose() {
            SyncDB syncDB = SyncDB.this;
            synchronized (syncDB) {
                SyncDB.this.currentLock = null;
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(SyncDB.this.lockfile);
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        private LockImpl() {
        }
    }
}

