/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.Res;
import com.starbase.starteam.ResIDs;
import com.starbase.starteam.vts.comm.SystemRevisionNumbers;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class SupportedFeatures {
    private short m_revisionLevel = (short)-1;
    private String m_apiRevision = "1.0";
    private String m_displayName = "";

    private boolean supports(short s, String string) {
        return SystemRevisionNumbers.equalOrGreater(this.m_revisionLevel, this.m_apiRevision, s, string);
    }

    public boolean hasLabelLocking() {
        return this.m_revisionLevel >= 55;
    }

    protected void verifyHasLabelLocking() {
        if (!this.hasLabelLocking()) {
            this.throwUnsupportedException(ResIDs.LABEL_LOCKING_UNSUPPORTED);
        }
    }

    public boolean hasClientManagedFileStatus() {
        return SystemRevisionNumbers.isClientManagedStatus(this.m_revisionLevel);
    }

    protected void verifyHasClientManagedFileStatus() {
        if (!this.hasClientManagedFileStatus()) {
            this.throwUnsupportedException(ResIDs.CLIENT_MANAGED_STATUS_UNSUPPORTED);
        }
    }

    public boolean hasNOTQueryOperator() {
        return this.supports((short)100, "1.2");
    }

    protected void verifyHasNOTQueryOperator() {
        if (!this.hasNOTQueryOperator()) {
            this.throwUnsupportedException(ResIDs.QUERY_OPERATOR_NOT_UNSUPPORTED);
        }
    }

    private boolean hasProductCodeInformation() {
        return this.m_revisionLevel >= 46;
    }

    public boolean hasForwardCompatibility() {
        return this.m_revisionLevel >= 100;
    }

    public boolean hasServerLock() {
        return this.m_revisionLevel >= 76;
    }

    public boolean hasServerLockStatus() {
        return this.m_revisionLevel >= 76;
    }

    protected void verifyHasServerLockStatus() {
        if (!this.hasServerLockStatus()) {
            this.throwUnsupportedException(ResIDs.SERVER_LOCK_STATUS_UNSUPPORTED);
        }
    }

    public boolean hasServerExclusiveLock() {
        return this.hasServerLockStatus();
    }

    protected void verifyHasServerExclusiveLock() {
        if (!this.hasServerExclusiveLock()) {
            this.throwUnsupportedException(ResIDs.SERVER_EXCLUSIVE_LOCK_UNSUPPORTED);
        }
    }

    public boolean hasServerLicenseInfo() {
        return this.m_revisionLevel >= 73;
    }

    public boolean hasConcurrentLicensing() {
        return this.m_revisionLevel >= 84;
    }

    protected void verifyHasConcurrentLicensing() {
        if (!this.hasConcurrentLicensing()) {
            this.throwUnsupportedException(ResIDs.FLOATING_LICENSES_UNSUPPORTED);
        }
    }

    public boolean hasServerShutdown() {
        return this.m_revisionLevel >= 68;
    }

    protected void verifyHasServerShutdown() {
        if (!this.hasServerShutdown()) {
            this.throwUnsupportedException(ResIDs.SERVER_SHUTDOWN_UNSUPPORTED);
        }
    }

    public boolean hasNewAuditProperties() {
        return this.supports((short)100, "1.3");
    }

    public boolean hasFileExecutablePermission() {
        return this.supports((short)100, "1.4");
    }

    public boolean hasGroupMembers() {
        return this.supports((short)100, "1.5");
    }

    public boolean hasPromotionStateRights() {
        return this.supports((short)100, "1.6");
    }

    public boolean isServerLocalized() {
        return this.supports((short)100, "1.9");
    }

    public boolean hasCustomTranslations() {
        return this.supports((short)100, "1.9");
    }

    void verifyHasCustomTranslations() {
        if (!this.hasCustomTranslations()) {
            this.throwUnsupportedException(ResIDs.SERVER_NO_TRANSLATIONS);
        }
    }

    public boolean hasDirectoryServiceSupport() {
        return this.supports((short)100, "1.11");
    }

    void verifyHasDirectoryServiceSupport() {
        if (!this.hasDirectoryServiceSupport()) {
            this.throwUnsupportedException(ResIDs.SERVER_NO_LDAP_PROPERTIES);
        }
    }

    public boolean hasLabelCopy() {
        return this.m_revisionLevel >= 53;
    }

    protected void verifyHasLabelCopy() {
        if (!this.hasLabelCopy()) {
            this.throwUnsupportedException(ResIDs.LABEL_COPY_UNSUPPORTED);
        }
    }

    public boolean hasMergeService() {
        return this.m_revisionLevel == 66 || this.m_revisionLevel >= 72;
    }

    protected void verifyHasMergeService() {
        if (!this.hasMergeService()) {
            this.throwUnsupportedException(ResIDs.SERVER_NO_MERGE_SERVICE);
        }
    }

    public boolean hasServerCommandStats() {
        return this.m_revisionLevel >= 72 && !this.supports((short)100, "1.12");
    }

    protected void verifyHasServerCommandStats() {
        if (!this.hasServerCommandStats()) {
            this.throwUnsupportedException(ResIDs.SERVER_COMMAND_STATS_UNSUPPORTED);
        }
    }

    public boolean hasNamedConfigOptions() {
        return this.supports((short)100, "1.12");
    }

    public boolean hasDiagnostics() {
        return this.supports((short)100, "1.12");
    }

    public boolean hasReconnect() {
        return this.supports((short)100, "1.10");
    }

    protected void verifyHasReconnect() {
        if (!this.hasReconnect()) {
            this.throwUnsupportedException(ResIDs.RECONNECT_UNSUPPORTED);
        }
    }

    public boolean hasItemRevision() {
        return this.supports((short)100, "1.17");
    }

    public boolean hasLinkParentFolderItemID() {
        return this.supports((short)100, "1.16");
    }

    public boolean hasMergeHistory() {
        return this.supports((short)100, "1.17");
    }

    public boolean hasSecureDirectoryService() {
        return this.supports((short)100, "1.19");
    }

    public boolean hasNativeIIVault() {
        return this.supports((short)100, "1.23");
    }

    public boolean hasNoTimeoutNamedLicenses() {
        return this.supports((short)100, "1.15");
    }

    void throwUnsupportedException(String string) {
        throw new RuntimeException(Res.formatKey(ResIDs.UNSUPPORTED_SERVER_OPERATION_FMT, new Object[]{Res.getString(string), this.m_displayName}));
    }

    public String toDebugString() {
        String string = System.getProperty("line.separator");
        Method[] methodArray = this.getClass().getMethods();
        StringBuffer stringBuffer = new StringBuffer();
        Object[] objectArray = new Object[]{};
        int n = 0;
        while (n < methodArray.length) {
            Method method = methodArray[n];
            if (method.getName().startsWith("has") && method.getParameterTypes().length == 0 && method.getReturnType().equals(Boolean.TYPE)) {
                try {
                    Object object = method.invoke((Object)this, objectArray);
                    stringBuffer.append(method.getName() + ": " + object + string);
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toDebugString();
    }

    private SupportedFeatures() {
    }

    SupportedFeatures(short s, String string, String string2) {
        this.m_revisionLevel = s;
        this.m_apiRevision = string;
        this.m_displayName = string2;
    }
}

