/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.FileDigest;
import com.starbase.starteam.FileSyncInfo;
import com.starbase.starteam.Res;
import com.starbase.starteam.ResIDs;
import com.starbase.starteam.RevisionIdentifier;
import com.starbase.util.Assert;
import com.starbase.util.MD5;
import com.starbase.util.Platform;
import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;

public class Status {
    private static final String EMPTY = "";
    private static final String DOT = ".";
    public static final int CURRENT = 0;
    public static final int MERGE = 1;
    public static final int MISSING = 2;
    public static final int MODIFIED = 3;
    public static final int OUTOFDATE = 5;
    public static final int NEW = 4;
    public static final int UNKNOWN = 6;
    private static final double ONE_HOUR = 0.041666666666666664;
    private static final double ONE_SECOND = 1.1574074074074073E-5;
    private static final double HUNDRETH_SECOND = 1.1574074074074073E-7;

    public static String name(int n) {
        switch (n) {
            case 6: {
                return Res.getString(ResIDs.STATUS_UNKNOWN);
            }
            case 0: {
                return Res.getString(ResIDs.STATUS_CURRENT);
            }
            case 3: {
                return Res.getString(ResIDs.STATUS_MODIFIED);
            }
            case 5: {
                return Res.getString(ResIDs.STATUS_OUT_OF_DATE);
            }
            case 1: {
                return Res.getString(ResIDs.STATUS_MERGE);
            }
            case 2: {
                return Res.getString(ResIDs.STATUS_MISSING);
            }
            case 4: {
                return Res.getString(ResIDs.STATUS_NOT_IN_VIEW);
            }
        }
        throw new IllegalArgumentException(Res.formatKey(ResIDs.INVALID_STATUS_CODE_FMT, new Object[]{new Integer(n)}));
    }

    private static boolean sameStatusTimes(double d, double d2) {
        double d3 = Math.abs(d - d2);
        if (d3 < 1.1574074074074073E-7) {
            return true;
        }
        d3 = Math.abs(Math.abs(d - d2) - 0.041666666666666664);
        return d3 < 1.1574074074074073E-7;
    }

    private static boolean sameServer(FileSyncInfo fileSyncInfo, RevisionIdentifier revisionIdentifier) {
        return fileSyncInfo.getRevisionIdentifier().getRepositoryID().equals(revisionIdentifier.getRepositoryID());
    }

    static int getLastKnownStatus(FileSyncInfo fileSyncInfo, RevisionIdentifier revisionIdentifier) {
        if (fileSyncInfo == null || revisionIdentifier == null) {
            return 6;
        }
        if (!Status.sameServer(fileSyncInfo, revisionIdentifier)) {
            return 6;
        }
        RevisionIdentifier revisionIdentifier2 = fileSyncInfo.getRevisionIdentifier();
        int n = revisionIdentifier2.getRootObjectID();
        String string = revisionIdentifier2.getDotNotation();
        int n2 = revisionIdentifier2.getContentRevision();
        int n3 = revisionIdentifier.getRootObjectID();
        String string2 = revisionIdentifier.getDotNotation();
        int n4 = revisionIdentifier.getContentRevision();
        return Status.compare(n, string, n2, n3, string2, n4);
    }

    static int getStatusByTime(File file, FileSyncInfo fileSyncInfo, RevisionIdentifier revisionIdentifier) throws IOException {
        if (!file.exists()) {
            return 2;
        }
        if (fileSyncInfo == null || revisionIdentifier == null) {
            return 6;
        }
        if (!Status.sameServer(fileSyncInfo, revisionIdentifier)) {
            return 6;
        }
        long l = file.length();
        double d = Platform.getFileLastModified(file);
        return Status.getStatusByTime(l, d, fileSyncInfo, revisionIdentifier);
    }

    static int getStatusByTime(long l, double d, FileSyncInfo fileSyncInfo, RevisionIdentifier revisionIdentifier) {
        if (fileSyncInfo == null || revisionIdentifier == null) {
            return 6;
        }
        if (!Status.sameServer(fileSyncInfo, revisionIdentifier)) {
            return 6;
        }
        int n = Status.getLastKnownStatus(fileSyncInfo, revisionIdentifier);
        if (n == 6) {
            return n;
        }
        FileDigest fileDigest = fileSyncInfo.getFileDigest();
        long l2 = fileDigest.getFileSize();
        double d2 = fileDigest.getFileTime();
        boolean bl = Status.hasFileChanged(l, d, l2, d2);
        return Status.partialStatus(bl, n);
    }

    static int getStatusByMD5(File file, FileSyncInfo fileSyncInfo, RevisionIdentifier revisionIdentifier) throws IOException {
        if (!file.exists()) {
            return 2;
        }
        if (fileSyncInfo == null || revisionIdentifier == null) {
            return 6;
        }
        if (!Status.sameServer(fileSyncInfo, revisionIdentifier)) {
            return 6;
        }
        MD5 mD5 = new MD5();
        mD5.computeFileMD5(file);
        return Status.getStatusByMD5(mD5, fileSyncInfo, revisionIdentifier);
    }

    static int getStatusByMD5(MD5 mD5, FileSyncInfo fileSyncInfo, RevisionIdentifier revisionIdentifier) {
        if (fileSyncInfo == null || revisionIdentifier == null) {
            return 6;
        }
        if (!Status.sameServer(fileSyncInfo, revisionIdentifier)) {
            return 6;
        }
        int n = Status.getLastKnownStatus(fileSyncInfo, revisionIdentifier);
        if (n == 6) {
            return n;
        }
        FileDigest fileDigest = fileSyncInfo.getFileDigest();
        MD5 mD52 = fileDigest.getFileMD5();
        boolean bl = Status.hasFileChanged(mD5, mD52);
        return Status.partialStatus(bl, n);
    }

    private static int partialStatus(boolean bl, int n) {
        if (!bl) {
            return n;
        }
        switch (n) {
            case 0: 
            case 3: {
                return 3;
            }
            case 1: 
            case 5: {
                return 1;
            }
        }
        return 6;
    }

    static boolean hasFileChanged(long l, double d, long l2, double d2) {
        if (l != l2) {
            return true;
        }
        return !Status.sameStatusTimes(d, d2);
    }

    static boolean hasFileChanged(MD5 mD5, MD5 mD52) {
        return !mD5.equals(mD52);
    }

    private static int compare(int n, String string, int n2, int n3, String string2, int n4) {
        if (n != n3) {
            return 6;
        }
        int n5 = Status.compare(string, string2);
        switch (n5) {
            case 0: 
            case 1: {
                return n5;
            }
            case 3: 
            case 5: {
                if (n2 == n4) {
                    return 0;
                }
                return n5;
            }
        }
        Assert.internalError("Status.compare(), s=" + n5 + ", sync=" + string + ", tip=" + string2);
        return 6;
    }

    static boolean getSyncOnPathToRoot(String string, String string2) {
        int n = Status.compare(string, string2);
        switch (n) {
            case 0: 
            case 5: {
                return true;
            }
            case 1: 
            case 3: {
                return false;
            }
        }
        return false;
    }

    static int compare(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, DOT);
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, DOT);
        return Status.compareBranch(stringTokenizer, stringTokenizer2);
    }

    private static int compareVersion(StringTokenizer stringTokenizer, StringTokenizer stringTokenizer2) {
        String string;
        String string2 = stringTokenizer.nextToken();
        if (string2.equals(string = stringTokenizer2.nextToken())) {
            return Status.compareBranch(stringTokenizer, stringTokenizer2);
        }
        int n = Integer.parseInt(string2);
        int n2 = Integer.parseInt(string);
        if (n2 > n) {
            if (stringTokenizer.hasMoreTokens()) {
                return 1;
            }
            return 5;
        }
        if (stringTokenizer2.hasMoreTokens()) {
            return 1;
        }
        return 3;
    }

    private static int compareBranch(StringTokenizer stringTokenizer, StringTokenizer stringTokenizer2) {
        if (stringTokenizer.hasMoreTokens()) {
            if (stringTokenizer2.hasMoreTokens()) {
                String string;
                String string2 = stringTokenizer.nextToken();
                if (string2.equals(string = stringTokenizer2.nextToken())) {
                    return Status.compareVersion(stringTokenizer, stringTokenizer2);
                }
                return 1;
            }
            return 3;
        }
        if (stringTokenizer2.hasMoreTokens()) {
            return 5;
        }
        return 0;
    }

    static String findCommonAncestor(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, DOT);
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, DOT);
        return Status.findBranch(EMPTY, stringTokenizer, stringTokenizer2);
    }

    private static String findVersion(String string, StringTokenizer stringTokenizer, StringTokenizer stringTokenizer2) {
        String string2;
        String string3 = stringTokenizer.nextToken();
        if (string3.equals(string2 = stringTokenizer2.nextToken())) {
            return string + DOT + string3 + Status.findBranch(DOT, stringTokenizer, stringTokenizer2);
        }
        int n = Integer.parseInt(string3);
        int n2 = Integer.parseInt(string2);
        if (n2 > n) {
            return string + DOT + string3;
        }
        return string + DOT + string2;
    }

    private static String findBranch(String string, StringTokenizer stringTokenizer, StringTokenizer stringTokenizer2) {
        String string2;
        String string3;
        if (stringTokenizer.hasMoreTokens() && stringTokenizer2.hasMoreTokens() && (string3 = stringTokenizer.nextToken()).equals(string2 = stringTokenizer2.nextToken())) {
            return string + Status.findVersion(string3, stringTokenizer, stringTokenizer2);
        }
        return EMPTY;
    }

    private Status() {
    }
}

