/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.IPRange;
import com.starbase.starteam.Res;
import com.starbase.starteam.ResIDs;
import com.starbase.starteam.ServerAdministration;
import com.starbase.starteam.vts.comm.Command;
import com.starbase.util.Assert;
import java.io.IOException;
import java.util.Hashtable;

public class ServerConfiguration {
    private static final String EMPTY = "";
    public static final int DBTYPE_UNKNOWN = 0;
    public static final int DBTYPE_MSACCESS = 1;
    public static final int DBTYPE_SQLSERVER = 2;
    public static final int DBTYPE_ORACLE = 3;
    public static final int DBTYPE_SYBASE = 4;
    public static final int DBTYPE_INFORMIX = 5;
    public static final int DBTYPE_DB2 = 6;
    public static final int PROTOCOL_LRPC = 1;
    public static final int PROTOCOL_NETBIOS = 2;
    public static final int PROTOCOL_IPX = 3;
    public static final int PROTOCOL_NAMED_PIPE = 4;
    public static final int PROTOCOL_TCP_IP_RPC = 5;
    public static final int PROTOCOL_TCP_IP_SOCKETS = 6;
    public static final int PROTOCOL_TCP_IP_SOCKETS_XML = 7;
    private static final int FIRST_PROTOCOL = 1;
    private static final int LAST_PROTOCOL = 7;
    public static final int NOTIFICATION_TYPE_SYSTRAY = 1;
    public static final int NOTIFICATION_TYPE_EMAIL = 2;
    public static final int NOTIFICATION_TYPE_BOTH = 3;
    private static final int NOTIFY_EMAIL_FORMAT_PLAINTEXT = 1;
    private static final int NOTIFY_EMAIL_FORMAT_HTML = 2;
    private static String TRACE_OPS_NAME = "DiagCommandTrace";
    private static String EXPENSIVE_OP_MIN = "DiagCommandTraceMinTime";
    private static String DUMP_ASSERTS = "DiagAssertDump";
    private static String DUMP_ERRORS = "DiagExceptionDump";
    private String m_dsn = "";
    private int m_dbType = 0;
    private int m_pooledConnections = 1;
    private boolean m_disableTransactions = true;
    private String m_serverGUID = "";
    private String m_cipher = "";
    private String m_repositoryPath = "";
    private String m_systemLog = "";
    private boolean m_enableDiagnostics = true;
    private int m_logonTimeout = 0;
    private int m_inactivityTimeout = 0;
    private int m_reconnectTimeout = 0;
    private boolean m_noTimeoutNamedLicenses = false;
    private String m_vaultDirectory = "";
    private String m_cacheDirectory = "";
    private String m_archiveDirectory = "";
    private String m_multiPartDirectory = "";
    private int m_lockTimeout = 0;
    private int m_cacheMax = 0;
    private int m_cacheRefreshInterval = 0;
    private int m_syncAutoPurgeDays = 0;
    private boolean m_verifyDB = false;
    private boolean m_autoRecovery = false;
    private boolean m_stopServerOnErrors = false;
    private int m_foreignRefreshRate = 0;
    private String m_attachmentDirectory = "";
    private boolean m_enableMail = true;
    private String m_smtpAddress = "";
    private int m_smtpPort = -1;
    private int m_NotifyBy = 1;
    private int m_NotifyEmailFormat = 1;
    private boolean m_enableAudit = true;
    private int m_auditAutoPurgeDays = 0;
    private boolean m_webLogging;
    private int m_webLogginBrief;
    private String m_webLoggingFile;
    private boolean m_bDirectoryEnabled = false;
    private String m_directoryUrl = "";
    private int m_directoryPort = -1;
    private int[] m_protocolIDs;
    private Hashtable m_endpoints;
    private Hashtable m_enabled;
    private int[] m_ids;
    private IPRange[] m_ranges;
    Hashtable m_namedOptions = null;
    boolean m_supportsNamedOptions = false;
    ServerAdministration m_serverAdmin = null;
    boolean m_bNamedOptionsModified = false;
    boolean m_bUsingSecureLDAP = false;

    public int getDBType() {
        return this.m_dbType;
    }

    public void setDBType(int n) {
        this.m_dbType = n;
    }

    public String getDBDSN() {
        return this.m_dsn;
    }

    public void setDBDSN(String string) {
        this.m_dsn = string;
    }

    public int getDBPooledConnections() {
        return this.m_pooledConnections;
    }

    public void setDBPooledConnections(int n) {
        this.m_pooledConnections = n;
    }

    public boolean getDBTransactionsEnabled() {
        return !this.m_disableTransactions;
    }

    public void setDBTransactionsEnabled(boolean bl) {
        this.m_disableTransactions = !bl;
    }

    public String getServerGUID() {
        return this.m_serverGUID;
    }

    public void setServerGUID(String string) {
        this.m_serverGUID = string;
    }

    public String getCipher() {
        return this.m_cipher;
    }

    public void setCipher(String string) {
        this.m_cipher = string;
    }

    public String getLogFile() {
        return this.m_systemLog;
    }

    public void setLogFile(String string) {
        this.m_systemLog = string;
    }

    public String getRepositoryPath() {
        return this.m_repositoryPath;
    }

    public void setRepositoryPath(String string) {
        this.m_repositoryPath = string;
    }

    public boolean getEnableDiagnostics() {
        return this.m_enableDiagnostics;
    }

    public void setEnableDiagnostics(boolean bl) {
        this.m_enableDiagnostics = bl;
    }

    public int getLogonTimeout() {
        return this.m_logonTimeout;
    }

    public void setLogonTimeout(int n) {
        this.m_logonTimeout = n;
    }

    public int getInactivityTimeout() {
        return this.m_inactivityTimeout;
    }

    public void setInactivityTimeout(int n) {
        this.m_inactivityTimeout = n;
    }

    public int getReconnectTimeout() {
        return this.m_reconnectTimeout;
    }

    public void setReconnectTimeout(int n) {
        this.m_reconnectTimeout = n;
    }

    public boolean getNoTimeoutNamedLicenses() {
        return this.m_noTimeoutNamedLicenses;
    }

    public void setNoTimeoutNamedLicenses(boolean bl) {
        this.m_noTimeoutNamedLicenses = bl;
    }

    public String getVaultDirectory() {
        return this.m_vaultDirectory;
    }

    public void setVaultDirectory(String string) {
        this.m_vaultDirectory = string;
    }

    public String getCacheDirectory() {
        return this.m_cacheDirectory;
    }

    public void setCacheDirectory(String string) {
        this.m_cacheDirectory = string;
    }

    public String getArchiveDirectory() {
        return this.m_archiveDirectory;
    }

    public void setArchiveDirectory(String string) {
        this.m_archiveDirectory = string;
    }

    public String getMultiPartDirectory() {
        return this.m_multiPartDirectory;
    }

    public void setMultiPartDirectory(String string) {
        this.m_multiPartDirectory = string;
    }

    public int getVaultLockTimeLimit() {
        return this.m_lockTimeout;
    }

    public void setVaultLockTimeLimit(int n) {
        this.m_lockTimeout = n;
    }

    public int getVaultCacheMaxSize() {
        return this.m_cacheMax;
    }

    public void setVaultCacheMaxSize(int n) {
        this.m_cacheMax = n;
    }

    public int getVaultCacheRefreshInterval() {
        return this.m_cacheRefreshInterval;
    }

    public void setVaultCacheRefreshInterval(int n) {
        this.m_cacheRefreshInterval = n;
    }

    public int getFileStatusAutoPurgeDays() {
        return this.m_syncAutoPurgeDays;
    }

    public void setFileStatusAutoPurgeDays(int n) {
        this.m_syncAutoPurgeDays = n;
    }

    public boolean getDBVerifyOnStartup() {
        return this.m_verifyDB;
    }

    public void setDBVerifyOnStartup(boolean bl) {
        this.m_verifyDB = bl;
    }

    public boolean getDBAutoRecovery() {
        return this.m_autoRecovery;
    }

    public void setDBAutoRecovery(boolean bl) {
        this.m_autoRecovery = bl;
    }

    public boolean getStopServerOnErrors() {
        return this.m_stopServerOnErrors;
    }

    public void setStopServerOnErrors(boolean bl) {
        this.m_stopServerOnErrors = bl;
    }

    public String getAttachmentDirectory() {
        return this.m_attachmentDirectory;
    }

    public void setAttachmentDirectory(String string) {
        this.m_attachmentDirectory = string;
    }

    public int getForeignRefreshRate() {
        return this.m_foreignRefreshRate;
    }

    public void setForeignRefreshRate(int n) {
        this.m_foreignRefreshRate = n;
    }

    public boolean getMailEnabled() {
        return this.m_enableMail;
    }

    public void setMailEnabled(boolean bl) {
        this.m_enableMail = bl;
    }

    public String getSMTPAddress() {
        return this.m_smtpAddress;
    }

    public void setSMTPAddress(String string) {
        this.m_smtpAddress = string;
    }

    public int getSMTPPort() {
        return this.m_smtpPort;
    }

    public void setSMTPPort(int n) {
        this.m_smtpPort = n;
    }

    public int getNotifyBy() {
        return this.m_NotifyBy;
    }

    public void setNotifyBy(int n) {
        this.m_NotifyBy = n;
    }

    private int getNotifyEmailFormat() {
        return this.m_NotifyEmailFormat;
    }

    private void setNotifyEmailFormat(int n) {
        this.m_NotifyEmailFormat = n;
    }

    public boolean getDirectoryServiceEnabled() {
        return this.m_bDirectoryEnabled;
    }

    public void setDirectoryServiceEnabled(boolean bl) {
        this.m_bDirectoryEnabled = bl;
    }

    public String getDirectoryServiceHost() {
        return this.m_directoryUrl;
    }

    public void setDirectoryServiceHost(String string) {
        this.m_directoryUrl = string;
    }

    public int getDirectoryServicePort() {
        return this.m_directoryPort;
    }

    public void setDirectoryServicePort(int n) {
        this.m_directoryPort = n;
    }

    public boolean getUsingSecureDirectoryService() {
        return this.m_bUsingSecureLDAP;
    }

    public void setUsingSecureDirectoryService(boolean bl) {
        this.m_bUsingSecureLDAP = bl;
    }

    public boolean getAuditsEnabled() {
        return this.m_enableAudit;
    }

    public void setAuditsEnabled(boolean bl) {
        this.m_enableAudit = bl;
    }

    public int getAuditsAutoPurgeDays() {
        return this.m_auditAutoPurgeDays;
    }

    public void setAuditsAutoPurgeDays(int n) {
        this.m_auditAutoPurgeDays = n;
    }

    public void setEnabled(int n, boolean bl) {
        this.ensureAvailable(n);
        this.m_enabled.put(new Integer(n), new Boolean(bl));
    }

    public boolean getEnabled(int n) {
        this.ensureAvailable(n);
        return (Boolean)this.m_enabled.get(new Integer(n));
    }

    public void setEndPoint(int n, String string) {
        this.ensureAvailable(n);
        this.m_endpoints.put(new Integer(n), string);
    }

    public String getEndPoint(int n) {
        this.ensureAvailable(n);
        return (String)this.m_endpoints.get(new Integer(n));
    }

    public boolean isProtocolAvailable(int n) {
        int n2 = 0;
        while (n2 < this.m_ids.length) {
            if (this.m_ids[n2] == n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    static boolean isValidProtocol(int n) {
        return n >= 1 && n <= 7;
    }

    private void ensureAvailable(int n) {
        if (ServerConfiguration.isValidProtocol(n)) {
            if (!this.isProtocolAvailable(n)) {
                throw new IllegalArgumentException(Res.formatKey(ResIDs.PROTOCOL_NOT_AVAILABLE_FMT, new Object[]{new Integer(n)}));
            }
        } else {
            throw new IllegalArgumentException(Res.formatKey(ResIDs.INVALID_PROTOCOL_FMT, new Object[]{new Integer(n)}));
        }
    }

    public IPRange[] getEncryptionRequirements() {
        return this.m_ranges;
    }

    public void setEncryptionRequirements(IPRange[] iPRangeArray) {
        if (iPRangeArray == null) {
            Assert.nullArgument("IPRange[]");
        }
        this.m_ranges = iPRangeArray;
    }

    static ServerConfiguration read(Command command) throws IOException {
        ServerConfiguration serverConfiguration = new ServerConfiguration();
        serverConfiguration.readGuts(command);
        return serverConfiguration;
    }

    void readGuts(Command command) throws IOException {
        this.m_dsn = command.readString();
        this.m_dbType = command.readInt();
        this.m_pooledConnections = command.readInt();
        this.m_disableTransactions = command.readBoolean();
        this.m_serverGUID = command.readString();
        this.m_cipher = command.readString();
        this.m_repositoryPath = command.readString();
        this.m_systemLog = command.readString();
        this.m_enableDiagnostics = command.readBoolean();
        this.m_logonTimeout = command.readInt();
        this.m_inactivityTimeout = command.readInt();
        if (command.supports((short)100, "1.10")) {
            this.m_reconnectTimeout = command.readInt();
        }
        if (command.supports((short)100, "1.15")) {
            this.m_noTimeoutNamedLicenses = command.readBoolean();
        }
        this.m_vaultDirectory = command.readString();
        this.m_cacheDirectory = command.readString();
        this.m_archiveDirectory = command.readString();
        this.m_multiPartDirectory = command.readString();
        this.m_lockTimeout = command.readInt();
        this.m_cacheMax = command.readInt();
        this.m_cacheRefreshInterval = command.readInt();
        this.m_syncAutoPurgeDays = command.readInt();
        if (command.getRevisionLevel() >= 57) {
            this.m_verifyDB = command.readBoolean();
            this.m_autoRecovery = command.readBoolean();
            this.m_stopServerOnErrors = command.readBoolean();
        }
        this.m_foreignRefreshRate = command.readInt();
        this.m_attachmentDirectory = command.readString();
        this.m_enableMail = command.readBoolean();
        if (command.getRevisionLevel() >= 63) {
            this.m_smtpAddress = command.readString();
            this.m_smtpPort = command.readInt();
        }
        this.m_enableAudit = command.readBoolean();
        this.m_auditAutoPurgeDays = command.readInt();
        this.m_webLogging = command.readBoolean();
        this.m_webLogginBrief = command.readInt();
        this.m_webLoggingFile = command.readString();
        if (command.getRevisionLevel() >= 66) {
            this.m_NotifyBy = command.readInt();
            this.m_NotifyEmailFormat = command.readInt();
        }
        if (command.supports((short)100, "1.11")) {
            this.m_bDirectoryEnabled = command.readBoolean();
            this.m_directoryUrl = command.readString();
            this.m_directoryPort = command.readInt();
        }
        if (command.supports((short)100, "1.19")) {
            this.m_bUsingSecureLDAP = command.readBoolean();
        }
        int n = command.readInt();
        this.m_protocolIDs = new int[n];
        int n2 = 0;
        while (n2 < n) {
            this.m_protocolIDs[n2] = command.readInt();
            ++n2;
        }
        this.m_endpoints = new Hashtable();
        this.m_enabled = new Hashtable();
        n = command.readInt();
        this.m_ids = new int[n];
        n2 = 0;
        while (n2 < n) {
            int n3 = command.readInt();
            boolean bl = command.readBoolean();
            String string = command.readString();
            Integer n4 = new Integer(n3);
            this.m_ids[n2] = n3;
            this.m_enabled.put(n4, new Boolean(bl));
            this.m_endpoints.put(n4, string);
            ++n2;
        }
        n = command.readInt();
        this.m_ranges = new IPRange[n];
        n2 = 0;
        while (n2 < n) {
            this.m_ranges[n2] = IPRange.read(command);
            ++n2;
        }
    }

    void writeGuts(Command command) throws IOException {
        command.writeString(this.m_dsn);
        command.writeInt(this.m_dbType);
        command.writeInt(this.m_pooledConnections);
        command.writeBoolean(this.m_disableTransactions);
        command.writeString(this.m_serverGUID);
        command.writeString(this.m_cipher);
        command.writeString(this.m_repositoryPath);
        command.writeString(this.m_systemLog);
        command.writeBoolean(this.m_enableDiagnostics);
        command.writeInt(this.m_logonTimeout);
        command.writeInt(this.m_inactivityTimeout);
        if (command.supports((short)100, "1.10")) {
            command.writeInt(this.m_reconnectTimeout);
        }
        if (command.supports((short)100, "1.15")) {
            command.writeBoolean(this.m_noTimeoutNamedLicenses);
        }
        command.writeString(this.m_vaultDirectory);
        command.writeString(this.m_cacheDirectory);
        command.writeString(this.m_archiveDirectory);
        command.writeString(this.m_multiPartDirectory);
        command.writeInt(this.m_lockTimeout);
        command.writeInt(this.m_cacheMax);
        command.writeInt(this.m_cacheRefreshInterval);
        command.writeInt(this.m_syncAutoPurgeDays);
        if (command.getRevisionLevel() >= 57) {
            command.writeBoolean(this.m_verifyDB);
            command.writeBoolean(this.m_autoRecovery);
            command.writeBoolean(this.m_stopServerOnErrors);
        }
        command.writeInt(this.m_foreignRefreshRate);
        command.writeString(this.m_attachmentDirectory);
        command.writeBoolean(this.m_enableMail);
        if (command.getRevisionLevel() >= 63) {
            command.writeString(this.m_smtpAddress);
            command.writeInt(this.m_smtpPort);
        }
        command.writeBoolean(this.m_enableAudit);
        command.writeInt(this.m_auditAutoPurgeDays);
        command.writeBoolean(this.m_webLogging);
        command.writeInt(this.m_webLogginBrief);
        command.writeString(this.m_webLoggingFile);
        if (command.getRevisionLevel() >= 66) {
            command.writeInt(this.m_NotifyBy);
            command.writeInt(this.m_NotifyEmailFormat);
        }
        if (command.supports((short)100, "1.11")) {
            command.writeBoolean(this.m_bDirectoryEnabled);
            command.writeString(this.m_directoryUrl);
            command.writeInt(this.m_directoryPort);
        }
        if (command.supports((short)100, "1.19")) {
            command.writeBoolean(this.m_bUsingSecureLDAP);
        }
        int n = this.m_protocolIDs.length;
        command.writeInt(n);
        int n2 = 0;
        while (n2 < n) {
            command.writeInt(this.m_protocolIDs[n2]);
            ++n2;
        }
        n = this.m_ids.length;
        command.writeInt(n);
        n2 = 0;
        while (n2 < n) {
            int n3 = this.m_ids[n2];
            Integer n4 = new Integer(n3);
            command.writeInt(n3);
            command.writeBoolean((Boolean)this.m_enabled.get(n4));
            command.writeString((String)this.m_endpoints.get(n4));
            ++n2;
        }
        n = this.m_ranges.length;
        command.writeInt(n);
        n2 = 0;
        while (n2 < n) {
            this.m_ranges[n2].writeGuts(command);
            ++n2;
        }
    }

    public boolean getTraceExpensiveOperations() {
        if (this.m_supportsNamedOptions) {
            String string = (String)this.getNamedOptions().get(TRACE_OPS_NAME);
            return string.equals("1");
        }
        return false;
    }

    public void setTraceExpensiveOperations(boolean bl) {
        if (this.m_supportsNamedOptions) {
            String string = bl ? "1" : "0";
            this.getNamedOptions().put(TRACE_OPS_NAME, string);
            this.m_bNamedOptionsModified = true;
        }
    }

    public int getExpensiveOperationMinimum() {
        if (this.m_supportsNamedOptions) {
            String string = (String)this.getNamedOptions().get(EXPENSIVE_OP_MIN);
            return string.equals(EMPTY) ? -1 : Integer.valueOf(string);
        }
        return -1;
    }

    public void setExpensiveOperationMinimum(int n) {
        if (this.m_supportsNamedOptions) {
            String string = new Integer(n).toString();
            this.getNamedOptions().put(EXPENSIVE_OP_MIN, string);
            this.m_bNamedOptionsModified = true;
        }
    }

    public boolean getDumpAsserts() {
        if (this.m_supportsNamedOptions) {
            String string = (String)this.getNamedOptions().get(DUMP_ASSERTS);
            return string.equals("1");
        }
        return false;
    }

    public void setDumpAsserts(boolean bl) {
        if (this.m_supportsNamedOptions) {
            String string = bl ? "1" : "0";
            this.getNamedOptions().put(DUMP_ASSERTS, string);
            this.m_bNamedOptionsModified = true;
        }
    }

    public boolean getDumpErrors() {
        if (this.m_supportsNamedOptions) {
            String string = (String)this.getNamedOptions().get(DUMP_ERRORS);
            return string.equals("1");
        }
        return false;
    }

    public void setDumpErrors(boolean bl) {
        if (this.m_supportsNamedOptions) {
            String string = bl ? "1" : "0";
            this.getNamedOptions().put(DUMP_ERRORS, string);
            this.m_bNamedOptionsModified = true;
        }
    }

    Hashtable getNamedOptions() {
        if (this.m_namedOptions == null) {
            String[] stringArray = new String[]{TRACE_OPS_NAME, EXPENSIVE_OP_MIN, DUMP_ASSERTS, DUMP_ERRORS};
            String[] stringArray2 = this.m_serverAdmin.getNamedConfigOptions(stringArray);
            this.m_namedOptions = new Hashtable();
            int n = 0;
            while (n < stringArray.length) {
                this.m_namedOptions.put(stringArray[n], stringArray2[n]);
                ++n;
            }
        }
        return this.m_namedOptions;
    }

    ServerConfiguration() {
    }
}

