/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.Item;
import com.starbase.starteam.QueryPart;
import com.starbase.starteam.Res;
import com.starbase.starteam.ResIDs;
import com.starbase.starteam.vts.comm.Command;
import com.starbase.util.Assert;
import java.io.IOException;

public class QueryNode {
    public static final int OP_AND = 0;
    public static final int OP_OR = 1;
    public static final int OP_NOT = 2;
    private int m_operator;
    private QueryPart[] m_parts = new QueryPart[0];
    private QueryNode[] m_nodes = new QueryNode[0];

    public QueryNode copyQueryNode() {
        QueryNode queryNode = new QueryNode();
        queryNode.m_operator = this.m_operator;
        QueryPart[] queryPartArray = new QueryPart[this.m_parts.length];
        int n = 0;
        while (n < queryPartArray.length) {
            queryPartArray[n] = this.m_parts[n].copyQueryPart();
            ++n;
        }
        queryNode.m_parts = queryPartArray;
        QueryNode[] queryNodeArray = new QueryNode[this.m_nodes.length];
        int n2 = 0;
        while (n2 < queryNodeArray.length) {
            queryNodeArray[n2] = this.m_nodes[n2].copyQueryNode();
            ++n2;
        }
        queryNode.m_nodes = queryNodeArray;
        return queryNode;
    }

    public int getOperator() {
        return this.m_operator;
    }

    public void setOperator(int n) {
        this.verifyOperator(n);
        this.m_operator = n;
    }

    public QueryPart[] getQueryParts() {
        return this.m_parts;
    }

    public void setQueryParts(QueryPart[] queryPartArray) {
        if (queryPartArray == null) {
            Assert.nullArgument("QueryPart[]");
        }
        this.m_parts = queryPartArray;
    }

    public void appendQueryPart(QueryPart queryPart) {
        int n = this.m_parts.length;
        QueryPart[] queryPartArray = new QueryPart[n + 1];
        int n2 = 0;
        while (n2 < n) {
            queryPartArray[n2] = this.m_parts[n2];
            ++n2;
        }
        queryPartArray[n] = queryPart;
        this.m_parts = queryPartArray;
    }

    public void clearQueryParts() {
        this.m_parts = new QueryPart[0];
    }

    public QueryNode[] getQueryNodes() {
        return this.m_nodes;
    }

    public void setQueryNodes(QueryNode[] queryNodeArray) {
        if (queryNodeArray == null) {
            Assert.nullArgument("QueryNode[]");
        }
        this.m_nodes = queryNodeArray;
    }

    public void appendQueryNode(QueryNode queryNode) {
        int n = this.m_nodes.length;
        QueryNode[] queryNodeArray = new QueryNode[n + 1];
        int n2 = 0;
        while (n2 < n) {
            queryNodeArray[n2] = this.m_nodes[n2];
            ++n2;
        }
        queryNodeArray[n] = queryNode;
        this.m_nodes = queryNodeArray;
    }

    public void clearQueryNodes() {
        this.m_nodes = new QueryNode[0];
    }

    public String toString() {
        return this.toDebugString();
    }

    public String toDebugString() {
        return this.toDebugStringDepth(0);
    }

    public String toDebugStringDepth(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        String string2 = this.indent(n);
        stringBuffer.append(string2 + "(");
        switch (this.m_operator) {
            case 1: {
                stringBuffer.append("OR");
                break;
            }
            case 0: {
                stringBuffer.append("AND");
                break;
            }
            case 2: {
                stringBuffer.append("NOT");
                break;
            }
            default: {
                stringBuffer.append("?op=" + this.m_operator);
                break;
            }
        }
        stringBuffer.append(string);
        String string3 = this.indent(n + 1);
        int n2 = 0;
        while (n2 < this.m_parts.length) {
            stringBuffer.append(string3 + this.m_parts[n2].toDebugString() + string);
            ++n2;
        }
        n2 = 0;
        while (n2 < this.m_nodes.length) {
            stringBuffer.append(this.m_nodes[n2].toDebugStringDepth(n + 1));
            stringBuffer.append(string);
            ++n2;
        }
        stringBuffer.append(string2 + ")");
        return stringBuffer.toString();
    }

    public boolean evaluate(Item item) {
        boolean bl;
        if (this.m_operator == 2) {
            if (this.m_parts.length == 1) {
                return !this.m_parts[0].evaluate(item);
            }
            if (this.m_nodes.length == 1) {
                return !this.m_nodes[0].evaluate(item);
            }
            return false;
        }
        boolean bl2 = this.m_operator == 0;
        int n = 0;
        while (n < this.m_parts.length) {
            bl = this.m_parts[n].evaluate(item);
            if (bl2) {
                if (!bl) {
                    return false;
                }
            } else if (bl) {
                return true;
            }
            ++n;
        }
        n = 0;
        while (n < this.m_nodes.length) {
            bl = this.m_nodes[n].evaluate(item);
            if (bl2) {
                if (!bl) {
                    return false;
                }
            } else if (bl) {
                return true;
            }
            ++n;
        }
        return bl2;
    }

    private String indent(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append("  ");
            ++n2;
        }
        return stringBuffer.toString();
    }

    private void verifyOperator(int n) {
        if (n != 0 && n != 1 && n != 2) {
            String string = Res.formatKey(ResIDs.LIST_FMT, new Object[]{"OP_AND", "OP_OR"});
            string = Res.formatKey(ResIDs.LIST_FMT, new Object[]{string, "OP_NOT"});
            throw new IllegalArgumentException(Res.formatKey(ResIDs.INVALID_QUERY_OPERATOR_FMT, new Object[]{new Integer(n), string}));
        }
    }

    static QueryNode read(Command command) throws IOException {
        QueryNode queryNode = new QueryNode();
        queryNode.readGuts(command);
        return queryNode;
    }

    private void readGuts(Command command) throws IOException {
        this.m_operator = command.readInt();
        int n = command.readInt();
        this.m_parts = new QueryPart[n];
        int n2 = 0;
        while (n2 < n) {
            this.m_parts[n2] = QueryPart.read(command);
            ++n2;
        }
        n = command.readInt();
        this.m_nodes = new QueryNode[n];
        n2 = 0;
        while (n2 < n) {
            this.m_nodes[n2] = QueryNode.read(command);
            ++n2;
        }
    }

    void writeGuts(Command command) throws IOException {
        command.writeInt(this.m_operator);
        int n = this.m_parts.length;
        command.writeInt(n);
        int n2 = 0;
        while (n2 < n) {
            this.m_parts[n2].writeGuts(command);
            ++n2;
        }
        n = this.m_nodes.length;
        command.writeInt(n);
        n2 = 0;
        while (n2 < n) {
            this.m_nodes[n2].writeGuts(command);
            ++n2;
        }
    }

    protected boolean isEqualTo(QueryNode queryNode) {
        if (queryNode != null && this.getOperator() == queryNode.getOperator()) {
            QueryPart[] queryPartArray;
            QueryNode[] queryNodeArray;
            QueryNode[] queryNodeArray2 = this.getQueryNodes();
            if (queryNodeArray2.length != (queryNodeArray = queryNode.getQueryNodes()).length) {
                return false;
            }
            QueryPart[] queryPartArray2 = this.getQueryParts();
            if (queryPartArray2.length != (queryPartArray = queryNode.getQueryParts()).length) {
                return false;
            }
            int n = queryNodeArray2.length;
            int n2 = 0;
            while (n2 < n) {
                if (!queryNodeArray2[n2].isEqualTo(queryNodeArray2[n2])) {
                    return false;
                }
                ++n2;
            }
            n = queryPartArray2.length;
            n2 = 0;
            while (n2 < n) {
                if (!queryPartArray2[n2].isEqualTo(queryPartArray[n2])) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    public QueryNode(int n) {
        this.verifyOperator(n);
        this.m_operator = n;
    }

    private QueryNode() {
    }
}

