/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.Item;
import com.starbase.util.Assert;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class Query {
    private Type m_type;
    private Hashtable m_params = new Hashtable();

    public static final Query newQueryContainedBy(String string, Object object) {
        Query query = new Query(Types.CONTAINED_BY);
        query.putParameter(ParameterKeys.TYPE, string);
        query.putParameter(ParameterKeys.CONTAINER, object);
        return query;
    }

    public static final Query newBulkQueryContainedBy(String string, Vector vector) {
        if (vector == null) {
            Assert.internalError("Query.newBulkQueryContainedBy(), containers=null");
        }
        if (vector.isEmpty()) {
            Assert.internalError("Query.newBulkQueryContainedBy(), containers.isEmpty()");
        }
        Query query = new Query(Types.BULK_CONTAINED_BY);
        query.putParameter(ParameterKeys.TYPE, string);
        query.putParameter(ParameterKeys.CONTAINER_LIST, vector);
        return query;
    }

    public static final Query newQueryForID(String string, int n) {
        Query query = new Query(Types.FOR_ID);
        query.putParameter(ParameterKeys.TYPE, string);
        query.putParameter(ParameterKeys.ID, new Integer(n));
        return query;
    }

    public static final Query newQueryAllOfType(String string) {
        Query query = new Query(Types.ALL_OF_TYPE);
        query.putParameter(ParameterKeys.TYPE, string);
        return query;
    }

    public static final Query newQueryVersionsOf(Item item) {
        Query query = new Query(Types.VERSIONS_OF);
        query.putParameter(ParameterKeys.VERSIONED_OBJECT, item);
        return query;
    }

    public Type getType() {
        return this.m_type;
    }

    private void putParameter(Key key, Object object) {
        this.m_params.put(key, object);
    }

    public Object getParameter(Key key) {
        return this.m_params.get(key);
    }

    public String debugDump() {
        StringBuffer stringBuffer = new StringBuffer(300);
        String string = System.getProperty("line.separator");
        stringBuffer.append(super.toString() + string);
        stringBuffer.append(" Type: " + this.m_type + string);
        Enumeration enumeration = this.m_params.keys();
        Enumeration enumeration2 = this.m_params.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(" " + enumeration.nextElement() + " = " + enumeration2.nextElement() + string);
        }
        return stringBuffer.toString();
    }

    private Query(Type type) {
        this.m_type = type;
    }

    static class Type {
        private String m_name;

        public boolean equals(Object object) {
            return object != null && object instanceof Type && this.m_name.equals(((Type)object).m_name);
        }

        public String toString() {
            return this.m_name;
        }

        Type(String string) {
            this.m_name = string;
        }
    }

    static class Key {
        private String m_name;

        public boolean equals(Object object) {
            return object != null && object instanceof Key && this.m_name.equals(((Key)object).m_name);
        }

        public String toString() {
            return this.m_name;
        }

        Key(String string) {
            this.m_name = string;
        }
    }

    static interface Types {
        public static final Type BULK_CONTAINED_BY = new Type("BulkContainedBy");
        public static final Type CONTAINED_BY = new Type("ContainedBy");
        public static final Type FOR_ID = new Type("ForID");
        public static final Type ALL_OF_TYPE = new Type("AllOfType");
        public static final Type VERSIONS_OF = new Type("VersionsOf");
    }

    static interface ParameterKeys {
        public static final Key TYPE = new Key("Type");
        public static final Key CONTAINER = new Key("Container");
        public static final Key CONTAINER_LIST = new Key("ContainerList");
        public static final Key ID = new Key("ID");
        public static final Key ID_LIST = new Key("IDList");
        public static final Key VERSIONED_OBJECT = new Key("VersionedObject");
    }
}

