/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.MPXEvent;
import com.starbase.starteam.MPXException;

class MPXServerControlEvent
extends MPXEvent {
    public static final int UNKNOWN = 0;
    public static final int SERVER_STARTUP = 1;
    public static final int SERVER_SHUTDOWN = 2;
    public static final int TRANSMITTER_ONLINE = 11;
    public static final int TRANSMITTER_OFFLINE = 12;
    private int m_controlFunction = 0;

    public int getControlFunction() {
        return this.m_controlFunction;
    }

    public String toString() {
        return super.toString() + " (" + MPXServerControlEvent.controlFunctionToString(this.getControlFunction()) + ")";
    }

    private static String controlFunctionToString(int n) {
        if (n == 1) {
            return "ServerStartup";
        }
        if (n == 2) {
            return "ServerShutdown";
        }
        if (n == 11) {
            return "TransmitterOnline";
        }
        if (n == 12) {
            return "TransmitterOffline";
        }
        return "nFunction=" + n;
    }

    MPXServerControlEvent(String string) throws MPXException {
        super(string);
        String string2 = MPXEvent.getRequiredString(this.m_eventData, "ServerControl");
        this.m_controlFunction = string2.equals("ServerStartup") ? 1 : (string2.equals("ServerShutdown") ? 2 : 0);
        this.dump();
    }

    MPXServerControlEvent(int n) {
        super("ServerControl", "", "");
        this.m_controlFunction = n;
        this.dump();
    }
}

